/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.framestore.QuantifierRestrictionUpdater;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import java.util.Collection;
import java.util.Collections;

class AllValuesFromRestrictionUpdater
extends QuantifierRestrictionUpdater {
    private Cls metaCls;
    private Facet valueTypeFacet;

    AllValuesFromRestrictionUpdater(AbstractOWLModel owlModel) {
        super(owlModel);
        this.metaCls = owlModel.getCls("owl:AllValuesFromRestriction");
        this.valueTypeFacet = owlModel.getFacet(":VALUE-TYPE");
    }

    private void addAllRestriction(Cls cls, RDFProperty property, Cls allCls) {
        OWLAllValuesFrom restriction = this.owlModel.createOWLAllValuesFrom(property, (RDFSClass)allCls);
        cls.addDirectSuperclass((Cls)restriction);
        this.log("+ OWLAllValuesFrom " + restriction.getBrowserText() + " to " + cls.getName() + "." + property.getName());
    }

    protected void clearFiller(OWLQuantifierRestriction restriction) {
        this.owlModel.setTemplateSlotAllowedClses(restriction, restriction.getOnProperty(), Collections.EMPTY_LIST);
    }

    public void copyFacetValuesIntoNamedClass(RDFSNamedClass cls, OWLRestriction restriction) {
        RDFProperty slot = restriction.getOnProperty();
        this.updateValueTypeFacet(cls, slot);
    }

    private void removeValueTypeOverride(RDFSNamedClass cls, Slot slot) {
        if (slot != null && cls.hasDirectlyOverriddenTemplateFacet(slot, this.valueTypeFacet)) {
            cls.setTemplateSlotAllowedClses(slot, Collections.EMPTY_LIST);
            cls.setTemplateFacetValues(slot, this.valueTypeFacet, Collections.EMPTY_LIST);
            this.log("- Removed :VALUE-TYPE override from " + cls.getName() + "." + slot.getName());
        }
    }

    private void setAllowedClses(RDFSNamedClass cls, Slot slot, Collection newAllowedClses) {
        this.log("+ Setting allowed clses of " + cls.getName() + "." + slot.getName());
        for (Cls ac : newAllowedClses) {
            this.log("  - " + ac.getBrowserText());
        }
        cls.setTemplateSlotAllowedClses(slot, newAllowedClses);
    }

    private void setAllowedValues(RDFSNamedClass cls, Slot slot, Collection newAllowedValues) {
        this.log("+ Setting allowed values of " + cls.getName() + "." + slot.getName());
        for (Object ac : newAllowedValues) {
            this.log("  - " + ac);
        }
        cls.setTemplateSlotAllowedValues(slot, newAllowedValues);
    }

    protected void updateAllRestrictions(Cls cls, RDFProperty property) {
        if (cls.hasDirectlyOverriddenTemplateFacet((Slot)property, this.valueTypeFacet)) {
            ValueType valueType = cls.getTemplateSlotValueType((Slot)property);
            if (valueType == ValueType.INSTANCE) {
                Collection clses = cls.getTemplateSlotAllowedClses((Slot)property);
                if (clses.size() == 0) {
                    this.removeRestrictions(cls, property, this.metaCls);
                    this.addAllRestriction(cls, property, this.owlModel.createOWLEnumeratedClass());
                } else {
                    this.ensureNoSurvivingClsesAreDeleted(cls, property, clses, this.metaCls);
                    if (clses.size() == 1) {
                        Cls allCls = (Cls)clses.iterator().next();
                        this.removeRestrictions(cls, property, this.metaCls);
                        this.addAllRestriction(cls, property, allCls);
                    } else {
                        OWLUnionClass unionCls = this.owlModel.createOWLUnionClass(clses);
                        this.removeRestrictions(cls, property, this.metaCls);
                        this.addAllRestriction(cls, property, unionCls);
                    }
                }
            } else if (valueType != ValueType.SYMBOL && valueType != ValueType.CLS) {
                this.removeRestrictions(cls, property, this.metaCls);
                RDFSDatatype datatype = this.owlModel.getRDFSDatatypeByURI(XMLSchemaDatatypes.getDefaultXSDDatatype(valueType).getURI());
                OWLAllValuesFrom restriction = this.owlModel.createOWLAllValuesFrom(property, datatype);
                cls.addDirectSuperclass((Cls)restriction);
                this.log("+ OWLAllValuesFrom " + restriction.getBrowserText() + " to " + cls.getName() + "." + property.getName());
            }
        } else {
            this.removeRestrictions(cls, property, this.metaCls);
        }
    }

    public void updateRestrictions(OWLNamedClass cls, RDFProperty property, Facet facet) {
        this.updateAllRestrictions(cls, property);
    }

    void updateValueTypeFacet(RDFSNamedClass cls, Slot slot) {
        if (slot != null) {
            Collection rs = this.getDirectRestrictions(cls, slot, OWLAllValuesFrom.class);
            if (rs.size() == 1) {
                OWLQuantifierRestriction restriction = (OWLQuantifierRestriction)rs.toArray()[0];
                this.updateValueTypeFacet(cls, slot, restriction);
            } else {
                this.removeValueTypeOverride(cls, slot);
            }
        }
    }

    private void updateValueTypeFacet(RDFSNamedClass cls, Slot slot, OWLQuantifierRestriction restriction) {
        Collection oldAllowedValues;
        Collection oldAllowedClses;
        ValueType oldValueType;
        ValueType newValueType = oldValueType = cls.getTemplateSlotValueType(slot);
        Collection newAllowedClses = oldAllowedClses = cls.getTemplateSlotAllowedClses(slot);
        Collection newAllowedValues = oldAllowedValues = cls.getTemplateSlotAllowedValues(slot);
        RDFResource filler = restriction.getFiller();
        if (filler instanceof RDFSClass) {
            RDFSClass quantifierClass = (RDFSClass)filler;
            if ("rdfs:Literal".equals(quantifierClass.getName())) {
                newValueType = ValueType.ANY;
            } else {
                newValueType = ValueType.INSTANCE;
                newAllowedClses = this.getQuantifierClsClses(quantifierClass);
            }
        } else if (filler instanceof OWLDataRange) {
            newAllowedValues = ((OWLDataRange)filler).getOneOf().getValues();
            newValueType = ValueType.SYMBOL;
        } else {
            RDFSDatatype datatype = (RDFSDatatype)filler;
            if (datatype.equals(this.owlModel.getRDFXMLLiteralType())) {
                newValueType = ValueType.STRING;
            } else {
                String uri = XMLSchemaDatatypes.getXSDDatatype(datatype).getURI();
                newValueType = XMLSchemaDatatypes.getValueType(uri);
            }
        }
        if (oldValueType == newValueType) {
            if (newValueType == ValueType.INSTANCE && !oldAllowedClses.equals(newAllowedClses)) {
                this.setAllowedClses(cls, slot, newAllowedClses);
            } else if (newValueType == ValueType.SYMBOL && !oldAllowedValues.equals(newAllowedValues)) {
                this.setAllowedValues(cls, slot, newAllowedValues);
            }
        } else {
            this.log("+ Setting :VALUE-TYPE of " + cls.getName() + "." + slot.getName() + " to " + newValueType);
            cls.setTemplateSlotValueType(slot, newValueType);
            if (newValueType == ValueType.INSTANCE) {
                this.setAllowedClses(cls, slot, newAllowedClses);
            } else if (newValueType == ValueType.SYMBOL) {
                this.setAllowedValues(cls, slot, newAllowedValues);
            }
        }
    }
}

