/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLProperty;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;

public class DefaultOWLObjectProperty
extends AbstractOWLProperty
implements OWLObjectProperty {
    public DefaultOWLObjectProperty(KnowledgeBase kb, FrameID id) {
        super(kb, id);
    }

    public DefaultOWLObjectProperty() {
    }

    public void addUnionRangeClass(RDFSClass rangeClass) {
        ArrayList<RDFSClass> unionRange = new ArrayList<RDFSClass>(this.getUnionRangeClasses());
        if (!unionRange.contains(rangeClass)) {
            unionRange.add(rangeClass);
            this.setUnionRangeClasses(unionRange);
        }
    }

    public String getIconName() {
        if (this.isAnnotationProperty()) {
            return "AnnotationOWLObjectProperty";
        }
        return "OWLObjectProperty";
    }

    public Icon getInheritedIcon() {
        return OWLIcons.getImageIcon("OWLObjectPropertyInherited");
    }

    public Collection getUnionRange() {
        return this.getAllowedClses();
    }

    public boolean hasObjectRange() {
        return true;
    }

    public boolean isSymmetric() {
        RDFSNamedClass metaclass = this.getOWLModel().getRDFSNamedClass("owl:SymmetricProperty");
        return this.hasProtegeType(metaclass);
    }

    public boolean isTransitive() {
        RDFSNamedClass metaclass = this.getOWLModel().getRDFSNamedClass("owl:TransitiveProperty");
        return this.hasProtegeType(metaclass);
    }

    public void removeUnionRangeClass(RDFSClass rangeClass) {
        ArrayList unionRange = new ArrayList(this.getUnionRange());
        if (unionRange.contains(rangeClass)) {
            unionRange.remove(rangeClass);
            this.setUnionRangeClasses(unionRange);
        }
    }

    public void setSymmetric(boolean value) {
        RDFSNamedClass metaclass = this.getOWLModel().getRDFSNamedClass("owl:SymmetricProperty");
        this.updateRDFType(value, metaclass);
    }

    public void setTransitive(boolean value) {
        RDFSNamedClass metaclass = this.getOWLModel().getRDFSNamedClass("owl:TransitiveProperty");
        this.updateRDFType(value, metaclass);
    }

    public void accept(OWLModelVisitor visitor) {
        visitor.visitOWLObjectProperty(this);
    }
}

