/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.ArrayList;
import java.util.Iterator;

public class RDFListTestCase
extends AbstractJenaTestCase {
    public void testAppend() {
        RDFList li = this.owlModel.createRDFList();
        RDFListTestCase.assertEquals((int)0, (int)li.size());
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        RDFResource a = cls.createInstance("a");
        RDFResource b = cls.createInstance("b");
        RDFResource c = cls.createInstance("c");
        li.append(a);
        RDFListTestCase.assertEquals((int)1, (int)li.size());
        RDFListTestCase.assertEquals((Object)a, (Object)li.getFirst());
        RDFListTestCase.assertEquals((Object)this.owlModel.getRDFNil(), (Object)li.getRest());
        li.append(b);
        RDFListTestCase.assertEquals((int)2, (int)li.size());
        RDFListTestCase.assertEquals((Object)a, (Object)li.getFirst());
        RDFListTestCase.assertEquals((Object)b, (Object)li.getRest().getFirst());
        RDFListTestCase.assertEquals((Object)this.owlModel.getRDFNil(), (Object)li.getRest().getRest());
        li.append(c);
        RDFListTestCase.assertEquals((int)3, (int)li.size());
        RDFListTestCase.assertEquals((Object)a, (Object)li.getFirst());
        RDFListTestCase.assertEquals((Object)b, (Object)li.getRest().getFirst());
        RDFListTestCase.assertEquals((Object)c, (Object)li.getRest().getRest().getFirst());
        RDFListTestCase.assertEquals((Object)this.owlModel.getRDFNil(), (Object)li.getRest().getRest().getRest());
        li.delete();
    }

    public void testCreateAndDeleteListInstanceManually() {
        RDFSNamedClass listCls = this.owlModel.getRDFListClass();
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        RDFResource first = cls.createInstance("first");
        RDFResource second = cls.createInstance("second");
        int count = this.owlModel.getFrameCount();
        RDFList head = (RDFList)listCls.createDirectInstance(null);
        RDFListTestCase.assertNull((Object)head.getFirst());
        RDFListTestCase.assertNull((Object)head.getRest());
        head.setFirst(first);
        RDFListTestCase.assertEquals((Object)first, (Object)head.getFirst());
        RDFList rest = (RDFList)listCls.createDirectInstance(null);
        head.setRest(rest);
        RDFListTestCase.assertEquals((Object)rest, (Object)head.getRest());
        rest.setFirst(second);
        Iterator it = head.getValues().iterator();
        RDFListTestCase.assertEquals((Object)first, it.next());
        RDFListTestCase.assertEquals((Object)second, it.next());
        RDFListTestCase.assertFalse((boolean)it.hasNext());
        RDFListTestCase.assertEquals((int)2, (int)head.size());
        RDFListTestCase.assertTrue((boolean)head.contains(second));
        head.delete();
        RDFListTestCase.assertEquals((int)count, (int)this.owlModel.getFrameCount());
    }

    public void testCreateListInstanceThroughOKB() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        RDFResource first = cls.createInstance("first");
        RDFResource second = cls.createInstance("second");
        ArrayList<RDFResource> values = new ArrayList<RDFResource>();
        values.add(first);
        values.add(second);
        RDFList head = this.owlModel.createRDFList(values.iterator());
        RDFListTestCase.assertEquals((Object)first, (Object)head.getFirst());
        Iterator it = head.getValues().iterator();
        RDFListTestCase.assertEquals((Object)first, it.next());
        RDFListTestCase.assertEquals((Object)second, it.next());
        RDFListTestCase.assertFalse((boolean)it.hasNext());
        RDFListTestCase.assertEquals((int)2, (int)head.size());
        RDFListTestCase.assertTrue((boolean)head.contains(second));
        RDFListTestCase.assertEquals((String)"rdf:List (first, second)", (String)head.getBrowserText());
        head.delete();
    }

    public void testListSetup() {
        RDFSNamedClass listCls = this.owlModel.getRDFListClass();
        RDFListTestCase.assertEquals((String)"rdf:List", (String)listCls.getName());
        RDFListTestCase.assertEquals((int)1, (int)listCls.getDirectInstanceCount());
        Frame nil = (Frame)listCls.getDirectInstances().iterator().next();
        RDFListTestCase.assertEquals((Object)this.owlModel.getInstance("rdf:nil"), (Object)nil);
        Slot firstSlot = this.owlModel.getSlot("rdf:first");
        RDFListTestCase.assertEquals((Object)ValueType.ANY, (Object)firstSlot.getValueType());
        Slot restSlot = this.owlModel.getSlot("rdf:rest");
        RDFListTestCase.assertEquals((Object)ValueType.INSTANCE, (Object)restSlot.getValueType());
        RDFListTestCase.assertEquals((int)1, (int)restSlot.getAllowedClses().size());
        RDFListTestCase.assertEquals((Object)listCls, restSlot.getAllowedClses().iterator().next());
        RDFListTestCase.assertFalse((boolean)listCls.isEditable());
        RDFListTestCase.assertFalse((boolean)firstSlot.isEditable());
        RDFListTestCase.assertFalse((boolean)restSlot.isEditable());
        RDFListTestCase.assertFalse((boolean)nil.isEditable());
    }

    public void testSubclassOfList() {
        RDFSNamedClass listCls = this.owlModel.getRDFListClass();
        RDFSNamedClass subCls = this.owlModel.createRDFSNamedSubclass("MyList", listCls);
        Instance listInstance = subCls.createDirectInstance(null);
        RDFListTestCase.assertTrue((boolean)(listInstance instanceof RDFList));
    }

    public void testGetStart() {
        RDFList nodeA = this.owlModel.createRDFList();
        RDFList nodeB = this.owlModel.createRDFList();
        RDFList nodeC = this.owlModel.createRDFList();
        nodeA.setRest(nodeB);
        nodeB.setRest(nodeC);
        RDFListTestCase.assertEquals((Object)nodeA, (Object)nodeA.getStart());
        RDFListTestCase.assertEquals((Object)nodeA, (Object)nodeB.getStart());
        RDFListTestCase.assertEquals((Object)nodeA, (Object)nodeC.getStart());
    }
}

