/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.classform.component.property;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLExistentialRestriction;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.owltable.SymbolTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

public class PropertyFormTableModel
extends AbstractTableModel
implements Disposable,
SymbolTableModel {
    public static final int COL_FILLER = 0;
    private List rows = new ArrayList();
    private List restrictions = new ArrayList();
    private RDFSClass definition;
    private ClassListener listener = new ClassAdapter(){

        public void subclassAdded(RDFSClass cls, RDFSClass subclass) {
            PropertyFormTableModel.this.refill();
        }

        public void subclassRemoved(RDFSClass cls, RDFSClass subclass) {
            PropertyFormTableModel.this.refill();
        }

        public void superclassAdded(RDFSClass cls, RDFSClass superclass) {
            PropertyFormTableModel.this.refill();
        }

        public void superclassRemoved(RDFSClass cls, RDFSClass superclass) {
            PropertyFormTableModel.this.refill();
        }
    };
    private OWLNamedClass namedClass;
    private RDFProperty property;

    public PropertyFormTableModel(OWLNamedClass namedClass, RDFProperty property) {
        this(namedClass, property, null);
    }

    public PropertyFormTableModel(OWLNamedClass namedClass, RDFProperty property, RDFSClass definition) {
        this.namedClass = namedClass;
        this.property = property;
        this.definition = definition;
        namedClass.addClassListener(this.listener);
        this.addRows();
    }

    private void addRows() {
        assert (this.rows.isEmpty());
        Iterator rs = this.listRestrictions();
        while (rs.hasNext()) {
            OWLHasValue hasValue;
            Object filler;
            OWLRestriction restriction = (OWLRestriction)rs.next();
            if (restriction instanceof OWLSomeValuesFrom) {
                OWLSomeValuesFrom someValuesFrom = (OWLSomeValuesFrom)restriction;
                filler = someValuesFrom.getFiller();
                if (!(filler instanceof RDFSClass)) continue;
                this.rows.add(filler);
                this.restrictions.add(someValuesFrom);
                continue;
            }
            if (!(restriction instanceof OWLHasValue) || !((filler = (hasValue = (OWLHasValue)restriction).getHasValue()) instanceof RDFResource)) continue;
            this.rows.add(filler);
            this.restrictions.add(hasValue);
        }
        Collections.sort(this.rows, new Comparator(){

            public int compare(Object o1, Object o2) {
                RDFResource resource1 = (RDFResource)o1;
                RDFResource resource2 = (RDFResource)o2;
                if (!(resource1 instanceof OWLAnonymousClass)) {
                    if (resource2 instanceof OWLAnonymousClass) {
                        return -1;
                    }
                } else if (!(resource2 instanceof OWLAnonymousClass)) {
                    return 1;
                }
                return resource1.getBrowserText().compareTo(resource2.getBrowserText());
            }
        });
        this.fireTableRowsInserted(0, this.getRowCount() - 1);
    }

    public void dispose() {
        this.namedClass.removeClassListener(this.listener);
    }

    public int getColumnCount() {
        return 1;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        throw new IllegalArgumentException("Unknown column index " + columnIndex);
    }

    public Icon getIcon(RDFResource resource) {
        return ProtegeUI.getIcon(resource);
    }

    public OWLNamedClass getNamedClass() {
        return this.namedClass;
    }

    public RDFProperty getPredicate(int row) {
        return null;
    }

    public RDFProperty getProperty() {
        return this.property;
    }

    public RDFResource getRDFResource(int row) {
        return (RDFResource)this.rows.get(row);
    }

    public RDFResource getSubject() {
        return null;
    }

    public List getRDFResources() {
        return new ArrayList(this.rows);
    }

    public OWLExistentialRestriction getRestriction(int row) {
        return (OWLExistentialRestriction)this.restrictions.get(row);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getSymbolColumnIndex() {
        return 0;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.getRDFResource(rowIndex).getBrowserText();
        }
        throw new IllegalArgumentException("Unknown column index " + columnIndex);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    private Iterator listRestrictions() {
        return this.namedClass.getRestrictions(this.property, true).iterator();
    }

    private void refill() {
        if (this.getRowCount() > 0) {
            this.fireTableRowsDeleted(0, this.getRowCount() - 1);
        }
        this.restrictions.clear();
        this.rows.clear();
        this.addRows();
        this.fireTableDataChanged();
    }
}

