/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.individuals;

import edu.stanford.smi.protege.action.DeleteInstancesAction;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.individuals.InstancesList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.JScrollPane;

public class InferredInstancesListPanel
extends SelectableContainer {
    private AllowableAction deleteAction;
    private OWLLabeledComponent lc;
    private InstancesList list = new InstancesList(null);
    private Collection types;

    public InferredInstancesListPanel() {
        this.lc = new OWLLabeledComponent("Inferred Instances", new JScrollPane((Component)((Object)this.list)));
        this.deleteAction = new DeleteInstancesAction((Selectable)this){

            protected void onAfterDelete(Object o) {
                InferredInstancesListPanel.this.refill();
            }
        };
        this.deleteAction.putValue("SmallIcon", (Object)OWLIcons.getDeleteIcon("RDFIndividual"));
        this.lc.addHeaderButton((Action)this.deleteAction);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)this.lc));
        this.setSelectable(this.list);
    }

    public void dispose() {
    }

    private void refill() {
        HashSet set = new HashSet();
        for (RDFSClass type : this.types) {
            set.addAll(type.getInferredInstances(false));
        }
        ArrayList instances = new ArrayList(set);
        Collections.sort(instances, new FrameComparator());
        this.list.setListData(instances.toArray());
    }

    public void setTypes(Collection types) {
        this.types = types;
        this.refill();
    }
}

