/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.results;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.ui.StatusBar;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.results.HostResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanel;
import edu.stanford.smi.protegex.owl.ui.results.TripleDisplay;
import edu.stanford.smi.protegex.owl.ui.results.TripleDisplayUtil;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class ResultsPanelManager {
    public static void addResultsPanel(ResultsPanel resultsPanel, boolean replace) {
        ResultsPanelManager.addResultsPanel(null, resultsPanel, replace);
    }

    public static void addResultsPanel(OWLModel owlModel, ResultsPanel resultsPanel, boolean replace) {
        JTabbedPane tabbedPane;
        if (replace && (tabbedPane = ResultsPanelManager.getTabbedPane(owlModel)) != null) {
            int index = tabbedPane.getTabCount() - 1;
            while (index >= 0) {
                ResultsPanel other = (ResultsPanel)tabbedPane.getComponentAt(index);
                if (resultsPanel == other) {
                    tabbedPane.setSelectedIndex(index);
                    return;
                }
                if (other.isReplaceableBy(resultsPanel)) {
                    tabbedPane.remove(index);
                    tabbedPane.insertTab(resultsPanel.getTabName(), resultsPanel.getIcon(), resultsPanel, null, index);
                    tabbedPane.setSelectedIndex(index);
                    return;
                }
                --index;
            }
        }
        ResultsPanelManager.addResultsPanelToEnd(owlModel, resultsPanel);
    }

    private static void addResultsPanelToEnd(OWLModel owlModel, ResultsPanel resultsPanel) {
        JSplitPane splitPane = ResultsPanelManager.getSplitPane(owlModel);
        if (splitPane == null) {
            ProjectView projectView = ProtegeUI.getProjectView(owlModel.getProject());
            Component currentComp = projectView.getComponent(0);
            if (currentComp instanceof StatusBar) {
                currentComp = projectView.getComponent(1);
            }
            JTabbedPane tabbedPane = new JTabbedPane(3);
            tabbedPane.addTab(resultsPanel.getTabName(), resultsPanel.getIcon(), resultsPanel);
            tabbedPane.setSelectedIndex(tabbedPane.getTabCount() - 1);
            splitPane = new JSplitPane(0, currentComp, tabbedPane);
            splitPane.setOneTouchExpandable(true);
            splitPane.setDividerLocation(currentComp.getHeight() - 180);
            projectView.add("Center", (Component)splitPane);
            ResultsPanelManager.revalidate(projectView);
        } else {
            JTabbedPane tabbedPane = ResultsPanelManager.getTabbedPane(owlModel);
            tabbedPane.addTab(resultsPanel.getTabName(), resultsPanel.getIcon(), resultsPanel);
            tabbedPane.setSelectedIndex(tabbedPane.getTabCount() - 1);
        }
    }

    public static void closeResultsPanel(ResultsPanel resultsPanel) {
        ResultsPanelManager.closeResultsPanel(null, resultsPanel);
    }

    public static void closeResultsPanel(OWLModel owlModel, ResultsPanel resultsPanel) {
        Container comp = resultsPanel;
        while (!(comp instanceof JTabbedPane)) {
            comp = comp.getParent();
        }
        JTabbedPane tabbedPane = (JTabbedPane)comp;
        tabbedPane.remove(resultsPanel);
        resultsPanel.dispose();
        if (tabbedPane.getTabCount() == 0) {
            JSplitPane splitPane = ResultsPanelManager.getSplitPane(owlModel);
            Component mainTabs = splitPane.getLeftComponent();
            ProjectView projectView = ProtegeUI.getProjectView(tabbedPane);
            projectView.remove((Component)splitPane);
            projectView.add("Center", mainTabs);
            ResultsPanelManager.revalidate(projectView);
        }
    }

    public static ResultsPanel getResultsPanelByName(String tabName) {
        return ResultsPanelManager.getResultsPanelByName(null, tabName);
    }

    public static ResultsPanel getResultsPanelByName(OWLModel owlModel, String tabName) {
        JTabbedPane tabbedPane = ResultsPanelManager.getTabbedPane(owlModel);
        if (tabbedPane != null) {
            int i = 0;
            while (i < tabbedPane.getTabCount()) {
                ResultsPanel tab = (ResultsPanel)tabbedPane.getComponentAt(i);
                if (tabName.equals(tab.getTabName())) {
                    return tab;
                }
                ++i;
            }
        }
        return null;
    }

    public static JSplitPane getSplitPane(OWLModel owlModel) {
        ProjectView projectView = ProtegeUI.getProjectView(owlModel != null ? owlModel.getProject() : null);
        int i = 0;
        while (i < projectView.getComponentCount()) {
            Component currentComp = projectView.getComponent(i);
            if (currentComp instanceof JSplitPane) {
                return (JSplitPane)currentComp;
            }
            ++i;
        }
        return null;
    }

    public static JTabbedPane getTabbedPane(OWLModel owlModel) {
        JSplitPane splitPane = ResultsPanelManager.getSplitPane(owlModel);
        if (splitPane != null && splitPane.getComponentCount() > 1) {
            return (JTabbedPane)splitPane.getComponent(1);
        }
        return null;
    }

    private static void revalidate(ProjectView projectView) {
        projectView.getParent().invalidate();
        projectView.getParent().validate();
    }

    public static void setSelectedResultsPanel(OWLModel owlModel, ResultsPanel resultsPanel) {
        ResultsPanelManager.getTabbedPane(owlModel).setSelectedComponent(resultsPanel);
    }

    public static void showHostInstance(Instance hostInstance) {
        if (hostInstance instanceof RDFResource) {
            ResultsPanelManager.showHostResource((RDFResource)hostInstance);
        }
    }

    public static void showHostResource(RDFResource hostResource) {
        JSplitPane splitPane = ResultsPanelManager.getSplitPane(hostResource.getOWLModel());
        JTabbedPane tabbedPane = null;
        if (splitPane != null) {
            tabbedPane = (JTabbedPane)splitPane.getLeftComponent();
            int i = 0;
            while (i < tabbedPane.getTabCount()) {
                Component tab = tabbedPane.getComponentAt(i);
                if (tab instanceof HostResourceDisplay && ((HostResourceDisplay)((Object)tab)).displayHostResource(hostResource)) {
                    tabbedPane.setSelectedComponent(tab);
                    ((JComponent)tab).requestFocusInWindow();
                    return;
                }
                ++i;
            }
        }
        hostResource.getProject().show((Instance)hostResource);
    }

    public static TripleDisplay showTriple(Triple triple) {
        RDFResource subject = triple.getSubject();
        JSplitPane splitPane = ResultsPanelManager.getSplitPane(subject.getOWLModel());
        JTabbedPane tabbedPane = null;
        if (splitPane != null) {
            tabbedPane = (JTabbedPane)splitPane.getLeftComponent();
            int i = 0;
            while (i < tabbedPane.getTabCount()) {
                Component tab = tabbedPane.getComponentAt(i);
                TripleDisplay tripleDisplay = TripleDisplayUtil.displayTriple(tab, triple);
                if (tripleDisplay != null) {
                    tabbedPane.setSelectedComponent(tab);
                    ((JComponent)tab).requestFocusInWindow();
                    return tripleDisplay;
                }
                ++i;
            }
        }
        ResultsPanelManager.showHostResource(subject);
        return null;
    }
}

