/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter;

import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.util.RepositoryFileManager;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.OWLModelOrderedWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.OWLModelWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Iterator;

public class OWLModelAllTripleStoresWriter {
    private OWLModel model;
    private URI uri;
    private boolean ordered;

    public OWLModelAllTripleStoresWriter(OWLModel model, URI mainFileURI, boolean ordered) {
        this.model = model;
        this.uri = mainFileURI;
        this.ordered = ordered;
    }

    public void write() throws Exception {
        Iterator ts = this.model.getTripleStoreModel().listUserTripleStores();
        TripleStore mainTS = (TripleStore)ts.next();
        File file = new File(this.uri);
        FileOutputStream mainOS = new FileOutputStream(file);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)mainOS, FileUtilities.getWriteEncoding());
        BufferedWriter bw = new BufferedWriter(osw);
        OWLModelWriter mainWriter = this.getOwlModelWriter(mainTS, bw);
        mainWriter.getXmlWriter().setEncoding(osw.getEncoding());
        mainWriter.write();
        bw.flush();
        bw.close();
        while (ts.hasNext()) {
            TripleStore tripleStore = (TripleStore)ts.next();
            String name = tripleStore.getName();
            URI ontologyName = new URI(name);
            Repository rep = this.model.getRepositoryManager().getRepository(ontologyName);
            if (rep == null || !rep.isWritable(ontologyName)) continue;
            System.out.println("Saving import " + ontologyName + " to " + rep.getOntologyLocationDescription(ontologyName));
            OutputStream os = rep.getOutputStream(ontologyName);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(os, FileUtilities.getWriteEncoding());
            bw = new BufferedWriter(outputStreamWriter);
            OWLModelWriter omw = this.getOwlModelWriter(tripleStore, bw);
            omw.getXmlWriter().setEncoding(outputStreamWriter.getEncoding());
            omw.write();
            bw.flush();
            bw.close();
        }
        RepositoryFileManager fm = new RepositoryFileManager(this.model);
        fm.saveGlobalRepositories();
        fm.saveProjectRepositories(this.uri);
        System.out.println("... saving successful.");
    }

    private OWLModelWriter getOwlModelWriter(TripleStore ts, Writer writer) {
        if (this.ordered) {
            return new OWLModelOrderedWriter(this.model, ts, writer);
        }
        return new OWLModelWriter(this.model, ts, writer);
    }
}

