/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.db.rdf.model.i;

import edu.stanford.db.rdf.model.i.RDFNodeImpl;
import edu.stanford.db.xml.util.QName;
import org.w3c.rdf.model.ModelException;
import org.w3c.rdf.model.Resource;
import org.w3c.rdf.model.Statement;

public class ResourceImpl
extends RDFNodeImpl
implements Resource {
    protected QName qname;

    protected ResourceImpl() {
    }

    public ResourceImpl(int n, QName qName) throws ModelException {
        super(n);
        this.qname = qName;
        if (qName.getLocalName() == null) {
            throw new ModelException("Local name cannot be null");
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ResourceImpl) {
            return false;
        }
        if (!(object instanceof Resource) || object instanceof Statement) {
            return false;
        }
        Resource resource = (Resource)object;
        try {
            if (this.getNamespace() == null) {
                if (resource.getNamespace() == null) {
                    return this.getLocalName().equals(resource.getLocalName());
                }
                return this.getLocalName().equals(resource.getURI());
            }
            if (resource.getNamespace() != null) {
                return this.getLocalName().equals(resource.getLocalName()) && this.getNamespace().equals(resource.getNamespace());
            }
            return this.getURI().equals(resource.getURI());
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    public String getLabel() {
        return this.getURI();
    }

    public String getLocalName() {
        return this.qname.getLocalName();
    }

    public String getNamespace() {
        return this.qname.getNamespace();
    }

    public String getURI() {
        if (this.qname == null) {
            return "<null>";
        }
        return this.getNamespace() == null ? this.getLocalName() : String.valueOf(this.getNamespace()) + this.getLocalName();
    }
}

