/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.test.TestConnection;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.test.AbstractTestPrefixMapping;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestSuite;

public class TestPrefixMapping
extends AbstractTestPrefixMapping {
    private List models = null;
    private IDBConnection theConnection = null;
    private static int count = 0;

    public TestPrefixMapping(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestPrefixMapping.class);
    }

    public void setUp() {
        this.theConnection = TestConnection.makeAndCleanTestConnection();
        this.models = new ArrayList();
    }

    public void tearDown() {
        Iterator iterator = this.models.iterator();
        while (iterator.hasNext()) {
            Model model = (Model)iterator.next();
            model.close();
        }
        try {
            this.theConnection.close();
        }
        catch (Exception exception) {
            throw new JenaException(exception);
        }
    }

    private String getModelName() {
        return "test" + count++;
    }

    private Model getModel() {
        ModelRDB modelRDB = ModelRDB.createModel(this.theConnection, this.getModelName());
        this.models.add(modelRDB);
        return modelRDB;
    }

    public PrefixMapping getMapping() {
        Model model = this.getModel();
        return model.getGraph().getPrefixMapping();
    }

    public void testPrefixesPersist() {
        String string = "prefix-testing-model-persist";
        ModelRDB modelRDB = ModelRDB.createModel(this.theConnection, string);
        modelRDB.setNsPrefix("hello", "eh:/someURI#");
        modelRDB.setNsPrefix("bingo", "eh:/otherURI#");
        modelRDB.setNsPrefix("yendi", "eh:/otherURI#");
        modelRDB.close();
        ModelRDB modelRDB2 = ModelRDB.open(this.theConnection, string);
        TestPrefixMapping.assertEquals((String)"eh:/someURI#", (String)modelRDB2.getNsPrefixURI("hello"));
        TestPrefixMapping.assertEquals((String)"eh:/otherURI#", (String)modelRDB2.getNsPrefixURI("yendi"));
        TestPrefixMapping.assertEquals(null, (String)modelRDB2.getNsPrefixURI("bingo"));
        modelRDB2.close();
    }

    public void testPrefixesRemoved() {
        String string = "prefix-testing-model-remove";
        ModelRDB modelRDB = ModelRDB.createModel(this.theConnection, string);
        modelRDB.setNsPrefix("hello", "eh:/someURI#");
        modelRDB.setNsPrefix("there", "eg:/otherURI#");
        modelRDB.removeNsPrefix("hello");
        TestPrefixMapping.assertEquals(null, (String)modelRDB.getNsPrefixURI("hello"));
        modelRDB.close();
        ModelRDB modelRDB2 = ModelRDB.open(this.theConnection, string);
        TestPrefixMapping.assertEquals(null, (String)modelRDB2.getNsPrefixURI("hello"));
        TestPrefixMapping.assertEquals((String)"eg:/otherURI#", (String)modelRDB2.getNsPrefixURI("there"));
        modelRDB2.close();
    }
}

