/*
 * This source code is made available under the terms of the
 * Common Public License Version 1.0 distibuted along with the
 * source code package.
 */
package de.uka.cmtm.serviceregistry.query;

import java.util.EventObject;

/**
 * This event indicates that a class name provided as search parameter could not
 * be resolved to an ontology class.
 * 
 * @author tilmann
 */
public class ClassNotFoundEvent extends EventObject {
	
	private static final long serialVersionUID = 8691948283625004239L;
	
	private String className;

	public ClassNotFoundEvent(Object source, String className) {
		super(source);
		this.className = className;
	}

	public String getClassName() {
		return className;
	}

}
