/*
 * This source code is made available under the terms of the
 * Common Public License Version 1.0 distibuted along with the
 * source code package.
 */
package de.uka.cmtm.serviceregistry.plugin.views;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

import de.uka.cmtm.serviceregistry.RegistryController;
import de.uka.cmtm.serviceregistry.query.ServiceParameter;

/**
 * This View shows fields for configuration, publish and query parameters and
 * adds two buttons to invoke publish and query actions.
 */

public class RegistryView extends ViewPart {

	private Text queryBusinessNameText;

	private Text serviceCategoryText;

	private Text userRolesText;

	private Text inputsText;

	private Text outputsText;

	private Text preconditionsText;

	private Text effectsText;

	private Text serviceOntologyText;

	private Text upperOntologyText;

	private Text topOntologyText;

	private Text digReasonerUrlText;

	private Text inquiryUrlText;

	private Text publishUrlText;

	private Text uddiUserText;

	private Text uddiPasswordText;

	private Text publishBusinessNameText;

	private Text wsdlLocationText;

	private boolean resourcesModified = true;

	private RegistryController controller;

	/**
	 * Listener invoked when configuration resources are changed
	 * 
	 * @author tilmann
	 */
	class ResourceModifyListener implements ModifyListener {

		public void modifyText(ModifyEvent e) {
			resourcesModified = true;
		}

	}

	/**
	 * The constructor.
	 */
	public RegistryView() {
	}

	/**
	 * This is a callback that will allow us to create the viewer and initialize
	 * it.
	 */
	public void createPartControl(Composite parent) {

		controller = new RegistryController(getSite().getPage(), parent
				.getShell());

		GridLayout layout = new GridLayout(2, false);
		parent.setLayout(layout);

		// CONFIGURATION WIDGETS

		Label label = new Label(parent, SWT.BOLD);
		label.setText("Configuration:");
		GridData gridData = new GridData(SWT.LEFT, SWT.NONE, false, false, 2, 1);
		gridData.verticalIndent = 10;
		label.setLayoutData(gridData);

		// Listener for configuraton widgets
		ModifyListener modifyListener = new ResourceModifyListener();

		label = new Label(parent, SWT.LEFT);
		label.setText("DIG Reasoner URL");
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		digReasonerUrlText = new Text(parent, SWT.NONE);
		digReasonerUrlText.setLayoutData(gridData);
		digReasonerUrlText.setText("http://localhost:8080");
		digReasonerUrlText.addModifyListener(modifyListener);

		label = new Label(parent, SWT.LEFT);
		label.setText("Top Ontology");
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		topOntologyText = new Text(parent, SWT.NONE);
		topOntologyText.setLayoutData(gridData);
		topOntologyText.setText("http://localhost/ontologies/top.owl");
		topOntologyText.addModifyListener(modifyListener);

		label = new Label(parent, SWT.LEFT);
		label.setText("Upper Ontology");
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		upperOntologyText = new Text(parent, SWT.NONE);
		upperOntologyText.setLayoutData(gridData);
		upperOntologyText
				.setText("http://localhost/ontologies/upperService.owl");
		upperOntologyText.addModifyListener(modifyListener);

		label = new Label(parent, SWT.LEFT);
		label.setText("Service Ontology");
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		serviceOntologyText = new Text(parent, SWT.NONE);
		serviceOntologyText.setLayoutData(gridData);
		serviceOntologyText
				.setText("http://localhost/ontologies/serviceProfile.owl");
		serviceOntologyText.addModifyListener(modifyListener);

		label = new Label(parent, SWT.LEFT);
		label.setText("UDDI Inquiry URL");
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		inquiryUrlText = new Text(parent, SWT.NONE);
		inquiryUrlText.setLayoutData(gridData);
		inquiryUrlText.setText("http://localhost:8000/juddi/inquiry");
		inquiryUrlText.addModifyListener(modifyListener);

		label = new Label(parent, SWT.LEFT);
		label.setText("UDDI Publish URL");
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		publishUrlText = new Text(parent, SWT.NONE);
		publishUrlText.setLayoutData(gridData);
		publishUrlText.setText("http://localhost:8000/juddi/publish");
		publishUrlText.addModifyListener(modifyListener);

		label = new Label(parent, SWT.LEFT);
		label.setText("UDDI Username");
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		uddiUserText = new Text(parent, SWT.NONE);
		uddiUserText.setLayoutData(gridData);
		uddiUserText.setText("juddi");
		uddiUserText.addModifyListener(modifyListener);

		label = new Label(parent, SWT.LEFT);
		label.setText("UDDI Password");
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		uddiPasswordText = new Text(parent, SWT.NONE);
		uddiPasswordText.setLayoutData(gridData);
		uddiPasswordText.setText("juddi");
		uddiPasswordText.addModifyListener(modifyListener);

		label = new Label(parent, SWT.SEPARATOR + SWT.HORIZONTAL);
		gridData = new GridData(SWT.FILL, SWT.NONE, true, false, 2, 1);
		gridData.verticalIndent = 20;
		label.setLayoutData(gridData);

		// PUBLISH PARAMETER WIDGETS

		label = new Label(parent, SWT.BOLD);
		label.setText("Publish WSDL Parameters:");
		gridData = new GridData(SWT.LEFT, SWT.NONE, false, false, 2, 1);
		gridData.verticalIndent = 20;
		label.setLayoutData(gridData);

		label = new Label(parent, SWT.LEFT);
		label.setText("Business Name");
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		publishBusinessNameText = new Text(parent, SWT.NONE);
		publishBusinessNameText.setLayoutData(gridData);
		publishBusinessNameText.setText("Cooperation and Management");
		publishBusinessNameText.addModifyListener(modifyListener);

		label = new Label(parent, SWT.LEFT);
		label.setText("WSDL URL");
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		wsdlLocationText = new Text(parent, SWT.NONE);
		wsdlLocationText.setLayoutData(gridData);
		wsdlLocationText
				.setText("http://localhost/wsdl/ldocPublishingService.wsdl");
		wsdlLocationText.addModifyListener(modifyListener);

		Button publishButton = new Button(parent, SWT.PUSH);
		publishButton.setText("Publish");
		gridData = new GridData(SWT.RIGHT, SWT.NONE, false, false, 2, 1);
		publishButton.setLayoutData(gridData);

		publishButton.addSelectionListener(new SelectionAdapter() {

			public void widgetSelected(SelectionEvent event) {

				if (resourcesModified) {
					controller.updateConfiguration(
							digReasonerUrlText.getText(), serviceOntologyText
									.getText(), upperOntologyText.getText(),
							topOntologyText.getText(),
							inquiryUrlText.getText(), publishUrlText.getText(),
							uddiUserText.getText(), uddiPasswordText.getText());
					resourcesModified = false;
				}

				controller.publishWsdl(wsdlLocationText.getText(),
						publishBusinessNameText.getText());

			}
		});

		label = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
		gridData = new GridData(SWT.FILL, SWT.NONE, true, false, 2, 1);
		gridData.verticalIndent = 20;
		label.setLayoutData(gridData);

		// QUERY PARAMETER WIDGETS

		label = new Label(parent, SWT.BOLD);
		label.setText("Semantic Query Parameters:");
		gridData = new GridData(SWT.LEFT, SWT.NONE, false, false, 2, 1);
		gridData.verticalIndent = 20;
		label.setLayoutData(gridData);

		label = new Label(parent, SWT.LEFT);
		label.setText("Business Name");
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		queryBusinessNameText = new Text(parent, SWT.NONE);
		queryBusinessNameText.setLayoutData(gridData);

		label = new Label(parent, SWT.LEFT);
		label.setText("Service Category");
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		serviceCategoryText = new Text(parent, SWT.NONE);
		serviceCategoryText.setLayoutData(gridData);

		label = new Label(parent, SWT.LEFT);
		label.setText("User Roles");
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		userRolesText = new Text(parent, SWT.NONE);
		userRolesText.setLayoutData(gridData);

		label = new Label(parent, SWT.LEFT);
		label.setText("Inputs");
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		inputsText = new Text(parent, SWT.NONE);
		inputsText.setLayoutData(gridData);

		label = new Label(parent, SWT.LEFT);
		label.setText("Outputs");
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		outputsText = new Text(parent, SWT.NONE);
		outputsText.setLayoutData(gridData);

		label = new Label(parent, SWT.LEFT);
		label.setText("Preconditions");
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		preconditionsText = new Text(parent, SWT.NONE);
		preconditionsText.setLayoutData(gridData);

		label = new Label(parent, SWT.LEFT);
		label.setText("Effects");
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		effectsText = new Text(parent, SWT.NONE);
		effectsText.setLayoutData(gridData);

		Button searchButton = new Button(parent, SWT.PUSH);
		searchButton.setText("Search");
		gridData = new GridData(SWT.RIGHT, SWT.NONE, false, false, 2, 1);
		searchButton.setLayoutData(gridData);

		searchButton.addSelectionListener(new SelectionAdapter() {

			public void widgetSelected(SelectionEvent event) {

				if (resourcesModified) {
					controller.updateConfiguration(
							digReasonerUrlText.getText(), serviceOntologyText
									.getText(), upperOntologyText.getText(),
							topOntologyText.getText(),
							inquiryUrlText.getText(), publishUrlText.getText(),
							uddiUserText.getText(), uddiPasswordText.getText());
					resourcesModified = false;
				}

				ServiceParameter param = new ServiceParameter();
				param.setBusinessName(queryBusinessNameText.getText());
				param.setCategory(serviceCategoryText.getText());
				param.setUserRolesCsv(userRolesText.getText());
				param.setLogicalInputsCsv(inputsText.getText());
				param.setLogicalOutputsCsv(outputsText.getText());
				param.setPreconditionsCsv(preconditionsText.getText());
				param.setEffectsCsv(effectsText.getText());

				controller.findServices(param);

			}

		});

	}

	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
	}
}