/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class OWLAnonymousClassPostProcessor {
    private KnowledgeBase kb;
    private OWLModel owlModel;
    private Collection properties = new ArrayList();

    OWLAnonymousClassPostProcessor(OWLModel owlModel) {
        this.owlModel = owlModel;
        this.kb = owlModel;
        this.properties.add(owlModel.getRDFProperty("owl:onProperty"));
        this.properties.add(owlModel.getRDFProperty("owl:allValuesFrom"));
        this.properties.add(owlModel.getRDFProperty("owl:someValuesFrom"));
        this.properties.add(owlModel.getRDFProperty("owl:hasValue"));
        this.properties.add(owlModel.getRDFProperty("owl:minCardinality"));
        this.properties.add(owlModel.getRDFProperty("owl:maxCardinality"));
        this.properties.add(owlModel.getRDFProperty("owl:cardinality"));
        this.properties.add(owlModel.getRDFProperty("owl:complementOf"));
        this.properties.add(owlModel.getRDFProperty("owl:intersectionOf"));
        this.properties.add(owlModel.getRDFProperty("owl:unionOf"));
        this.properties.add(owlModel.getRDFProperty("owl:oneOf"));
        this.convertNamedClasses("owl:AllValuesFromRestriction");
        this.convertNamedClasses("owl:SomeValuesFromRestriction");
        this.convertNamedClasses("owl:HasValueRestriction");
        this.convertNamedClasses("owl:MinCardinalityRestriction");
        this.convertNamedClasses("owl:MaxCardinalityRestriction");
        this.convertNamedClasses("owl:CardinalityRestriction");
        this.convertNamedClasses("owl:ComplementClass");
        this.convertNamedClasses("owl:UnionClass");
        this.convertNamedClasses("owl:IntersectionClass");
        this.convertNamedEnumeratedClasses();
    }

    private void convertNamedEnumeratedClasses() {
        RDFSNamedClass metaClass = this.owlModel.getRDFSNamedClass("owl:EnumeratedClass");
        RDFProperty owlOneOfProperty = this.owlModel.getOWLOneOfProperty();
        Collection namedClasses = this.owlModel.getOWLNamedClassClass().getInstances(false);
        for (OWLNamedClass namedClass : namedClasses) {
            if (namedClass.getPropertyValueCount(owlOneOfProperty) <= 0) continue;
            String name = namedClass.getName();
            if (this.owlModel.isAnonymousResourceName(name)) {
                TripleStoreUtil.ensureActiveTripleStore(namedClass);
                namedClass.setProtegeType(metaClass);
                namedClass.setPropertyValue(this.owlModel.getRDFTypeProperty(), this.owlModel.getOWLNamedClassClass());
                continue;
            }
            this.convertNamedClass(namedClass, metaClass);
        }
    }

    private void convertNamedClasses(String metaclassName) {
        Cls metaclass = this.kb.getCls(metaclassName);
        ArrayList instances = new ArrayList(metaclass.getDirectInstances());
        TripleStoreModel tsm = this.owlModel.getTripleStoreModel();
        for (RDFSClass cls : instances) {
            String name = cls.getName();
            if (this.owlModel.isAnonymousResourceName(name)) {
                TripleStore ts = tsm.getHomeTripleStore(cls);
                if (ts.listTriplesWithObject(cls).hasNext()) continue;
                tsm.setActiveTripleStore(ts);
                String newName = this.owlModel.createNewResourceName("Axiom");
                ts.setRDFResourceName(cls, newName);
                this.convertNamedClass(cls, metaclass);
                continue;
            }
            this.convertNamedClass(cls, metaclass);
        }
    }

    private void convertNamedClass(Cls namedClass, Cls metaclass) {
        String anonName = this.owlModel.getNextAnonymousResourceName();
        TripleStore ts = TripleStoreUtil.ensureActiveTripleStore((RDFResource)namedClass);
        Cls anonClass = (Cls)metaclass.createDirectInstance(anonName);
        for (RDFProperty property : this.properties) {
            List values = namedClass.getDirectOwnSlotValues((Slot)property);
            if (values.isEmpty()) continue;
            ts.getNarrowFrameStore().setValues((Frame)anonClass, (Slot)property, null, false, (Collection)values);
            ts.getNarrowFrameStore().setValues((Frame)namedClass, (Slot)property, null, false, (Collection)Collections.EMPTY_LIST);
        }
        String name = namedClass.getName();
        namedClass.setDirectType((Cls)this.owlModel.getOWLNamedClassClass());
        namedClass = this.owlModel.getOWLNamedClass(name);
        namedClass.addDirectSuperclass(anonClass);
        anonClass.addDirectSuperclass(namedClass);
    }
}

