/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.editors;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.toedter.calendar.JCalendar;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.editors.DateValueEditor;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;

public class DateTimeValueEditor
implements PropertyValueEditor {
    public boolean canEdit(RDFResource instance, RDFProperty property, Object value) {
        return DateValueEditor.canEdit(instance.getOWLModel().getXSDdateTime(), instance, property, value);
    }

    public Object createDefaultValue(RDFResource instance, RDFProperty property) {
        String str = XMLSchemaDatatypes.getDefaultDateTimeValue();
        return this.createRDFSLiteral(property.getOWLModel(), str);
    }

    private RDFSLiteral createRDFSLiteral(OWLModel owlModel, String str) {
        return owlModel.createRDFSLiteral(str, owlModel.getRDFSDatatypeByURI(XSDDatatype.XSDdateTime.getURI()));
    }

    public Object editValue(Component parent, RDFResource instance, RDFProperty property, Object value) {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        JFormattedTextField field = new JFormattedTextField(format);
        try {
            Date date = XMLSchemaDatatypes.getDate(value.toString());
            field.setValue(date);
            JCalendar calendar = new JCalendar(date);
            String name = property.getBrowserText();
            name = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add("Center", (Component)new LabeledComponent("Date", (Component)calendar));
            panel.add("South", (Component)new LabeledComponent("Time", (Component)field));
            int r = ProtegeUI.getModalDialogFactory().showDialog(ProtegeUI.getTopLevelContainer(property.getProject()), panel, "Edit " + property.getBrowserText(), 11);
            if (r == 1) {
                Date newDate = calendar.getDate();
                GregorianCalendar dateCal = new GregorianCalendar();
                dateCal.setTime(newDate);
                int year = dateCal.get(1);
                int month = dateCal.get(2);
                int day = dateCal.get(5);
                GregorianCalendar timeCal = new GregorianCalendar();
                timeCal.setTime((Date)field.getValue());
                int hour = timeCal.get(11);
                int minute = timeCal.get(12);
                int second = timeCal.get(13);
                GregorianCalendar newCal = new GregorianCalendar(year, month, day, hour, minute, second);
                String str = XMLSchemaDatatypes.getDateTimeString(newCal.getTime());
                return this.createRDFSLiteral(property.getOWLModel(), str);
            }
            return null;
        }
        catch (Exception ex) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            return null;
        }
    }

    public boolean mustEdit(RDFResource subject, RDFProperty predicate, Object value) {
        return this.canEdit(subject, predicate, value);
    }
}

