/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.importer;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class OWLImporter {
    private KnowledgeBase kb;
    private OWLModel owlModel;

    public OWLImporter(OWLModel owlModel, KnowledgeBase kb) {
        this.owlModel = owlModel;
        this.kb = kb;
        this.importClses();
        this.importSlots();
        this.importInstances();
        this.updateSlotDomain();
    }

    private void createAllowedClses(Slot oldSlot, Slot slot) {
        ArrayList<Cls> newAllowedClses = new ArrayList<Cls>();
        for (RDFSNamedClass oldAllowedClass : oldSlot.getAllowedClses()) {
            Cls newAllowedCls = this.getCls(oldAllowedClass);
            if (newAllowedCls == null) continue;
            newAllowedClses.add(newAllowedCls);
        }
        slot.setAllowedClses(newAllowedClses);
    }

    private void createAllowedParents(Slot oldSlot, Slot slot) {
        RDFProperty allowedParentProperty = this.owlModel.getProtegeAllowedParentProperty();
        if (allowedParentProperty != null) {
            ArrayList<Cls> newAllowedParents = new ArrayList<Cls>();
            for (RDFSNamedClass oldAllowedParent : oldSlot.getDirectOwnSlotValues((Slot)allowedParentProperty)) {
                Cls newAllowedParent = this.getCls(oldAllowedParent);
                if (newAllowedParent == null) continue;
                newAllowedParents.add(newAllowedParent);
            }
            slot.setAllowedParents(newAllowedParents);
        }
    }

    private Cls createCls(Cls oldCls) {
        Cls metaCls = this.getCls(oldCls.getDirectType());
        Cls cls = this.kb.createCls(oldCls.getName(), (Collection)Collections.EMPTY_LIST, metaCls);
        this.log("+ Created Cls " + oldCls.getName());
        cls.setAbstract(oldCls.isAbstract());
        this.createDirectSuperclasses(oldCls, cls);
        this.createDirectTemplateSlots(oldCls, cls);
        this.createDirectOwnSlotValues((Instance)oldCls, (Instance)cls);
        return cls;
    }

    private void createDirectOwnSlotValues(Instance oldInstance, Instance newInstance) {
        for (Slot oldSlot : oldInstance.getOwnSlots()) {
            Slot newSlot;
            if (!this.isRelevantOwnSlot(oldSlot) || (newSlot = this.getSlot(oldSlot)) == null) continue;
            this.createDirectOwnSlotValues(oldInstance, newInstance, oldSlot, newSlot);
        }
    }

    private void createDirectOwnSlotValues(Instance oldInstance, Instance newInstance, Slot oldSlot, Slot newSlot) {
        for (Object oldValue : oldInstance.getDirectOwnSlotValues(oldSlot)) {
            Object newValue = this.getNewValue(oldValue);
            if (newValue == null) continue;
            newInstance.addOwnSlotValue(newSlot, newValue);
        }
    }

    private void createDirectSuperclasses(Cls rdfsCls, Cls cls) {
        for (Cls oldSuperCls : rdfsCls.getDirectSuperclasses()) {
            if (!(oldSuperCls instanceof RDFSNamedClass)) continue;
            Cls newSuperCls = this.getCls((RDFSNamedClass)oldSuperCls);
            cls.addDirectSuperclass(newSuperCls);
        }
    }

    private void createDirectTemplateSlots(Cls oldCls, Cls cls) {
        Slot newSlot;
        for (Slot oldSlot : oldCls.getDirectTemplateSlots()) {
            if (!(oldSlot instanceof OWLProperty)) continue;
            newSlot = this.getSlot((OWLProperty)oldSlot);
            cls.addDirectTemplateSlot(newSlot);
        }
        if (oldCls instanceof OWLNamedClass) {
            for (Slot oldSlot : oldCls.getTemplateSlots()) {
                if (!(oldSlot instanceof RDFProperty) || !this.isRelevantOwnSlot(oldSlot)) continue;
                newSlot = this.getSlotForced(oldSlot);
                this.createDirectTemplateSlotOverloads((OWLNamedClass)oldCls, cls, oldSlot, newSlot);
            }
        }
    }

    private void createDirectTemplateSlotOverloads(OWLNamedClass namedCls, Cls cls, Slot oldSlot, Slot newSlot) {
        Collection restrictions = namedCls.getRestrictions(false);
        for (OWLRestriction restriction : restrictions) {
            Object oldValue;
            Object newValue;
            if (!restriction.getOnProperty().equals(oldSlot)) continue;
            cls.addDirectTemplateSlot(newSlot);
            if (restriction instanceof OWLCardinality) {
                int cardi = ((OWLCardinality)restriction).getCardinality();
                cls.setTemplateSlotMinimumCardinality(newSlot, cardi);
                cls.setTemplateSlotMaximumCardinality(newSlot, cardi);
                continue;
            }
            if (restriction instanceof OWLMinCardinality) {
                int minCardi = ((OWLMinCardinality)restriction).getCardinality();
                cls.setTemplateSlotMinimumCardinality(newSlot, minCardi);
                continue;
            }
            if (restriction instanceof OWLMaxCardinality) {
                int maxCardi = ((OWLMaxCardinality)restriction).getCardinality();
                cls.setTemplateSlotMaximumCardinality(newSlot, maxCardi);
                continue;
            }
            if (restriction instanceof OWLAllValuesFrom) {
                OWLAllValuesFrom allRestriction = (OWLAllValuesFrom)restriction;
                if (oldSlot instanceof OWLDatatypeProperty && allRestriction.getFiller() instanceof RDFSDatatype) {
                    RDFSDatatype datatype = (RDFSDatatype)allRestriction.getFiller();
                    ValueType valueType = XMLSchemaDatatypes.getValueType(datatype.getURI());
                    cls.setTemplateSlotValueType(newSlot, valueType);
                    continue;
                }
                if (!(oldSlot instanceof OWLObjectProperty) || !(allRestriction.getFiller() instanceof RDFSNamedClass)) continue;
                Cls newCls = this.getCls((RDFSNamedClass)allRestriction.getFiller());
                cls.setTemplateSlotAllowedClses(newSlot, (Collection)Collections.singleton(newCls));
                continue;
            }
            if (!(restriction instanceof OWLHasValue) || (newValue = this.getNewValue(oldValue = ((OWLHasValue)restriction).getHasValue())) == null) continue;
            cls.setTemplateSlotValue(newSlot, newValue);
        }
    }

    private Instance createInstance(Instance oldInstance) {
        Cls oldType = oldInstance.getDirectType();
        Cls newType = this.getCls(oldType);
        Instance instance = newType.createDirectInstance(oldInstance.getName());
        this.log("+ Created instance " + oldInstance.getName());
        this.createDirectOwnSlotValues(oldInstance, instance);
        return instance;
    }

    private Slot createSlot(Slot oldSlot) {
        RDFProperty property;
        RDFResource range;
        Cls metaCls = this.getCls(oldSlot.getDirectType());
        Slot slot = this.kb.createSlot(oldSlot.getName(), metaCls);
        this.log("+ Created slot " + oldSlot.getName());
        if (oldSlot instanceof RDFProperty && !((RDFProperty)oldSlot).isDomainDefined()) {
            this.kb.getRootCls().addDirectTemplateSlot(slot);
        }
        slot.setAllowsMultipleValues(oldSlot.getAllowsMultipleValues());
        ValueType valueType = oldSlot.getValueType();
        slot.setValueType(valueType);
        if (valueType == ValueType.INSTANCE) {
            this.createAllowedClses(oldSlot, slot);
        } else if (valueType == ValueType.CLS) {
            this.createAllowedParents(oldSlot, slot);
        } else if (valueType == ValueType.SYMBOL) {
            slot.setAllowedValues(oldSlot.getAllowedValues());
        }
        if (oldSlot instanceof RDFProperty && (range = (property = (RDFProperty)oldSlot).getRange()) instanceof OWLDataRange) {
            slot.setValueType(ValueType.SYMBOL);
            ArrayList<String> allowedValues = new ArrayList<String>();
            for (Object value : ((OWLDataRange)range).getOneOfValues()) {
                allowedValues.add(value.toString());
            }
            slot.setAllowedValues(allowedValues);
        }
        this.createDirectOwnSlotValues((Instance)oldSlot, (Instance)slot);
        if (oldSlot.getInverseSlot() instanceof RDFProperty) {
            Slot newInverseSlot = this.getSlot((RDFProperty)oldSlot.getInverseSlot());
            slot.setInverseSlot(newInverseSlot);
        }
        return slot;
    }

    private Cls getCls(Cls oldCls) {
        if (oldCls.equals(this.owlModel.getOWLThingClass())) {
            return this.kb.getRootCls();
        }
        if (oldCls.equals(this.owlModel.getRDFSNamedClassClass()) || oldCls.equals(this.owlModel.getOWLNamedClassClass())) {
            return this.kb.getDefaultClsMetaCls();
        }
        if (oldCls.getName().equals("rdf:Property") || oldCls.getName().equals("owl:DatatypeProperty") || oldCls.getName().equals("owl:ObjectProperty")) {
            return this.kb.getDefaultSlotMetaCls();
        }
        Cls cls = this.kb.getCls(oldCls.getName());
        if (cls == null) {
            cls = this.createCls(oldCls);
        }
        return cls;
    }

    private Instance getInstance(Instance oldInstance) {
        if (oldInstance instanceof Cls) {
            return this.getCls((Cls)oldInstance);
        }
        if (oldInstance instanceof Slot) {
            return this.getSlot((Slot)oldInstance);
        }
        Instance instance = this.kb.getInstance(oldInstance.getName());
        if (instance == null) {
            instance = this.createInstance(oldInstance);
        }
        return instance;
    }

    private Object getNewValue(Object oldValue) {
        Object newValue = null;
        if (oldValue instanceof RDFResource) {
            newValue = this.getInstance((RDFResource)oldValue);
        } else if (oldValue instanceof Boolean || oldValue instanceof String || oldValue instanceof Number) {
            newValue = oldValue;
        }
        return newValue;
    }

    private Slot getSlot(Slot oldSlot) {
        if (!(oldSlot instanceof RDFProperty) || ((RDFProperty)oldSlot).isDomainDefined()) {
            return this.getSlotForced(oldSlot);
        }
        return null;
    }

    private Slot getSlotForced(Slot oldSlot) {
        Slot slot = this.kb.getSlot(oldSlot.getName());
        if (slot == null) {
            slot = this.createSlot(oldSlot);
        }
        return slot;
    }

    private void importClses() {
        for (RDFSNamedClass rdfsClass : this.owlModel.getUserDefinedRDFSNamedClasses()) {
            this.getCls(rdfsClass);
        }
    }

    private void importInstances() {
        for (RDFSNamedClass aClass : this.owlModel.getUserDefinedRDFSNamedClasses()) {
            for (RDFResource instance : aClass.getInstances(false)) {
                this.getInstance(instance);
            }
        }
    }

    private void importSlots() {
        for (RDFProperty rdfProperty : this.owlModel.getUserDefinedRDFProperties()) {
            if (rdfProperty.isDomainDefined() || !rdfProperty.isEditable()) continue;
            this.getSlotForced(rdfProperty);
        }
    }

    private boolean isRelevantOwnSlot(Slot slot) {
        return slot instanceof RDFProperty && slot.isEditable() && !slot.getName().startsWith("protege:") || ":SLOT-CONSTRAINTS".equals(slot.getName()) || ":PAL-DESCRIPTION".equals(slot.getName()) || ":PAL-NAME".equals(slot.getName()) || ":PAL-RANGE".equals(slot.getName()) || ":PAL-STATEMENT".equals(slot.getName());
    }

    private void log(String msg) {
    }

    private void updateSlotDomain() {
        Cls rootCls = this.kb.getRootCls();
        for (Slot slot : new ArrayList(rootCls.getDirectTemplateSlots())) {
            if (slot.getDirectDomain().size() <= 1) continue;
            rootCls.removeDirectTemplateSlot(slot);
        }
    }
}

