/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.table;

import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLTextAreaPanel;
import edu.stanford.smi.protegex.owl.swrl.ui.icons.SWRLIcons;
import edu.stanford.smi.protegex.owl.swrl.ui.table.SWRLTable;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;

public class ViewRuleAction
extends AbstractAction {
    private SWRLTable table;

    public ViewRuleAction(SWRLTable table) {
        super("Edit selected rule in multi-line editor...", OWLIcons.getViewIcon("SWRLImp", SWRLIcons.class));
        this.table = table;
        table.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                ViewRuleAction.this.updateEnabled();
            }
        });
        this.updateEnabled();
    }

    public void actionPerformed(ActionEvent e) {
        final SWRLImp imp = this.table.getSelectedImp();
        OWLModel owlModel = imp.getOWLModel();
        if (SWRLTextAreaPanel.showEditDialog((Component)((Object)this.table), owlModel, imp)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ViewRuleAction.this.table.setSelectedRow(imp);
                }
            });
        }
    }

    private void updateEnabled() {
        this.setEnabled(this.table.getSelectedImp() != null && this.table.getSelectedImp().isEditable());
    }
}

