/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.AbstractImportStartWizardPage;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.ImportVerificationPage;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.ImportWizard;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.RepositoryImportEntry;
import edu.stanford.smi.protegex.owl.ui.repository.wizard.RepositoryWizard;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RepositoryImportPage
extends AbstractImportStartWizardPage {
    private JList list;
    private Action addRepositoryAction;
    private static final String HELP_TEXT = "<p>Please select the ontology to be imported.  If the list above does not contain the ontology, press the 'Add repository...' button to specify a repository that contains the ontology.</p>";

    public RepositoryImportPage(ImportWizard wizard) {
        super("Repository Import Page", wizard);
        this.createUI();
    }

    private void createUI() {
        this.setHelpText("Importing an ontology from a repository", HELP_TEXT);
        this.list = new JList();
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                RepositoryImportPage.this.setPageComplete(RepositoryImportPage.this.validateData());
                RepositoryImportPage.this.updateNextPage();
            }
        });
        this.refreshList();
        LabeledComponent lc = new LabeledComponent("Select an ontology to import", new JScrollPane(this.list));
        JPanel holder = new JPanel(new BorderLayout(3, 3));
        holder.add((Component)lc, "North");
        this.addRepositoryAction = new AbstractAction("Add repository..."){

            public void actionPerformed(ActionEvent e) {
                RepositoryImportPage.this.addRepository();
            }
        };
        JPanel buttonHolder = new JPanel(new FlowLayout(2));
        buttonHolder.add((Component)new JButton(this.addRepositoryAction), "South");
        holder.add((Component)buttonHolder, "South");
        this.getContentComponent().add((Component)holder, "North");
        this.setPageComplete(this.validateData());
    }

    public void nextPressed() {
        Object[] selValues = this.list.getSelectedValues();
        int i = 0;
        while (i < selValues.length) {
            URI curURI = (URI)selValues[i];
            Repository rep = this.getImportWizard().getOWLModel().getRepositoryManager().getRepository(curURI);
            this.getImportWizard().getImportData().addImportEntry(new RepositoryImportEntry(curURI, rep));
            ++i;
        }
    }

    private boolean validateData() {
        Object selVal = this.list.getSelectedValue();
        if (selVal != null) {
            try {
                URI uri = new URI(selVal.toString());
                return true;
            }
            catch (URISyntaxException e) {
                return false;
            }
        }
        return false;
    }

    private void addRepository() {
        Repository rep;
        OWLModel owlModel;
        RepositoryWizard wizard;
        RepositoryImportPage c = null;
        if (SwingUtilities.getRoot((Component)((Object)this)) instanceof JFrame) {
            c = this;
        }
        if ((wizard = new RepositoryWizard((JComponent)((Object)c), owlModel = ((ImportWizard)this.getWizard()).getOWLModel())).execute() == 1 && (rep = wizard.getRepository()) != null) {
            owlModel.getRepositoryManager().addProjectRepository(0, rep);
            this.refreshList();
        }
    }

    public WizardPage getNextPage() {
        return new ImportVerificationPage(this.getImportWizard());
    }

    private void refreshList() {
        OWLModel owlModel = ((ImportWizard)this.getWizard()).getOWLModel();
        LinkedHashSet availOntologies = new LinkedHashSet();
        for (Repository rep : owlModel.getRepositoryManager().getProjectRepositories()) {
            availOntologies.addAll(new TreeSet(rep.getOntologies()));
        }
        for (Repository rep : owlModel.getRepositoryManager().getGlobalRepositories()) {
            availOntologies.addAll(new TreeSet(rep.getOntologies()));
        }
        Set importedOntologies = owlModel.getAllImports();
        Iterator it = availOntologies.iterator();
        while (it.hasNext()) {
            URI uri = (URI)it.next();
            if (!importedOntologies.contains(uri.toString())) continue;
            it.remove();
        }
        try {
            availOntologies.remove(new URI(owlModel.getDefaultOWLOntology().getURI()));
        }
        catch (URISyntaxException e) {
            System.err.print(e.getMessage());
        }
        this.list.setListData(availOntologies.toArray());
    }
}

