/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.AbstractCreateProjectPlugin;
import edu.stanford.smi.protege.plugin.CreateProjectWizard;
import edu.stanford.smi.protege.storage.database.DatabaseKnowledgeBaseFactory;
import edu.stanford.smi.protege.storage.database.DatabasePlugin;
import edu.stanford.smi.protege.storage.database.DatabaseWizardPage;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.WizardPage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class DatabaseCreateProjectPlugin
extends AbstractCreateProjectPlugin
implements DatabasePlugin {
    private String driver;
    private String table;
    private String username;
    private String password;
    private String url;

    public DatabaseCreateProjectPlugin() {
        super(DatabaseKnowledgeBaseFactory.DESCRIPTION);
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public void setTable(String string) {
        this.table = string;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public boolean canCreateProject(KnowledgeBaseFactory knowledgeBaseFactory, boolean bl) {
        return knowledgeBaseFactory.getClass() == DatabaseKnowledgeBaseFactory.class;
    }

    public Project createNewProject(KnowledgeBaseFactory knowledgeBaseFactory) {
        ArrayList arrayList = new ArrayList();
        Project project = super.createNewProject(knowledgeBaseFactory);
        this.initializeSources(project.getSources());
        try {
            File file = File.createTempFile("protege", "temp");
            project.setProjectFilePath(file.getPath());
            project.save(arrayList);
            project = Project.loadProjectFromFile(file.getPath(), arrayList);
            this.handleErrors(arrayList);
            project.setProjectFilePath(null);
            file.delete();
        }
        catch (IOException iOException) {
            Log.getLogger().severe(Log.toString(iOException));
        }
        return project;
    }

    protected void initializeSources(PropertyList propertyList) {
        DatabaseKnowledgeBaseFactory.setSources(propertyList, this.driver, this.url, this.table, this.username, this.password);
    }

    public WizardPage createCreateProjectWizardPage(CreateProjectWizard createProjectWizard, boolean bl) {
        return new DatabaseWizardPage(createProjectWizard, this);
    }
}

