/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DefaultRDFSLiteral
implements RDFSLiteral {
    private OWLModel owlModel;
    private String rawValue;
    private static final String DATATYPE_PREFIX = "~@";
    private static final String LANGUAGE_PREFIX = "~#";
    private static final char SEPARATOR = ' ';

    public DefaultRDFSLiteral(OWLModel owlModel, String rawValue) {
        this.owlModel = owlModel;
        this.rawValue = rawValue;
    }

    public void accept(OWLModelVisitor visitor) {
        visitor.visitRDFSLiteral(this);
    }

    public int compareTo(Object o) {
        if (o instanceof RDFSLiteral) {
            RDFSDatatype otherDatatype;
            RDFSLiteral other = (RDFSLiteral)o;
            RDFSDatatype datatype = this.getDatatype();
            if (datatype.equals(otherDatatype = other.getDatatype())) {
                if (this.owlModel.getIntegerDatatypes().contains(datatype)) {
                    int a = this.getInt();
                    int b = other.getInt();
                    return new Integer(a).compareTo(new Integer(b));
                }
                if (this.owlModel.getFloatDatatypes().contains(datatype)) {
                    double a = this.getDouble();
                    double b = other.getDouble();
                    return new Double(a).compareTo(new Double(b));
                }
            }
        }
        return 0;
    }

    public static RDFSLiteral create(OWLModel owlModel, Object value) {
        RDFSDatatype datatype = null;
        if (value instanceof Boolean) {
            datatype = owlModel.getXSDboolean();
        } else if (value instanceof Long) {
            datatype = owlModel.getXSDlong();
        } else if (value instanceof Integer) {
            datatype = owlModel.getXSDint();
        } else if (value instanceof Short) {
            datatype = owlModel.getXSDshort();
        } else if (value instanceof Byte) {
            datatype = owlModel.getXSDbyte();
        } else if (value instanceof Double) {
            datatype = owlModel.getXSDdouble();
        } else if (value instanceof Float) {
            datatype = owlModel.getXSDfloat();
        } else if (value instanceof String) {
            if (((String)value).startsWith(DATATYPE_PREFIX)) {
                return new DefaultRDFSLiteral(owlModel, (String)value);
            }
            datatype = owlModel.getXSDstring();
        } else if (value instanceof byte[]) {
            datatype = owlModel.getXSDbase64Binary();
            value = XSDDatatype.XSDbase64Binary.unparse(value);
        } else if (value instanceof BigDecimal) {
            datatype = owlModel.getXSDdecimal();
        } else if (value instanceof BigInteger) {
            datatype = owlModel.getXSDinteger();
        } else {
            throw new IllegalArgumentException("Value type " + value.getClass() + " of value \"" + value + "\" cannot be mapped into default RDFSDatatype.");
        }
        return new DefaultRDFSLiteral(owlModel, DefaultRDFSLiteral.getRawValue(String.valueOf(value), datatype));
    }

    public static RDFSLiteral create(OWLModel owlModel, String lexicalValue, RDFSDatatype datatype) {
        return new DefaultRDFSLiteral(owlModel, DefaultRDFSLiteral.getRawValue(lexicalValue, datatype));
    }

    public static RDFSLiteral create(OWLModel owlModel, String text, String language) {
        return new DefaultRDFSLiteral(owlModel, DefaultRDFSLiteral.getRawValue(text, language));
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultRDFSLiteral) {
            return this.rawValue.equals(((DefaultRDFSLiteral)obj).rawValue);
        }
        return false;
    }

    public boolean equalsStructurally(RDFObject object) {
        if (object instanceof RDFSLiteral) {
            return ((RDFSLiteral)object).equals(this);
        }
        return false;
    }

    public boolean getBoolean() {
        String str = this.getString();
        return Boolean.valueOf(str);
    }

    public String getBrowserText() {
        return this.toString();
    }

    public byte[] getBytes() {
        return (byte[])XSDDatatype.XSDbase64Binary.parse(this.getString());
    }

    public RDFSDatatype getDatatype() {
        if (this.rawValue.startsWith(DATATYPE_PREFIX)) {
            int index = this.rawValue.indexOf(32);
            String localName = this.rawValue.substring(2, index);
            if ("XMLLiteral".equals(localName)) {
                return this.owlModel.getRDFXMLLiteralType();
            }
            return this.owlModel.getRDFSDatatypeByName("xsd:" + localName);
        }
        if (this.rawValue.startsWith(LANGUAGE_PREFIX)) {
            return this.owlModel.getXSDstring();
        }
        return null;
    }

    public double getDouble() {
        return Double.parseDouble(this.getString().trim());
    }

    public float getFloat() {
        return Float.parseFloat(this.getString().trim());
    }

    public int getInt() {
        return Integer.parseInt(this.getString().trim());
    }

    public String getLanguage() {
        String lang = null;
        if (this.rawValue.startsWith(LANGUAGE_PREFIX)) {
            int endIndex = this.rawValue.indexOf(32);
            lang = endIndex > 0 ? this.rawValue.substring(2, endIndex) : this.rawValue.substring(2);
        }
        return lang;
    }

    public long getLong() {
        return Long.parseLong(this.getString());
    }

    public short getShort() {
        return Short.parseShort(this.getString());
    }

    public Object getPlainValue() {
        String lang = this.getLanguage();
        if (lang != null) {
            if (lang.length() == 0) {
                return this.getString();
            }
            return null;
        }
        RDFSDatatype datatype = this.getDatatype();
        if (this.owlModel.getXSDstring().equals(datatype)) {
            if (this.getLanguage() == null) {
                return this.getString();
            }
        } else {
            if (this.owlModel.getXSDint().equals(datatype)) {
                try {
                    return Integer.valueOf(this.getString().trim());
                }
                catch (Exception ex) {
                    return new Integer(0);
                }
            }
            if (this.owlModel.getXSDfloat().equals(datatype)) {
                try {
                    return Float.valueOf(this.getString().trim());
                }
                catch (Exception ex) {
                    return new Float(0.0f);
                }
            }
            if (this.owlModel.getXSDboolean().equals(datatype)) {
                try {
                    return Boolean.valueOf(this.getString());
                }
                catch (Exception ex) {
                    return Boolean.FALSE;
                }
            }
        }
        return null;
    }

    public static Object getPlainValueIfPossible(Object value) {
        RDFSLiteral literal;
        Object plainValue;
        if (value instanceof RDFSLiteral && (plainValue = (literal = (RDFSLiteral)value).getPlainValue()) != null) {
            return plainValue;
        }
        return value;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public String getString() {
        if (this.rawValue.startsWith(LANGUAGE_PREFIX) || this.rawValue.startsWith(DATATYPE_PREFIX)) {
            return this.rawValue.substring(this.rawValue.indexOf(32) + 1);
        }
        return this.rawValue;
    }

    public static final String getRawValue(String lexicalValue, RDFSDatatype datatype) {
        if (datatype.equals(datatype.getOWLModel().getXSDboolean()) && "1".equals(lexicalValue)) {
            lexicalValue = Boolean.TRUE.toString();
        }
        if (!datatype.isSystem() && datatype.isAnonymous()) {
            datatype = datatype.getBaseDatatype();
        }
        return DATATYPE_PREFIX + datatype.getLocalName() + ' ' + lexicalValue;
    }

    public static final String getRawValue(String text, String language) {
        if (language == null || language.length() == 0) {
            return text;
        }
        return LANGUAGE_PREFIX + language + ' ' + text;
    }

    public int hashCode() {
        return this.rawValue.hashCode();
    }

    public static final boolean isRawValue(String value) {
        return value.startsWith(LANGUAGE_PREFIX) || value.startsWith(DATATYPE_PREFIX);
    }

    public String toString() {
        return this.getString();
    }
}

