/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.dig.translator;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasonerIdentity;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGDataTypes;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGRenderer;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGTranslatorPreferences;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogger;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerPreferences;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerUtil;
import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLLogicalClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNAryLogicalClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.util.ClassCommenter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DefaultDIGRenderer
implements DIGRenderer {
    private HashSet slotsToIgnore = new HashSet();
    private HashSet clsesToIgnore = new HashSet();
    private DIGReasonerIdentity reasonerIdentity = null;

    public void setReasonerIdentity(DIGReasonerIdentity reasonerIdentity) {
        this.reasonerIdentity = reasonerIdentity;
    }

    protected boolean renderAppropriateCls(RDFSClass aClass, Document doc, Node parentNode) throws DIGReasonerException {
        boolean b = false;
        if (aClass instanceof OWLNamedClass) {
            b = this.render((OWLNamedClass)aClass, doc, parentNode);
        } else if (aClass instanceof OWLSomeValuesFrom) {
            b = this.render((OWLSomeValuesFrom)aClass, doc, parentNode);
        } else if (aClass instanceof OWLAllValuesFrom) {
            b = this.render((OWLAllValuesFrom)aClass, doc, parentNode);
        } else if (aClass instanceof OWLHasValue) {
            b = this.render((OWLHasValue)aClass, doc, parentNode);
        } else if (aClass instanceof OWLMinCardinality) {
            b = this.render((OWLMinCardinality)aClass, doc, parentNode);
        } else if (aClass instanceof OWLMaxCardinality) {
            b = this.render((OWLMaxCardinality)aClass, doc, parentNode);
        } else if (aClass instanceof OWLCardinality) {
            b = this.render((OWLCardinality)aClass, doc, parentNode);
        } else if (aClass instanceof OWLIntersectionClass) {
            b = this.render((OWLIntersectionClass)aClass, doc, parentNode);
        } else if (aClass instanceof OWLUnionClass) {
            b = this.render((OWLUnionClass)aClass, doc, parentNode);
        } else if (aClass instanceof OWLComplementClass) {
            b = this.render((OWLComplementClass)aClass, doc, parentNode);
        } else if (aClass instanceof OWLEnumeratedClass) {
            b = this.render((OWLEnumeratedClass)aClass, doc, parentNode);
        } else {
            this.logErrorOrWarning(aClass, "Don't know how to render the type: " + aClass.getClass().getName(), "Ignoring this type and attempting to continue.");
        }
        return b;
    }

    protected boolean renderAppropriateSlot(Slot slot, Document doc, Node parentNode) throws DIGReasonerException {
        boolean ret = true;
        if (slot instanceof OWLObjectProperty) {
            ret = this.render((OWLObjectProperty)slot, doc, parentNode);
        } else if (slot instanceof OWLDatatypeProperty) {
            ret = this.render((OWLDatatypeProperty)slot, doc, parentNode);
        }
        return ret;
    }

    public void render(OWLModel kb, Document doc, Node parentNode) throws DIGReasonerException {
        this.clsesToIgnore.removeAll(this.clsesToIgnore);
        this.slotsToIgnore.removeAll(this.slotsToIgnore);
        this.renderClasses(kb, doc, parentNode);
        this.renderProperties(kb, doc, parentNode);
        this.renderIndividuals(kb, doc, parentNode);
        Collection allDifferent = kb.getOWLAllDifferents();
        if (!allDifferent.isEmpty()) {
            Element allDifferentElement = doc.createElement("alldifferent");
            for (OWLAllDifferent curOWLAllDifferent : allDifferent) {
                if (this.isSupportedTellElement("alldifferent")) {
                    for (RDFIndividual curInstance : curOWLAllDifferent.getDistinctMembers()) {
                        this.render(curInstance, doc, (Node)allDifferentElement);
                    }
                    continue;
                }
                this.renderFakedDifferentFrom(curOWLAllDifferent.getDistinctMembers(), doc, parentNode);
            }
            if (allDifferentElement.getChildNodes().getLength() > 0) {
                parentNode.appendChild(allDifferentElement);
            }
        }
    }

    protected void renderFakedDifferentFrom(Collection differentFromIndividuals, Document doc, Node parentNode) throws DIGReasonerException {
        if (this.isSupportedTellElement("disjoint")) {
            Element disjointElement = doc.createElement("disjoint");
            for (RDFIndividual curInstance : differentFromIndividuals) {
                Element curIsetElement = doc.createElement("iset");
                this.render(curInstance, doc, (Node)curIsetElement);
                disjointElement.appendChild(curIsetElement);
            }
            parentNode.appendChild(disjointElement);
        }
    }

    protected void renderClasses(OWLModel kb, Document doc, Node parentNode) throws DIGReasonerException {
        Collection namedClses = ReasonerUtil.getInstance().getNamedClses(kb);
        for (OWLNamedClass curNamedCls : namedClses) {
            Element curElement = doc.createElement("defconcept");
            curElement.setAttribute("name", curNamedCls.getName());
            parentNode.appendChild(curElement);
            this.renderAxioms(curNamedCls, doc, parentNode);
        }
    }

    protected void renderProperties(OWLModel kb, Document doc, Node parentNode) throws DIGReasonerException {
        Collection properties = ReasonerUtil.getInstance().getProperties(kb);
        for (OWLProperty curProperty : properties) {
            if (curProperty.isAnnotationProperty()) continue;
            Element curDefPropElement = curProperty instanceof OWLObjectProperty ? doc.createElement("defrole") : doc.createElement("defattribute");
            curDefPropElement.setAttribute("name", curProperty.getName());
            parentNode.appendChild(curDefPropElement);
            this.renderAxioms(curProperty, doc, parentNode);
        }
    }

    protected void renderIndividuals(OWLModel kb, Document doc, Node parentNode) throws DIGReasonerException {
        Collection individuals = ReasonerUtil.getInstance().getIndividuals(kb);
        for (OWLIndividual owlIndividual : individuals) {
            Element curElement = doc.createElement("defindividual");
            curElement.setAttribute("name", owlIndividual.getName());
            parentNode.appendChild(curElement);
            this.renderAxioms(owlIndividual, doc, parentNode);
        }
    }

    public boolean render(OWLNamedClass cls, Document doc, Node parentNode) {
        boolean ret = true;
        if (!this.clsesToIgnore.contains(cls)) {
            Element element;
            OWLModel model = cls.getOWLModel();
            if (cls.equals(model.getOWLThingClass())) {
                element = doc.createElement("top");
            } else if (cls.equals(model.getOWLNothing())) {
                element = doc.createElement("bottom");
            } else {
                String name = cls.getName();
                element = doc.createElement("catom");
                element.setAttribute("name", name);
            }
            parentNode.appendChild(element);
        } else {
            ret = false;
        }
        return ret;
    }

    public boolean render(OWLSomeValuesFrom someRestriction, Document doc, Node parentNode) throws DIGReasonerException {
        boolean ret = true;
        ret = this.isSupportedLanguageElement("some");
        if (ret) {
            ret = this.render((OWLQuantifierRestriction)someRestriction, doc, parentNode);
        } else {
            this.logErrorOrWarning(someRestriction, "Existential (some values from) restrictions are not\nsupported by this reasoner.", "Ignoring restriction and attempting to continue.");
        }
        return ret;
    }

    public boolean render(OWLAllValuesFrom allRestriction, Document doc, Node parentNode) throws DIGReasonerException {
        boolean ret = true;
        ret = this.isSupportedLanguageElement("all");
        if (ret) {
            ret = this.render((OWLQuantifierRestriction)allRestriction, doc, parentNode);
        } else {
            this.logErrorOrWarning(allRestriction, "Universal (all values from) restrictions are not\nsupported by this reasoner.", "Ignoring restriction and attempting to continue.");
        }
        return ret;
    }

    protected boolean render(OWLQuantifierRestriction quantifierRestriction, Document doc, Node parentNode) throws DIGReasonerException {
        boolean ret = true;
        ret = quantifierRestriction.getFiller() instanceof RDFSClass ? this.renderQuantifierObjectRestriction(quantifierRestriction, doc, parentNode) : this.renderQuantifierDataRestriction(quantifierRestriction, doc, parentNode);
        return ret;
    }

    public boolean renderQuantifierObjectRestriction(OWLQuantifierRestriction quantifierRestriction, Document doc, Node parentNode) throws DIGReasonerException {
        boolean ret = true;
        String elementName = quantifierRestriction instanceof OWLSomeValuesFrom ? "some" : "all";
        Element element = doc.createElement(elementName);
        if (this.renderAppropriateSlot(quantifierRestriction.getOnProperty(), doc, element)) {
            ret = this.renderAppropriateCls((RDFSClass)quantifierRestriction.getFiller(), doc, element);
        }
        if (ret) {
            parentNode.appendChild(element);
        }
        return ret;
    }

    public boolean renderQuantifierDataRestriction(OWLQuantifierRestriction quantifierRestriction, Document doc, Node parentNode) throws DIGReasonerException {
        boolean ret = true;
        Element element = null;
        RDFResource filler = quantifierRestriction.getFiller();
        if (filler instanceof OWLDataRange) {
            OWLDataRange dataRange = (OWLDataRange)filler;
            RDFList oneOf = dataRange.getOneOf();
            List values = oneOf == null ? Collections.EMPTY_LIST : oneOf.getValues();
            element = doc.createElement("or");
            Iterator valuesIt = values.iterator();
            while (valuesIt.hasNext()) {
                RDFSLiteral curValue = quantifierRestriction.getOWLModel().asRDFSLiteral(valuesIt.next());
                DIGDataTypes digDataTypes = DIGDataTypes.getInstance(quantifierRestriction.getOWLModel());
                if (digDataTypes.isSupported(curValue)) {
                    String tagName = digDataTypes.getConcreteDomainExpressionTagName(curValue);
                    String datatypeRendering = digDataTypes.getDataTypeRendering(curValue);
                    Element valueRestrictionElement = doc.createElement(tagName);
                    valueRestrictionElement.setAttribute("val", datatypeRendering);
                    ret = this.renderAppropriateSlot(quantifierRestriction.getOnProperty(), doc, valueRestrictionElement);
                    if (!ret) continue;
                    element.appendChild(valueRestrictionElement);
                    continue;
                }
                ret = false;
                this.logErrorOrWarning(quantifierRestriction, "The enuerated datatypes filler contains an unsupported\ndatatype (" + curValue + ").", "Ignoring this restriction and attempting to continue.");
                break;
            }
        } else {
            this.logErrorOrWarning(quantifierRestriction, "The current version of the DIG interface does not support\nquantifier restrictions on datatype properties.", "Ignoring this restriction and attempting to continue.");
            ret = false;
        }
        if (ret) {
            parentNode.appendChild(element);
        }
        return ret;
    }

    public boolean render(OWLHasValue hasRestriction, Document doc, Node parentNode) throws DIGReasonerException {
        boolean ret = true;
        Element element = null;
        OWLProperty restrictedProperty = (OWLProperty)hasRestriction.getOnProperty();
        if (restrictedProperty.isObjectProperty()) {
            if (hasRestriction.getHasValue() instanceof RDFIndividual) {
                if (this.isSupportedLanguageElement("some")) {
                    element = doc.createElement("some");
                    ret = this.renderAppropriateSlot(hasRestriction.getOnProperty(), doc, element);
                    if (ret) {
                        if (this.isSupportedLanguageElement("iset")) {
                            Element isetElement = doc.createElement("iset");
                            ret = this.render((RDFIndividual)hasRestriction.getHasValue(), doc, (Node)isetElement);
                            if (ret) {
                                element.appendChild(isetElement);
                            }
                        } else {
                            this.logErrorOrWarning(hasRestriction, "Has value restrictions are not supported by this reasoner.\n(Indirectly caused by no support for individual enumerations).", "Ignoring this restriction and attempting to continue.");
                            ret = false;
                        }
                    }
                } else {
                    this.logErrorOrWarning(hasRestriction, "Has value restrictions are not supported by this reasoner.\n(Indirectly caused by no support for existential restrictions).", "Ignoring this restriction and attempting to continue.");
                    ret = false;
                }
            } else {
                ret = false;
                this.logErrorOrWarning(hasRestriction, "The ontology is in OWL-FULL.\nThis is because the filler for a hasValue object property\nrestriction is not an individual.", "Ignoring restriction and attempting to continue.");
            }
        } else {
            ret = false;
            this.logErrorOrWarning(hasRestriction, "DIG 1.1 (The language used to communicate with the reasoner)\ndoes not support hasValue restrictions on datatype properties\n", "Ignoring restriction and attempting to continue.");
        }
        if (ret) {
            parentNode.appendChild(element);
        }
        return ret;
    }

    public boolean render(OWLMinCardinality minCardiRestriction, Document doc, Node parentNode) throws DIGReasonerException {
        boolean ret = true;
        if (this.isSupportedLanguageElement("atleast")) {
            ret = this.render(minCardiRestriction, doc, parentNode, "atleast");
        } else {
            ret = false;
            this.logErrorOrWarning(minCardiRestriction, "Minimum cardinality restrictions are not supported by this reasoner.", "Ignoring this restriction and attempting to continue.");
        }
        return ret;
    }

    public boolean render(OWLMaxCardinality maxCardiRestriction, Document doc, Node parentNode) throws DIGReasonerException {
        boolean ret = true;
        if (this.isSupportedLanguageElement("atmost")) {
            ret = this.render(maxCardiRestriction, doc, parentNode, "atmost");
        } else {
            ret = false;
            this.logErrorOrWarning(maxCardiRestriction, "Maximum cardinality restrictions are not supported by this reasoner.", "Ignoring this restriction and attempting to continue.");
        }
        return ret;
    }

    public boolean render(OWLCardinality cardiRestriction, Document doc, Node parentNode) throws DIGReasonerException {
        boolean ret = true;
        if (this.isSupportedLanguageElement("and")) {
            Element andElement = doc.createElement("and");
            if (this.isSupportedLanguageElement("atleast")) {
                ret = this.render(cardiRestriction, doc, (Node)andElement, "atleast");
            } else {
                ret = false;
                this.logErrorOrWarning(cardiRestriction, "Cardinality restrictions are not supported by this reasoner.\n(Indirectly caused by lack of support for max cardinality restrictions).", "Ignoring this restriction and attempting to continue.");
            }
            if (ret) {
                if (this.isSupportedLanguageElement("atmost")) {
                    ret = this.render(cardiRestriction, doc, (Node)andElement, "atmost");
                } else {
                    ret = false;
                    this.logErrorOrWarning(cardiRestriction, "Cardinality restrictions are not supported by this reasoner.\n(Indirectly caused by lack of support for min cardinality restrictions).", "Ignoring this restriction and attempting to continue.");
                }
            }
            if (ret) {
                parentNode.appendChild(andElement);
            }
        } else {
            ret = false;
            this.logErrorOrWarning(cardiRestriction, "Cardinality restrictions are not supported by this reasoner.\n(Indirectly causedby lack of support for intersection classes.)", "Ignoring this restriction and attepting to continue.");
        }
        return ret;
    }

    protected boolean render(OWLCardinalityBase cardinalityRestriction, Document doc, Node parentNode, String digTypeName) throws DIGReasonerException {
        boolean ret = true;
        if (!(cardinalityRestriction.getOnProperty() instanceof OWLProperty)) {
            this.logErrorOrWarning(cardinalityRestriction, "The property " + cardinalityRestriction.getOnProperty().getBrowserText() + " on the restriction\n" + cardinalityRestriction.getBrowserText() + " is not an OWLProperty.\n", "Ignoring this restriction and attempting to continue.");
            ret = false;
            return ret;
        }
        OWLProperty property = (OWLProperty)cardinalityRestriction.getOnProperty();
        if (property.isObjectProperty()) {
            if (((OWLObjectProperty)property).isTransitive()) {
                ret = false;
                this.logErrorOrWarning(cardinalityRestriction, "The property " + property.getBrowserText() + " is transitive.\n" + "OWL-DL does not allow transitive properties to be used\n" + "is cardinality restrictions.", "Ignoring this restriction and attempting to continue.");
            } else {
                RDFProperty inverseSlot = property.getInverseProperty();
                if (inverseSlot != null && ((OWLObjectProperty)inverseSlot).isTransitive()) {
                    ret = false;
                    this.logErrorOrWarning(cardinalityRestriction, "The inverse property of " + property.getBrowserText() + " (" + inverseSlot.getBrowserText() + ")\n" + "is transitive. OWL-DL does not allow transitive properties, or\n" + "properties whose inverse property is transitive to be used in\n" + "cardinality restrictions.", "Ignoring this restriction and attempting to continue.");
                }
            }
        } else {
            ret = false;
            this.logErrorOrWarning(cardinalityRestriction, "Not able to convert datatype property cardinality restrictions\nto DIG (the langauge used to communicate with the reasoner).", "Ignoring this restriction and attempting to continue.");
        }
        if (ret) {
            Element element = null;
            element = doc.createElement(digTypeName);
            element.setAttribute("num", Integer.toString(cardinalityRestriction.getCardinality()));
            ret = this.renderAppropriateSlot(cardinalityRestriction.getOnProperty(), doc, element);
            if (ret) {
                this.renderAppropriateCls(cardinalityRestriction.getQualifier(), doc, element);
            }
            if (ret) {
                parentNode.appendChild(element);
            }
        }
        return ret;
    }

    public boolean render(OWLUnionClass unionCls, Document doc, Node parentNode) throws DIGReasonerException {
        boolean ret = true;
        if (this.isSupportedLanguageElement("or")) {
            ret = this.render(unionCls, doc, parentNode, "or");
        } else {
            ret = false;
            this.logErrorOrWarning(unionCls, "Union classes (disjunctions) are not supported by this reasoner.", "Ignoring this class and attemptng to continue.");
        }
        return ret;
    }

    public boolean render(OWLComplementClass complementCls, Document doc, Node parentNode) throws DIGReasonerException {
        boolean ret = true;
        if (this.isSupportedLanguageElement("not")) {
            ret = this.render(complementCls, doc, parentNode, "not");
        } else {
            ret = false;
            this.logErrorOrWarning(complementCls, "Complement classes are not supported by this reasoner.", "Ignoring this class and attemptng to continue.");
        }
        return ret;
    }

    public boolean render(OWLIntersectionClass intersectionCls, Document doc, Node parentNode) throws DIGReasonerException {
        boolean ret = true;
        if (this.isSupportedLanguageElement("and")) {
            ret = this.render(intersectionCls, doc, parentNode, "and");
        } else {
            ret = false;
            this.logErrorOrWarning(intersectionCls, "Intersection classes (conjunctions) are not supported by this reasoner.", "Ignoring this class and attemptng to continue.");
        }
        return ret;
    }

    protected boolean render(OWLLogicalClass logicalCls, Document doc, Node parentNode, String digTypeName) throws DIGReasonerException {
        boolean ret = true;
        Element element = null;
        element = doc.createElement(digTypeName);
        Collection operands = null;
        operands = logicalCls instanceof OWLNAryLogicalClass ? ((OWLNAryLogicalClass)logicalCls).getOperands() : (Collection)Collections.singleton(((OWLComplementClass)logicalCls).getComplement());
        for (RDFResource curInstance : operands) {
            if (curInstance instanceof RDFSClass) {
                ret = this.renderAppropriateCls((RDFSClass)curInstance, doc, element);
                if (ret) continue;
                break;
            }
            this.logErrorOrWarning(logicalCls, "Intersection, Union and Complement classes may only\ncontain operands that are OWL Classes.", "Ignoring class and attempting to continue.");
            ret = false;
            break;
        }
        if (ret) {
            parentNode.appendChild(element);
        }
        return ret;
    }

    public boolean render(OWLEnumeratedClass enumerationCls, Document doc, Node parentNode) throws DIGReasonerException {
        boolean ret = true;
        if (this.isSupportedLanguageElement("iset")) {
            Element element = doc.createElement("iset");
            Collection enumerationValues = enumerationCls.getOneOf();
            for (Object curValue : enumerationValues) {
                if (curValue instanceof RDFIndividual) {
                    ret = this.render((RDFIndividual)curValue, doc, (Node)element);
                    if (ret) continue;
                    break;
                }
                this.logErrorOrWarning(enumerationCls, "The ontology is in OWL-Full.\nEnumerated classes can only be made up of enumerations\nof individuals.", "Ignoring enumerated class.");
                ret = false;
                break;
            }
            if (ret) {
                parentNode.appendChild(element);
            }
        } else {
            ret = false;
            this.logErrorOrWarning(enumerationCls, "Enumeration classes are not supported by this reasoner.", "Ignoring this class and attempting to continue.");
        }
        return ret;
    }

    public boolean render(OWLObjectProperty slot, Document doc, Node parentNode) {
        boolean ret = true;
        Element element = null;
        if (!this.slotsToIgnore.contains(slot)) {
            element = doc.createElement("ratom");
            element.setAttribute("name", slot.getName());
            parentNode.appendChild(element);
        } else {
            ret = false;
        }
        return ret;
    }

    public boolean render(OWLDatatypeProperty slot, Document doc, Node parentNode) throws DIGReasonerException {
        boolean ret = true;
        if (this.isSupportedLanguageElement("attribute")) {
            if (!this.slotsToIgnore.contains(slot)) {
                Element element = doc.createElement("attribute");
                element.setAttribute("name", slot.getName());
                parentNode.appendChild(element);
            } else {
                ret = false;
            }
        } else {
            ret = false;
            this.logErrorOrWarning(slot, "Datatype properties are not supported by this reasoner.", "Ignoring property and attempting to continue.");
        }
        return ret;
    }

    public boolean render(RDFIndividual instance, Document doc, Node parentNode) throws DIGReasonerException {
        boolean ret = true;
        Element element = doc.createElement("individual");
        element.setAttribute("name", instance.getName());
        parentNode.appendChild(element);
        return ret;
    }

    public void renderAxioms(OWLNamedClass cls, Document doc, Node parentNode) throws DIGReasonerException {
        ClassCommenter commenter;
        boolean ret = true;
        boolean ignoreNecessaryConditions = DIGTranslatorPreferences.getInstance().isIgnoreNecessaryConditionsOnDefinedClasses();
        if (!cls.isDefinedClass() || !ignoreNecessaryConditions) {
            Collection directPureSuperClses = cls.getPureSuperclasses();
            for (RDFSClass curSuperClass : directPureSuperClses) {
                Element impliesElement;
                if (curSuperClass.equals(curSuperClass.getOWLModel().getOWLThingClass()) || (commenter = new ClassCommenter(cls.getOWLModel())).isCommentedOut(curSuperClass) || !(ret = this.render(cls, doc, (Node)(impliesElement = doc.createElement("impliesc")))) || !(ret = this.renderAppropriateCls(curSuperClass, doc, impliesElement))) continue;
                parentNode.appendChild(impliesElement);
            }
            Collection disjointClses = cls.getDisjointClasses();
            for (RDFSClass curDisjointClass : disjointClses) {
                Element disjointElement;
                ClassCommenter commenter2;
                if (curDisjointClass.getEquivalentClasses().size() > 0 && ignoreNecessaryConditions || (commenter2 = new ClassCommenter(cls.getOWLModel())).isCommentedOut(curDisjointClass) || !(ret = this.render(cls, doc, (Node)(disjointElement = doc.createElement("disjoint"))))) continue;
                ret = this.renderAppropriateCls(curDisjointClass, doc, disjointElement);
                ret = true;
                if (!true) continue;
                parentNode.appendChild(disjointElement);
            }
        }
        Collection equivalentClses = cls.getEquivalentClasses();
        for (RDFSClass curEquivClass : equivalentClses) {
            Element equalElement;
            commenter = new ClassCommenter(cls.getOWLModel());
            if (commenter.isCommentedOut(curEquivClass) || !(ret = this.render(cls, doc, (Node)(equalElement = doc.createElement("equalc"))))) continue;
            if (!(curEquivClass instanceof OWLIntersectionClass)) {
                Element andElement = doc.createElement("and");
                ret = this.renderAppropriateCls(curEquivClass, doc, andElement);
                equalElement.appendChild(andElement);
            } else {
                ret = this.renderAppropriateCls(curEquivClass, doc, equalElement);
            }
            ret = true;
            if (!true) continue;
            parentNode.appendChild(equalElement);
        }
    }

    public void renderAxioms(OWLProperty property, Document doc, Node parentNode) throws DIGReasonerException {
        this.renderSuperSlots(property, doc, parentNode);
        this.renderEquivalentSlots(property, doc, parentNode);
        this.renderSlotDomain(property, doc, parentNode);
        this.renderSlotRange(property, doc, parentNode);
        this.renderInverseSlot(property, doc, parentNode);
        if (property.isObjectProperty()) {
            this.renderTransitiveSlot(property, doc, parentNode);
            if (property.isInverseFunctional()) {
                this.renderInverseFunctionalSlot(property, doc, parentNode);
            }
            if (((OWLObjectProperty)property).isSymmetric()) {
                this.renderSymmetricSlot(property, doc, parentNode);
            }
        }
        if (property.isFunctional()) {
            this.renderFunctionalSlot(property, doc, parentNode);
        }
    }

    protected void renderSuperSlots(OWLProperty property, Document doc, Node parentNode) throws DIGReasonerException {
        Collection superSlots = property.getSuperproperties(false);
        for (Slot curSlot : superSlots) {
            Element impliesElement = doc.createElement("impliesr");
            boolean ret = this.renderAppropriateSlot(property, doc, impliesElement);
            if (!ret || !(ret = this.renderAppropriateSlot(curSlot, doc, impliesElement))) continue;
            parentNode.appendChild(impliesElement);
        }
    }

    protected void renderEquivalentSlots(OWLProperty property, Document doc, Node parentNode) throws DIGReasonerException {
        Collection equivSlots = property.getEquivalentProperties();
        for (Slot curSlot : equivSlots) {
            Element equivElement = doc.createElement("equalr");
            boolean ret = this.renderAppropriateSlot(property, doc, equivElement);
            if (!ret || !(ret = this.renderAppropriateSlot(curSlot, doc, equivElement))) continue;
            parentNode.appendChild(equivElement);
        }
    }

    protected void renderSlotDomain(OWLProperty property, Document doc, Node parentNode) throws DIGReasonerException {
        Collection directDomain = property.getDomains(false);
        Iterator directDomainIt = directDomain.iterator();
        Element domainElement = doc.createElement("domain");
        OWLNamedClass rootCls = property.getOWLModel().getOWLThingClass();
        while (directDomainIt.hasNext()) {
            Object curObj = directDomainIt.next();
            if (!(curObj instanceof OWLClass) || rootCls.equals(curObj) || !this.renderAppropriateSlot(property, doc, domainElement)) continue;
            parentNode.appendChild(domainElement);
            this.renderAppropriateCls((OWLClass)curObj, doc, domainElement);
        }
    }

    protected void renderSlotRange(OWLProperty property, Document doc, Node parentNode) throws DIGReasonerException {
        if (property.isObjectProperty()) {
            Collection allowedClses = property.getUnionRangeClasses();
            Iterator allowedClsesIt = allowedClses.iterator();
            Element rangeOrElement = doc.createElement("or");
            Element rangeElement = doc.createElement("range");
            while (allowedClsesIt.hasNext()) {
                Object curObj = allowedClsesIt.next();
                if (!(curObj instanceof RDFSClass)) continue;
                this.renderAppropriateCls((RDFSClass)curObj, doc, rangeOrElement);
            }
            if (rangeOrElement.getChildNodes().getLength() > 0 && this.renderAppropriateSlot(property, doc, rangeElement)) {
                rangeElement.appendChild(rangeOrElement);
                parentNode.appendChild(rangeElement);
            }
        } else {
            RDFSDatatype datatype = property.getRangeDatatype();
            DIGDataTypes digDataTypes = DIGDataTypes.getInstance(property.getOWLModel());
            if (digDataTypes.isSupported(datatype)) {
                Element rangeElement = doc.createElement(digDataTypes.getPropertyRangeTagName(datatype));
                boolean ret = this.renderAppropriateSlot(property, doc, rangeElement);
                if (ret) {
                    parentNode.appendChild(rangeElement);
                }
            } else {
                this.logErrorOrWarning(property, "DIG 1.1 (The language used to communicate with the reasoner)\ndoes not support the range specified for the datatype property\n" + property.getBrowserText() + ".", "Ignoring this range on this property.");
            }
        }
    }

    protected void renderInverseSlot(OWLProperty property, Document doc, Node parentNode) throws DIGReasonerException {
        Element equalRoleElement;
        Element inverseElement;
        boolean ret;
        OWLProperty inverseProperty = (OWLProperty)property.getInverseProperty();
        if (inverseProperty != null && (ret = this.renderAppropriateSlot(inverseProperty, doc, inverseElement = doc.createElement("inverse"))) && (ret = this.renderAppropriateSlot(property, doc, equalRoleElement = doc.createElement("equalr")))) {
            equalRoleElement.appendChild(inverseElement);
            parentNode.appendChild(equalRoleElement);
        }
    }

    protected void renderInverseFunctionalSlot(OWLProperty property, Document doc, Node parentNode) throws DIGReasonerException {
        OWLProperty inverseProperty = (OWLProperty)property.getInverseProperty();
        if (((OWLObjectProperty)property).isTransitive()) {
            this.logErrorOrWarning(property, "The ontology is in OWL-Full.\nThis has been caused by the property " + property.getBrowserText() + "\n" + "being transitive and inverse functional.", "Ignoring inverse functional characteristic on this property\nand attempting to continue.");
        } else if (inverseProperty == null) {
            Element fakeInverseSlotElementDef = doc.createElement("defrole");
            String fakeName = "*Inverse_of_" + property.getName();
            fakeInverseSlotElementDef.setAttribute("name", fakeName);
            parentNode.appendChild(fakeInverseSlotElementDef);
            Element fakeInverseSlotElement = doc.createElement("ratom");
            fakeInverseSlotElement.setAttribute("name", fakeName);
            Element equalRoleElement = doc.createElement("equalr");
            this.renderAppropriateSlot(property, doc, equalRoleElement);
            Element inverseElement = doc.createElement("inverse");
            inverseElement.appendChild(fakeInverseSlotElement);
            equalRoleElement.appendChild(inverseElement);
            parentNode.appendChild(equalRoleElement);
            Element functionalElement = doc.createElement("functional");
            Element fakeInverseSlotElement2 = doc.createElement("ratom");
            fakeInverseSlotElement2.setAttribute("name", fakeName);
            functionalElement.appendChild(fakeInverseSlotElement2);
            doc.getDocumentElement().appendChild(functionalElement);
        } else {
            this.renderFunctionalSlot(inverseProperty, doc, parentNode);
        }
    }

    protected void renderTransitiveSlot(OWLProperty property, Document doc, Node parentNode) throws DIGReasonerException {
        Element transitiveElement;
        boolean ret;
        if (((OWLObjectProperty)property).isTransitive() && (ret = this.renderAppropriateSlot(property, doc, transitiveElement = doc.createElement("transitive")))) {
            parentNode.appendChild(transitiveElement);
        }
    }

    protected void renderSymmetricSlot(OWLProperty property, Document doc, Node parentNode) throws DIGReasonerException {
        Element equalRoleElement = doc.createElement("equalr");
        boolean ret = this.renderAppropriateSlot(property, doc, equalRoleElement);
        if (ret) {
            Element inverseElement = doc.createElement("inverse");
            this.renderAppropriateSlot(property, doc, inverseElement);
            equalRoleElement.appendChild(inverseElement);
            parentNode.appendChild(equalRoleElement);
        }
    }

    protected void renderFunctionalSlot(OWLProperty property, Document doc, Node parentNode) throws DIGReasonerException {
        if (property.isObjectProperty() && ((OWLObjectProperty)property).isTransitive()) {
            this.logErrorOrWarning(property, "The ontology is in OWL-Full.\nThis is because the property " + property.getBrowserText() + " is both\n" + "transitive and functional.", "Ignoring the functional characteristic of this property and\nattempting to continue.");
            return;
        }
        Element functionalElement = doc.createElement("functional");
        boolean ret = this.renderAppropriateSlot(property, doc, functionalElement);
        if (ret) {
            parentNode.appendChild(functionalElement);
        }
    }

    private void renderFakeSameAs(Collection sameAsInstances, Document doc, Node parentNode) throws DIGReasonerException {
        Object[] sameAsInstancesArray = sameAsInstances.toArray();
        int i = 0;
        while (i < sameAsInstancesArray.length) {
            int j = 0;
            while (j < sameAsInstancesArray.length) {
                if (i != j) {
                    RDFIndividual instI = (RDFIndividual)sameAsInstancesArray[i];
                    Element isetI = doc.createElement("iset");
                    this.render(instI, doc, (Node)isetI);
                    RDFIndividual instJ = (RDFIndividual)sameAsInstancesArray[j];
                    Element isetJ = doc.createElement("iset");
                    this.render(instJ, doc, (Node)isetJ);
                    Element equalElement = doc.createElement("equalc");
                    equalElement.appendChild(isetI);
                    equalElement.appendChild(isetJ);
                    parentNode.appendChild(equalElement);
                }
                ++j;
            }
            ++i;
        }
    }

    public void renderAxioms(RDFIndividual instance, Document doc, Node parentNode) throws DIGReasonerException {
        RDFProperty differentFromSlot;
        Collection differentFrom;
        this.renderTypes(instance, doc, parentNode);
        Collection sameAs = instance.getSameAs();
        if (!sameAs.isEmpty()) {
            if (this.isSupportedTellElement("sameas")) {
                for (RDFIndividual curSameAs : sameAs) {
                    Element sameAsElement = doc.createElement("sameas");
                    if (!this.render(instance, doc, (Node)sameAsElement) || !this.render(curSameAs, doc, (Node)sameAsElement)) continue;
                    parentNode.appendChild(sameAsElement);
                }
            } else {
                this.logErrorOrWarning(instance, "SameAs construct for individuals is not supported\nby this reasoner.", "Ignoring this assertion.");
            }
        }
        if (!(differentFrom = instance.getPropertyValues(differentFromSlot = instance.getOWLModel().getRDFProperty("owl:differentFrom"), true)).isEmpty()) {
            if (this.isSupportedTellElement("differentfrom")) {
                for (RDFIndividual curDifferentFrom : differentFrom) {
                    Element differentFromElement = doc.createElement("differentfrom");
                    if (!this.render(instance, doc, (Node)differentFromElement) || !this.render(curDifferentFrom, doc, (Node)differentFromElement)) continue;
                    parentNode.appendChild(differentFromElement);
                }
            } else {
                Iterator differentFromIt = differentFrom.iterator();
                ArrayList<RDFIndividual> allDifferentList = new ArrayList<RDFIndividual>();
                allDifferentList.add(instance);
                while (differentFromIt.hasNext()) {
                    allDifferentList.add((RDFIndividual)differentFromIt.next());
                }
                this.renderFakedDifferentFrom(allDifferentList, doc, parentNode);
            }
        }
        for (RDFProperty curProp : instance.getOWLModel().getRDFProperties()) {
            boolean ret;
            if (curProp.isAnnotationProperty() || !(curProp instanceof OWLProperty)) continue;
            if (((OWLProperty)curProp).isObjectProperty()) {
                for (Object curObjVal : instance.getPropertyValues(curProp)) {
                    if (curObjVal instanceof OWLIndividual) {
                        Element relatedElement = doc.createElement("related");
                        ret = this.render(instance, doc, (Node)relatedElement);
                        if (!ret || !(ret = this.renderAppropriateSlot(curProp, doc, relatedElement)) || !(ret = this.render((OWLIndividual)curObjVal, doc, (Node)relatedElement))) continue;
                        parentNode.appendChild(relatedElement);
                        continue;
                    }
                    this.logErrorOrWarning(instance, "The ontology is in OWL-Full.\nThe filler for an object property relationship is not\nan individual.", "Ignoring this relationship and attempting to continue.");
                }
                continue;
            }
            Iterator it = instance.getPropertyValueLiterals(curProp).iterator();
            while (it.hasNext()) {
                Object curValue;
                RDFSLiteral value;
                OWLModel owlModel = curProp.getOWLModel();
                DIGDataTypes digDataTypes = DIGDataTypes.getInstance(owlModel);
                if (digDataTypes.isSupported(value = owlModel.asRDFSLiteral(curValue = it.next()))) {
                    Element valueElement = doc.createElement("value");
                    ret = this.render(instance, doc, (Node)valueElement);
                    if (!ret || !(ret = this.renderAppropriateSlot(curProp, doc, valueElement))) continue;
                    String datatypeValueElementName = digDataTypes.getIndividualAxiomValueTagName(value);
                    Element datatypeValueElement = doc.createElement(datatypeValueElementName);
                    valueElement.appendChild(datatypeValueElement);
                    Text valueContent = doc.createTextNode(digDataTypes.getDataTypeRendering(value));
                    datatypeValueElement.appendChild(valueContent);
                    parentNode.appendChild(valueElement);
                    continue;
                }
                this.logErrorOrWarning(instance, "The current version of DIG (the language used to communicate)\nwith the reasoner) does not support the datatype used in the\n" + curProp.getBrowserText() + " relationship.", "Ignoring this relationship and attempting to continue.");
            }
        }
    }

    protected void renderTypes(RDFIndividual instance, Document doc, Node parentNode) throws DIGReasonerException {
        Collection directTypes = instance.getRDFTypes();
        for (Object curObj : directTypes) {
            Element instanceOfElement;
            boolean ret;
            if (!(curObj instanceof OWLClass) || curObj instanceof OWLEnumeratedClass || !(ret = this.render(instance, doc, (Node)(instanceOfElement = doc.createElement("instanceof")))) || !(ret = this.renderAppropriateCls((OWLClass)curObj, doc, instanceOfElement))) continue;
            parentNode.appendChild(instanceOfElement);
        }
    }

    protected boolean isSupportedTellElement(String elementTagName) {
        boolean retVal = true;
        if (this.reasonerIdentity != null) {
            retVal = this.reasonerIdentity.supportsTellElemement(elementTagName);
        }
        return retVal;
    }

    protected boolean isSupportedAskElement(String elementTagName) {
        boolean retVal = true;
        if (this.reasonerIdentity != null) {
            retVal = this.reasonerIdentity.supportsAskElement(elementTagName);
        }
        return retVal;
    }

    protected boolean isSupportedLanguageElement(String elementTagName) {
        boolean retVal = true;
        if (this.reasonerIdentity != null) {
            retVal = this.reasonerIdentity.supportsLanguageElement(elementTagName);
        }
        return retVal;
    }

    protected void logErrorOrWarning(RDFResource cause, String message, String recoveryMessage) throws DIGReasonerException {
        if (ReasonerPreferences.getInstance().isWarningAsErrors()) {
            throw new DIGReasonerException(message);
        }
        String msg = String.valueOf(message) + "\n" + recoveryMessage;
        ReasonerLogRecordFactory logRecordFactory = ReasonerLogRecordFactory.getInstance();
        ReasonerLogRecord logRecord = logRecordFactory.createWarningMessageLogRecord(cause, msg, null);
        ReasonerLogger.getInstance().postLogRecord(logRecord);
    }
}

