/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class RDFSNamedClassPostProcessor {
    private KnowledgeBase kb;
    private OWLModel owlModel;

    RDFSNamedClassPostProcessor(OWLModel owlModel) {
        this.owlModel = owlModel;
        this.kb = owlModel;
        RDFProperty owlOneOfProperty = owlModel.getOWLOneOfProperty();
        owlModel.getOWLFrameStore().setSuperclassSynchronizationBlocked(true);
        Collection clses = owlModel.getUserDefinedRDFSNamedClasses();
        for (RDFSNamedClass cls : clses) {
            if (cls.getPropertyValues(owlOneOfProperty).size() == 1) {
                this.convertToOWLEnumeratedClass(cls);
                continue;
            }
            this.updateEquivalentClasses(cls);
            this.updateDirectSuperclasses(cls);
        }
        owlModel.getOWLFrameStore().setSuperclassSynchronizationBlocked(false);
        if (((AbstractOWLModel)owlModel).isProtegeMetaOntologyImported()) {
            this.updateProtegeFeatures(clses);
        }
    }

    private void removeDuplicateSuperclasses(RDFSNamedClass cls) {
        ArrayList superclasses = new ArrayList(cls.getPureSuperclasses());
        int i = 0;
        while (i < superclasses.size() - 1) {
            if (superclasses.get(i) instanceof OWLAnonymousClass) {
                OWLAnonymousClass anon = (OWLAnonymousClass)superclasses.get(i);
                int j = superclasses.size() - 1;
                while (j > i) {
                    if (superclasses.get(j).getClass() == anon.getClass()) {
                        String browserText = ((Cls)superclasses.get(i)).getBrowserText();
                        OWLAnonymousClass other = (OWLAnonymousClass)superclasses.get(j);
                        if (other.getBrowserText().equals(browserText)) {
                            cls.removeDirectSuperclass(other);
                        }
                    }
                    --j;
                }
            }
            ++i;
        }
    }

    private void convertToOWLEnumeratedClass(Cls cls) {
        TripleStoreUtil.ensureActiveTripleStore((RDFResource)cls);
        cls.setDirectType(this.kb.getCls("owl:EnumeratedClass"));
        cls.setDirectOwnSlotValue((Slot)this.owlModel.getRDFTypeProperty(), (Object)this.owlModel.getOWLNamedClassClass());
    }

    private void updateDirectSuperclasses(Cls cls) {
        Collection supis = cls.getDirectSuperclasses();
        for (Object next : supis) {
            if (!(next instanceof Cls)) {
                throw new RuntimeException("Illegal superclass " + next + " of " + cls.getName() + " has type " + next.getClass());
            }
            Cls other = (Cls)next;
            if (!(other instanceof RDFSNamedClass) || other.hasDirectSuperclass(cls)) continue;
            return;
        }
        TripleStoreUtil.ensureActiveTripleStore((RDFResource)cls);
        cls.addDirectSuperclass(this.kb.getRootCls());
    }

    private void updateEquivalentClasses(Cls cls) {
        List equis = cls.getDirectOwnSlotValues((Slot)this.owlModel.getOWLEquivalentClassProperty());
        for (Cls equiCls : equis) {
            TripleStoreUtil.ensureActiveTripleStore((RDFResource)cls);
            cls.addDirectSuperclass(equiCls);
            equiCls.addDirectSuperclass(cls);
        }
    }

    private void updateProtegeFeatures(Collection clses) {
        RDFProperty abstractSlot = this.owlModel.getRDFProperty("protege:abstract");
        for (Cls cls : clses) {
            if (!Boolean.TRUE.equals(cls.getDirectOwnSlotValue((Slot)abstractSlot))) continue;
            TripleStoreUtil.ensureActiveTripleStore((RDFResource)cls);
            cls.setAbstract(true);
        }
    }
}

