/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARPEventHandler;
import com.hp.hpl.jena.rdf.arp.ARPSaxErrorHandler;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.NTriple;
import com.hp.hpl.jena.rdf.arp.test.InFactoryX;
import com.hp.hpl.jena.rdf.arp.test.TestScope;
import com.hp.hpl.jena.rdf.arp.test.WGTestSuite;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.shared.wg.TestInputStreamFactory;
import com.hp.hpl.jena.shared.wg.URI;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestSuite;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class NTripleTestSuite
extends WGTestSuite {
    NTripleTestSuite(TestInputStreamFactory testInputStreamFactory, String string, boolean bl) {
        super(testInputStreamFactory, string, bl);
    }

    static TestSuite suite(URI uRI, String string, String string2) {
        return new NTripleTestSuite(new TestInputStreamFactory(uRI, string), string2, true);
    }

    static TestSuite suite(URI uRI, URI uRI2, String string) {
        return new NTripleTestSuite(new TestInputStreamFactory(uRI, uRI2), string, true);
    }

    Model loadRDF(InFactoryX inFactoryX, RDFErrorHandler rDFErrorHandler, String string) throws IOException {
        return NTripleTestSuite.loadRDFx(inFactoryX, rDFErrorHandler, string, true, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Model loadRDFx(InFactoryX inFactoryX, RDFErrorHandler rDFErrorHandler, String string, boolean bl, int n) throws IOException {
        PrintStream printStream;
        File file;
        InputStream inputStream;
        InputStream inputStream2;
        block15: {
            Model model;
            TestHandler testHandler;
            PrintStream printStream2;
            inputStream2 = System.in;
            inputStream = null;
            file = null;
            if (bl) {
                file = File.createTempFile("arp", ".nt");
                printStream2 = new PrintStream(new FileOutputStream(file));
                testHandler = new TestHandler(rDFErrorHandler);
            } else {
                printStream2 = new PrintStream(new OutputStream(){

                    public void write(int n) throws IOException {
                    }
                });
                testHandler = new TestHandler(rDFErrorHandler, n);
            }
            printStream = System.out;
            try {
                block14: {
                    System.setIn(inFactoryX.open());
                    System.setOut(printStream2);
                    try {
                        NTriple.mainEh(new String[]{"-b", string, "-s"}, testHandler, testHandler);
                    }
                    catch (SimulatedException simulatedException) {
                        if (!bl) break block14;
                        throw simulatedException;
                    }
                }
                printStream2.close();
                testHandler.atEndOfFile();
                if (n == 0) {
                    for (int i = testHandler.getCount(); i >= 1; --i) {
                        NTripleTestSuite.loadRDFx(inFactoryX, TestScope.suppress, string, false, i);
                    }
                }
                if (!bl) break block15;
                inputStream = new FileInputStream(file);
                model = NTripleTestSuite.loadNT(inputStream, string);
                Object var13_15 = null;
            }
            catch (Throwable throwable) {
                block16: {
                    Object var13_17 = null;
                    System.in.close();
                    System.setIn(inputStream2);
                    System.setOut(printStream);
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (file == null) break block16;
                    file.delete();
                }
                throw throwable;
            }
            System.in.close();
            System.setIn(inputStream2);
            System.setOut(printStream);
            if (inputStream != null) {
                inputStream.close();
            }
            if (file != null) {
                file.delete();
            }
            return model;
        }
        Model model = null;
        Object var13_16 = null;
        System.in.close();
        System.setIn(inputStream2);
        System.setOut(printStream);
        if (inputStream != null) {
            inputStream.close();
        }
        if (file != null) {
            file.delete();
        }
        return model;
    }

    static class TestHandler
    extends ARPSaxErrorHandler
    implements ARPEventHandler,
    ErrorHandler {
        final int xCountDown;
        Set anon = new HashSet();
        Set oldAnon = new HashSet();
        int state = 1;
        int countDown;
        boolean hasErrors = false;

        TestHandler(RDFErrorHandler rDFErrorHandler) {
            this(rDFErrorHandler, 0);
        }

        TestHandler(RDFErrorHandler rDFErrorHandler, int n) {
            super(rDFErrorHandler);
            this.countDown = n;
            this.xCountDown = n;
        }

        public void statement(AResource aResource, AResource aResource2, AResource aResource3) {
            Assert.assertEquals((int)this.state, (int)2);
            this.seeing(aResource);
            this.seeing(aResource3);
            if (--this.countDown == 0) {
                throw new SimulatedException();
            }
        }

        private void seeing(AResource aResource) {
            if (aResource.isAnonymous()) {
                this.anon.add(aResource);
            }
            Assert.assertFalse((String)"bnode reuse?", (boolean)this.oldAnon.contains(aResource));
        }

        private void seen(AResource aResource) {
            if (!this.anon.contains(aResource)) {
                Assert.assertTrue((String)("end-scope for a bnode that had not been used " + aResource.getAnonymousID()), (boolean)this.anon.contains(aResource));
            }
            this.anon.remove(aResource);
            this.oldAnon.add(aResource);
        }

        public void statement(AResource aResource, AResource aResource2, ALiteral aLiteral) {
            Assert.assertEquals((String)"no start RDF seen", (int)this.state, (int)2);
            this.seeing(aResource);
            if (--this.countDown == 0) {
                throw new SimulatedException();
            }
        }

        public void endBNodeScope(AResource aResource) {
            Assert.assertTrue((boolean)aResource.isAnonymous());
            switch (this.state) {
                case 1: {
                    Assert.fail((String)"Missing startRDF");
                }
                case 2: {
                    Assert.assertFalse((boolean)aResource.hasNodeID());
                    this.seen(aResource);
                    break;
                }
                case 3: 
                case 4: {
                    Assert.assertTrue((boolean)aResource.hasNodeID());
                    this.seen(aResource);
                    this.state = 4;
                    break;
                }
                default: {
                    Assert.fail((String)"impossible - test logic error");
                }
            }
        }

        public void startRDF() {
            switch (this.state) {
                case 2: 
                case 4: {
                    Assert.fail((String)("Bad state for startRDF " + this.state));
                }
            }
            this.state = 2;
        }

        public void endRDF() {
            Assert.assertEquals((int)this.state, (int)2);
            this.state = 3;
        }

        public void startPrefixMapping(String string, String string2) {
        }

        public void endPrefixMapping(String string) {
        }

        public void atEndOfFile() {
            if (!this.anon.isEmpty()) {
                Iterator iterator = this.anon.iterator();
                while (iterator.hasNext()) {
                    System.err.print(((AResource)iterator.next()).getAnonymousID() + ", ");
                }
            }
            Assert.assertTrue((String)("(" + this.xCountDown + ") some bnode still in scope "), (boolean)this.anon.isEmpty());
            switch (this.state) {
                case 1: {
                    Assert.fail((String)"end-of-file before anything");
                }
                case 2: {
                    Assert.fail((String)"did not see endRDF");
                }
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    Assert.fail((String)"impossible logic error in test");
                }
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.hasErrors = true;
            super.error(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.hasErrors = true;
            super.fatalError(sAXParseException);
        }

        public int getCount() {
            return -this.countDown;
        }

        public boolean discardNodesWithNodeID() {
            return false;
        }
    }

    static class SimulatedException
    extends RuntimeException {
        SimulatedException() {
        }
    }
}

