/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.classparser.dl;

import edu.stanford.smi.protegex.owl.model.classdisplay.compact.CompactOWLClassDisplay;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class DLSyntaxParserUtil {
    private static final CompactOWLClassDisplay display = new CompactOWLClassDisplay();
    private static Map characterMap = new HashMap();

    static {
        DLSyntaxParserUtil.setUseDefaultCharacterMap();
    }

    public static void setCharacterMap(Map map) {
        characterMap = map;
    }

    public static void setUseDefaultCharacterMap() {
        characterMap = new HashMap();
        characterMap.put(display.getOWLMinCardinalitySymbol(), new Character('<'));
        characterMap.put(display.getOWLCardinalitySymbol(), new Character('='));
        characterMap.put(display.getOWLMinCardinalitySymbol(), new Character('>'));
        characterMap.put(display.getOWLAllValuesFromSymbol(), new Character('*'));
        characterMap.put(display.getOWLSomeValuesFromSymbol(), new Character('?'));
        characterMap.put(display.getOWLComplementOfSymbol(), new Character('!'));
        characterMap.put(display.getOWLIntersectionOfSymbol(), new Character('&'));
        characterMap.put(display.getOWLUnionOfSymbol(), new Character('|'));
    }

    public static String getParseableString(String str) {
        StringTokenizer tokenizer = new StringTokenizer(str, " ()[]{}", true);
        String result = "";
        while (tokenizer.hasMoreTokens()) {
            String curTok = tokenizer.nextToken();
            result = characterMap.containsKey(curTok) ? String.valueOf(result) + (Character)characterMap.get(curTok) : String.valueOf(result) + curTok;
        }
        return result;
    }
}

