/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.types;

import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyWidget;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;

public abstract class AbstractPropertyTypesWidget
extends AbstractPropertyWidget {
    private TypeCheckBox[] checkBoxes;

    private RDFProperty getEditedProperty() {
        return (RDFProperty)this.getEditedResource();
    }

    private RDFProperty getSuperpropertyWithType(RDFSNamedClass type) {
        for (RDFProperty superproperty : this.getEditedProperty().getSuperproperties(true)) {
            if (!superproperty.hasProtegeType(type)) continue;
            return superproperty;
        }
        return null;
    }

    private String getTypeLabel(RDFSNamedClass type) {
        return type.getName();
    }

    protected void initialize(RDFSNamedClass[] types) {
        this.checkBoxes = new TypeCheckBox[types.length];
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        int i = 0;
        while (i < types.length) {
            RDFSNamedClass type = types[i];
            this.checkBoxes[i] = new TypeCheckBox(type);
            this.add(this.checkBoxes[i]);
            this.add(Box.createVerticalStrut(4));
            ++i;
        }
    }

    private boolean isPropagatedType(RDFSClass type) {
        return type.equals(type.getOWLModel().getOWLFunctionalPropertyClass()) || type.equals(type.getOWLModel().getOWLInverseFunctionalPropertyClass());
    }

    protected boolean isValidChange(RDFSNamedClass type, boolean value) {
        RDFProperty superproperty;
        if (!value && this.isPropagatedType(type) && (superproperty = this.getSuperpropertyWithType(type)) != null) {
            ProtegeUI.getModalDialogFactory().showMessageDialog(type.getOWLModel(), "This property already has the " + this.getTypeLabel(type) + "\n" + "super-property " + superproperty.getBrowserText() + " and therefore\n" + "must also remain " + this.getTypeLabel(type) + ".", "Warning");
            return false;
        }
        return true;
    }

    protected void postProcessChange(RDFSNamedClass type) {
        RDFProperty property = this.getEditedProperty();
        RDFProperty inverseProperty = property.getInverseProperty();
        if (inverseProperty != null) {
            RDFSNamedClass functional = type.getOWLModel().getOWLFunctionalPropertyClass();
            RDFSNamedClass inverseFunctional = type.getOWLModel().getOWLInverseFunctionalPropertyClass();
            if (type.equals(functional)) {
                if (property.hasRDFType(functional)) {
                    if (!inverseProperty.hasRDFType(inverseFunctional)) {
                        inverseProperty.addRDFType(inverseFunctional);
                    }
                } else if (inverseProperty.hasRDFType(inverseFunctional)) {
                    inverseProperty.removeRDFType(inverseFunctional);
                }
            } else if (property.hasRDFType(inverseFunctional)) {
                if (!inverseProperty.hasRDFType(functional)) {
                    inverseProperty.addRDFType(functional);
                }
            } else if (inverseProperty.hasRDFType(functional)) {
                inverseProperty.removeRDFType(functional);
            }
        }
    }

    public void setEditable(boolean b) {
        int i = 0;
        while (i < this.checkBoxes.length) {
            boolean enabled = b;
            TypeCheckBox checkBox = this.checkBoxes[i];
            if (this.isPropagatedType(checkBox.type)) {
                Collection superproperties = this.getEditedProperty().getSuperproperties(true);
                for (RDFProperty superproperty : superproperties) {
                    if (!superproperty.hasRDFType(checkBox.type)) continue;
                    enabled = false;
                    break;
                }
            }
            checkBox.setEnabled(enabled);
            ++i;
        }
    }

    public void setValues(Collection values) {
        this.updateCheckBoxes();
    }

    private void updateCheckBoxes() {
        int i = 0;
        while (i < this.checkBoxes.length) {
            TypeCheckBox checkBox = this.checkBoxes[i];
            checkBox.updateSelection();
            ++i;
        }
    }

    private class TypeCheckBox
    extends JCheckBox {
        private RDFSNamedClass type;

        TypeCheckBox(RDFSNamedClass type) {
            String name = type.getLocalName();
            this.setText(name.substring(0, name.length() - "Property".length()));
            this.type = type;
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TypeCheckBox.this.addOrRemoveType();
                }
            });
        }

        private void addOrRemoveType() {
            RDFProperty property = AbstractPropertyTypesWidget.this.getEditedProperty();
            if (this.isSelected() && !property.hasProtegeType(this.type)) {
                if (AbstractPropertyTypesWidget.this.isValidChange(this.type, true)) {
                    property.addProtegeType(this.type);
                    AbstractPropertyTypesWidget.this.postProcessChange(this.type);
                } else {
                    this.setSelected(false);
                }
            } else if (!this.isSelected() && property.hasProtegeType(this.type)) {
                if (AbstractPropertyTypesWidget.this.isValidChange(this.type, false)) {
                    property.removeProtegeType(this.type);
                    AbstractPropertyTypesWidget.this.postProcessChange(this.type);
                } else {
                    this.setSelected(true);
                }
            }
        }

        void updateSelection() {
            boolean selected = AbstractPropertyTypesWidget.this.getEditedProperty().hasProtegeType(this.type);
            if (!selected && AbstractPropertyTypesWidget.this.isPropagatedType(this.type)) {
                selected = AbstractPropertyTypesWidget.this.getSuperpropertyWithType(this.type) != null;
            }
            this.setSelected(selected);
        }
    }
}

