/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.BrowserLauncher;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.PlasticHack;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import javax.swing.LookAndFeel;
import javax.swing.PopupFactory;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class SystemUtilities {
    private static final String OLD_PLASTIC_LAF_NAME = "com.jgoodies.plaf.plastic.PlasticLookAndFeel";
    private static final String NEW_PLASTIC_LAF_NAME = "com.jgoodies.looks.plastic.PlasticLookAndFeel";
    private static boolean isMac;
    private static boolean isWindows;
    private static boolean isApplet;
    private static boolean useAntialiasing;

    public static void initialize() {
    }

    public static void debugBreak() {
    }

    public static void exit() {
        try {
            System.exit(0);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static Class forName(String string) {
        return PluginUtilities.forName(string);
    }

    public static Class forName(String string, boolean bl) {
        return PluginUtilities.forName(string, bl);
    }

    public static void gc() {
        System.gc();
        System.runFinalization();
        System.gc();
    }

    public static String getSystemProperty(String string) {
        String string2;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            string2 = null;
        }
        return string2;
    }

    public static String getSystemProperty(String string, String string2) {
        String string3;
        try {
            string3 = System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            string3 = string2;
        }
        return string3;
    }

    public static String getUserDirectory() {
        return SystemUtilities.getSystemProperty("user.dir");
    }

    public static String getLineSeparator() {
        return SystemUtilities.getSystemProperty("line.separator");
    }

    public static String getMachineName() {
        String string;
        try {
            string = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = "Unknown";
        }
        return string;
    }

    public static String getMachineIpAddress() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            Log.getLogger().warning("Unable to determine ip address");
            string = "127.0.0.1";
        }
        return string;
    }

    public static String getFileEncoding() {
        return SystemUtilities.getSystemProperty("protege.file.encoding", "UTF-8");
    }

    public static String getUserName() {
        return SystemUtilities.getSystemProperty("user.name");
    }

    private static void init() {
        try {
            SystemUtilities.logSystemInfo();
            SystemUtilities.loadParameters();
            SystemUtilities.loadLookAndFeel();
            PluginUtilities.initialize();
            SystemUtilities.loadUseAntialiasing();
        }
        catch (Throwable throwable) {
            System.out.println(throwable.getMessage());
        }
    }

    private static void loadParameters() {
        String string = SystemUtilities.getSystemProperty("os.name");
        isMac = string.indexOf("Mac") != -1;
        isWindows = string.indexOf("Windows") != -1;
    }

    private static void loadLookAndFeel() {
        String string = ApplicationProperties.getLookAndFeelClassName();
        if (string.equals(OLD_PLASTIC_LAF_NAME)) {
            string = NEW_PLASTIC_LAF_NAME;
            ApplicationProperties.setLookAndFeel(string);
        }
        SystemUtilities.setLookAndFeel(string);
    }

    public static void setLookAndFeel(String string) {
        try {
            LookAndFeel lookAndFeel = (LookAndFeel)Class.forName(string).newInstance();
            if (string.indexOf("Plastic") != -1) {
                PopupFactory.setSharedInstance(new PopupFactory());
                PlasticLookAndFeel.setMyCurrentTheme((PlasticTheme)PlasticHack.createTheme());
                PlasticLookAndFeel.setTabStyle((String)"metal");
            } else if (string.indexOf("Metal") != -1) {
                MetalLookAndFeel.setCurrentTheme(SystemUtilities.createDefaultMetalTheme());
            }
            UIManager.put("ClassLoader", lookAndFeel.getClass().getClassLoader());
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.getLogger().warning("Look and feel not found: " + string);
        }
        catch (Exception exception) {
            Log.getLogger().warning(exception.toString());
        }
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isMac() {
        return isMac;
    }

    public static boolean modalDialogInDropWorks() {
        return true;
    }

    public static Object newInstance(Class clazz, Class[] classArray, Object[] objectArray) {
        Object var3_3 = null;
        try {
            Constructor constructor = clazz.getConstructor(classArray);
            var3_3 = constructor.newInstance(objectArray);
        }
        catch (Throwable throwable) {
            Log.getLogger().warning(Log.toString(throwable));
        }
        return var3_3;
    }

    public static Object newInstance(String string) {
        Object var1_1 = null;
        try {
            Class clazz = SystemUtilities.forName(string);
            if (clazz == null) {
                Log.getLogger().warning("no such class: " + string);
            } else {
                var1_1 = clazz.newInstance();
            }
        }
        catch (Throwable throwable) {
            Log.getLogger().warning(Log.toString(throwable));
        }
        return var1_1;
    }

    public static Object newInstance(Class clazz) {
        Object var1_1 = null;
        try {
            var1_1 = clazz.newInstance();
        }
        catch (Throwable throwable) {
            Log.getLogger().warning(Log.toString(throwable));
        }
        return var1_1;
    }

    public static void pause() {
        try {
            System.out.flush();
            System.err.flush();
            System.out.print("Press <Enter> to continue");
            System.in.read();
            while (System.in.available() != 0) {
                System.in.read();
            }
        }
        catch (Exception exception) {
            Log.getLogger().warning(Log.toString(exception));
        }
    }

    public static void printMemoryUsage() {
        SystemUtilities.gc();
        SystemUtilities.printMemoryUsageNoGC();
    }

    public static void printMemoryUsageNoGC() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory();
        long l2 = runtime.freeMemory();
        String string = "memory: total=" + l + ", used=" + (l - l2);
        Log.getLogger().finest(string);
    }

    public static void logSystemInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Text.getProgramTextName());
        stringBuffer.append(" ");
        stringBuffer.append(Text.getVersion());
        stringBuffer.append(" ");
        stringBuffer.append(Text.getBuildInfo());
        stringBuffer.append(", JVM ");
        stringBuffer.append(SystemUtilities.getSystemProperty("java.runtime.version"));
        stringBuffer.append(", memory=");
        stringBuffer.append(Runtime.getRuntime().maxMemory() / 1000000L);
        stringBuffer.append("M, ");
        stringBuffer.append(SystemUtilities.getSystemProperty("os.name"));
        stringBuffer.append(", encoding=");
        stringBuffer.append(SystemUtilities.getFileEncoding());
        stringBuffer.append(", language=");
        stringBuffer.append(Locale.getDefault().getLanguage());
        stringBuffer.append(", country=");
        stringBuffer.append(Locale.getDefault().getCountry());
        Log.getLogger().config(stringBuffer.toString());
    }

    public static void printSystemProperties(PrintStream printStream) {
        printStream.println("System Properties:");
        ArrayList<Map.Entry<Object, Object>> arrayList = new ArrayList<Map.Entry<Object, Object>>(System.getProperties().entrySet());
        Collections.sort(arrayList, new PropertyComparator());
        for (Map.Entry entry : arrayList) {
            String string = entry.getKey().toString();
            if (string.startsWith("lax.")) continue;
            printStream.println("\t" + string + "=" + entry.getValue());
        }
    }

    public static void showHTML(String string) {
        try {
            if (!string.startsWith("http:") && !string.startsWith("file:")) {
                string = new File(string).toURI().toURL().toString();
            }
            BrowserLauncher.openURL(string);
        }
        catch (IOException iOException) {
            Log.getLogger().warning(iOException.toString());
        }
    }

    public static void sleepMsec(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            Log.getLogger().warning(exception.toString());
        }
    }

    public static Boolean toBoolean(Object object) {
        String string;
        Boolean bl = object instanceof Boolean ? (Boolean)object : ((string = object.toString()).equalsIgnoreCase("true") ? Boolean.TRUE : (string.equalsIgnoreCase("false") ? Boolean.FALSE : null));
        return bl;
    }

    public static Float toFloat(Object object) {
        Float f;
        if (object instanceof Float) {
            f = (Float)object;
        } else {
            try {
                f = Float.valueOf(object.toString());
            }
            catch (Exception exception) {
                f = null;
            }
        }
        return f;
    }

    public static Integer toInteger(Object object) {
        Integer n;
        if (object instanceof Integer) {
            n = (Integer)object;
        } else {
            try {
                n = Integer.valueOf(object.toString());
            }
            catch (Exception exception) {
                n = null;
            }
        }
        return n;
    }

    public static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static Collection getClassesWithAttribute(String string, String string2) {
        return PluginUtilities.getClassesWithAttribute(string, string2);
    }

    public static void setContextClassLoader(Object object) {
        try {
            Thread.currentThread().setContextClassLoader(object.getClass().getClassLoader());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean showAlphaFeatures() {
        boolean bl = false;
        String string = SystemUtilities.getSystemProperty("protege.alpha");
        if (string != null) {
            bl = Boolean.valueOf(string);
        }
        return bl;
    }

    public static boolean useAntialiasing() {
        return useAntialiasing;
    }

    private static void loadUseAntialiasing() {
        String string = ApplicationProperties.getApplicationOrSystemProperty("antialiasing.enable");
        useAntialiasing = string == null ? UIManager.getLookAndFeel().getClass().getName().indexOf("Plastic") != -1 && !SystemUtilities.isMac() : Boolean.valueOf(string);
    }

    private static MetalTheme createDefaultMetalTheme() {
        MetalTheme metalTheme = SystemUtilities.isJDK15() ? (MetalTheme)SystemUtilities.newInstance("javax.swing.plaf.metal.OceanTheme") : new DefaultMetalTheme();
        return metalTheme;
    }

    private static boolean isJDK15() {
        String string = SystemUtilities.getSystemProperty("java.runtime.version");
        return string.startsWith("1.5.");
    }

    public static Locale getSystemLocale() {
        String string = System.getProperty("user.country");
        String string2 = System.getProperty("user.language");
        return new Locale(string2, string);
    }

    public static Locale getProtegeSystemDefaultLocale() {
        return new Locale(Locale.ENGLISH.getLanguage(), Locale.US.getCountry());
    }

    public static boolean isApplet() {
        return isApplet;
    }

    public static void setApplet(boolean bl) {
        isApplet = bl;
    }

    static {
        SystemUtilities.init();
    }

    private static class PropertyComparator
    implements Comparator {
        private PropertyComparator() {
        }

        public int compare(Object object, Object object2) {
            Map.Entry entry = (Map.Entry)object;
            Map.Entry entry2 = (Map.Entry)object2;
            return entry.getKey().toString().compareToIgnoreCase(entry2.getKey().toString());
        }
    }
}

