/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3.test;

import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.util.tuple.TupleItem;
import com.hp.hpl.jena.util.tuple.TupleSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.List;
import junit.framework.TestSuite;

public abstract class N3ExternalTestsCom
extends TestSuite {
    protected static final String[] dirbases = new String[]{".", "testN3", "testing/N3", "modules/rdf/regression/testN3"};
    protected String basedir = null;
    protected String testFile;

    public N3ExternalTestsCom(String string, String string2) {
        super(string);
        Object object;
        this.testFile = this.findFile(string2);
        if (this.testFile == null) {
            throw new JenaException("No such file: " + string2);
        }
        TupleSet tupleSet = null;
        try {
            object = new BufferedReader(new FileReader(this.testFile));
            tupleSet = new TupleSet((Reader)object);
        }
        catch (IOException iOException) {
            System.err.println("IO exception: " + iOException);
            return;
        }
        while (tupleSet.hasNext()) {
            object = (List)tupleSet.next();
            if (object.size() != 2) {
                System.err.println("Error in N3 test configuration file: " + string2 + ": length of an entry is " + object.size());
                return;
            }
            String string3 = ((TupleItem)object.get(0)).get();
            String string4 = ((TupleItem)object.get(1)).get();
            this.makeTest(string3, string4);
        }
    }

    protected abstract void makeTest(String var1, String var2);

    protected String findFile(String string) {
        for (int i = 0; i < dirbases.length; ++i) {
            String string2 = dirbases[i] + "/" + string;
            File file = new File(string2);
            if (!file.exists()) continue;
            this.basedir = dirbases[i];
            return file.getAbsolutePath();
        }
        return null;
    }

    protected static PrintWriter makeWriter(OutputStream outputStream) {
        return FileUtils.asPrintWriterUTF8(outputStream);
    }

    protected static BufferedReader makeReader(InputStream inputStream) {
        return new BufferedReader(FileUtils.asUTF8(inputStream));
    }
}

