/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge;

import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.swrl.bridge.Argument;
import edu.stanford.smi.protegex.owl.swrl.bridge.AtomInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.IndividualInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.LiteralInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.VariableInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLRuleEngineBridgeException;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDatavaluedPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLVariable;

public class DatavaluedPropertyAtomInfo
extends AtomInfo {
    private Argument argument1;
    private Argument argument2;

    public DatavaluedPropertyAtomInfo(OWLModel owlModel, SWRLDatavaluedPropertyAtom atom) throws SWRLRuleEngineBridgeException {
        super(atom.getPropertyPredicate().getName());
        SWRLVariable variable;
        if (atom.getArgument1() instanceof SWRLVariable) {
            variable = (SWRLVariable)atom.getArgument1();
            this.argument1 = new VariableInfo(variable);
            this.addReferencedVariableName(variable.getName());
        } else if (atom.getArgument1() instanceof OWLIndividual) {
            this.argument1 = new IndividualInfo((OWLIndividual)atom.getArgument1());
        } else {
            throw new SWRLRuleEngineBridgeException("Unexpected argument #1 to datavalued property atom '" + atom.getBrowserText() + "'. Expecting variable or individual, got instance of" + atom.getArgument1().getClass() + ".");
        }
        if (atom.getArgument2() instanceof SWRLVariable) {
            variable = (SWRLVariable)atom.getArgument2();
            this.argument2 = new VariableInfo(variable);
            this.addReferencedVariableName(variable.getName());
        } else if (atom.getArgument2() instanceof RDFSLiteral) {
            this.argument2 = new LiteralInfo(owlModel, (RDFSLiteral)atom.getArgument2());
        } else {
            throw new SWRLRuleEngineBridgeException("Unexpected argument #2 to datavalued property atom '" + atom.getBrowserText() + "'. Expecting variable or literal, got instance of" + atom.getArgument2().getClass() + ".");
        }
        if (this.argument1 instanceof IndividualInfo) {
            this.addReferencedIndividualName(this.argument1.getName());
        }
    }

    public Argument getArgument1() {
        return this.argument1;
    }

    public Argument getArgument2() {
        return this.argument2;
    }
}

