/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.ontology.impl.test.OntTestBase;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class TestProperty
extends OntTestBase {
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntResource;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntClass;

    public static TestSuite suite() {
        return new TestProperty("TestProperty");
    }

    public TestProperty(String string) {
        super(string);
    }

    public OntTestBase.OntTestCase[] getTests() {
        return new OntTestBase.OntTestCase[]{new OntTestBase.OntTestCase("OntProperty.super-property", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntProperty ontProperty = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntProperty ontProperty2 = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#q");
                OntProperty ontProperty3 = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#r");
                ontProperty.addSuperProperty(ontProperty2);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)ontProperty.getCardinality(profile.SUB_PROPERTY_OF()));
                1.assertEquals((String)"p have super-prop q", (Object)ontProperty2, (Object)ontProperty.getSuperProperty());
                ontProperty.addSuperProperty(ontProperty3);
                1.assertEquals((String)"Cardinality should be 2", (int)2, (int)ontProperty.getCardinality(profile.SUB_PROPERTY_OF()));
                this.iteratorTest(ontProperty.listSuperProperties(), new Object[]{ontProperty2, ontProperty3});
                ontProperty.setSuperProperty(ontProperty3);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)ontProperty.getCardinality(profile.SUB_PROPERTY_OF()));
                1.assertEquals((String)"p shuold have super-prop r", (Object)ontProperty3, (Object)ontProperty.getSuperProperty());
                ontProperty.removeSuperProperty(ontProperty2);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)ontProperty.getCardinality(profile.SUB_PROPERTY_OF()));
                ontProperty.removeSuperProperty(ontProperty3);
                1.assertEquals((String)"Cardinality should be 0", (int)0, (int)ontProperty.getCardinality(profile.SUB_PROPERTY_OF()));
            }
        }, new OntTestBase.OntTestCase("OntProperty.sub-property", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntProperty ontProperty = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntProperty ontProperty2 = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#q");
                OntProperty ontProperty3 = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#r");
                ontProperty.addSubProperty(ontProperty2);
                2.assertEquals((String)"Cardinality should be 1", (int)1, (int)ontProperty2.getCardinality(profile.SUB_PROPERTY_OF()));
                2.assertEquals((String)"p have sub-prop q", (Object)ontProperty2, (Object)ontProperty.getSubProperty());
                ontProperty.addSubProperty(ontProperty3);
                2.assertEquals((String)"Cardinality should be 2", (int)2, (int)(ontProperty2.getCardinality(profile.SUB_PROPERTY_OF()) + ontProperty3.getCardinality(profile.SUB_PROPERTY_OF())));
                this.iteratorTest(ontProperty.listSubProperties(), new Object[]{ontProperty2, ontProperty3});
                this.iteratorTest(ontProperty2.listSuperProperties(), new Object[]{ontProperty});
                this.iteratorTest(ontProperty3.listSuperProperties(), new Object[]{ontProperty});
                ontProperty.setSubProperty(ontProperty3);
                2.assertEquals((String)"Cardinality should be 1", (int)1, (int)(ontProperty2.getCardinality(profile.SUB_PROPERTY_OF()) + ontProperty3.getCardinality(profile.SUB_PROPERTY_OF())));
                2.assertEquals((String)"p should have sub-prop r", (Object)ontProperty3, (Object)ontProperty.getSubProperty());
                ontProperty.removeSubProperty(ontProperty2);
                2.assertTrue((String)"Should have sub-prop r", (boolean)ontProperty.hasSubProperty(ontProperty3, false));
                ontProperty.removeSubProperty(ontProperty3);
                2.assertTrue((String)"Should not have sub-prop r", (!ontProperty.hasSubProperty(ontProperty3, false) ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("OntProperty.domain", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntProperty ontProperty = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntResource ontResource = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestProperty.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource ontResource2 = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestProperty.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                ontProperty.addDomain(ontResource);
                3.assertEquals((String)"Cardinality should be 1", (int)1, (int)ontProperty.getCardinality(profile.DOMAIN()));
                3.assertEquals((String)"p have domain a", (Object)ontResource, (Object)ontProperty.getDomain());
                ontProperty.addDomain(ontResource2);
                3.assertEquals((String)"Cardinality should be 2", (int)2, (int)ontProperty.getCardinality(profile.DOMAIN()));
                this.iteratorTest(ontProperty.listDomain(), new Object[]{ontResource, ontResource2});
                ontProperty.setDomain(ontResource2);
                3.assertEquals((String)"Cardinality should be 1", (int)1, (int)ontProperty.getCardinality(profile.DOMAIN()));
                3.assertEquals((String)"p should have domain b", (Object)ontResource2, (Object)ontProperty.getDomain());
                ontProperty.removeDomain(ontResource);
                3.assertEquals((String)"Cardinality should be 1", (int)1, (int)ontProperty.getCardinality(profile.DOMAIN()));
                ontProperty.removeDomain(ontResource2);
                3.assertEquals((String)"Cardinality should be 0", (int)0, (int)ontProperty.getCardinality(profile.DOMAIN()));
            }
        }, new OntTestBase.OntTestCase("OntProperty.range", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntProperty ontProperty = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntResource ontResource = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestProperty.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource ontResource2 = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestProperty.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                ontProperty.addRange(ontResource);
                4.assertEquals((String)"Cardinality should be 1", (int)1, (int)ontProperty.getCardinality(profile.RANGE()));
                4.assertEquals((String)"p have range a", (Object)ontResource, (Object)ontProperty.getRange());
                ontProperty.addRange(ontResource2);
                4.assertEquals((String)"Cardinality should be 2", (int)2, (int)ontProperty.getCardinality(profile.RANGE()));
                this.iteratorTest(ontProperty.listRange(), new Object[]{ontResource, ontResource2});
                ontProperty.setRange(ontResource2);
                4.assertEquals((String)"Cardinality should be 1", (int)1, (int)ontProperty.getCardinality(profile.RANGE()));
                4.assertEquals((String)"p should have range b", (Object)ontResource2, (Object)ontProperty.getRange());
                ontProperty.removeRange(ontResource);
                4.assertEquals((String)"Cardinality should be 1", (int)1, (int)ontProperty.getCardinality(profile.RANGE()));
                ontProperty.removeRange(ontResource2);
                4.assertEquals((String)"Cardinality should be 0", (int)0, (int)ontProperty.getCardinality(profile.RANGE()));
            }
        }, new OntTestBase.OntTestCase("OntProperty.equivalentProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                ObjectProperty objectProperty2 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                ObjectProperty objectProperty3 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
                objectProperty.addEquivalentProperty(objectProperty2);
                5.assertEquals((String)"Cardinality should be 1", (int)1, (int)objectProperty.getCardinality(profile.EQUIVALENT_PROPERTY()));
                5.assertEquals((String)"p have equivalentProperty q", (Object)objectProperty2, (Object)objectProperty.getEquivalentProperty());
                objectProperty.addEquivalentProperty(objectProperty3);
                5.assertEquals((String)"Cardinality should be 2", (int)2, (int)objectProperty.getCardinality(profile.EQUIVALENT_PROPERTY()));
                this.iteratorTest(objectProperty.listEquivalentProperties(), new Object[]{objectProperty2, objectProperty3});
                objectProperty.setEquivalentProperty(objectProperty3);
                5.assertEquals((String)"Cardinality should be 1", (int)1, (int)objectProperty.getCardinality(profile.EQUIVALENT_PROPERTY()));
                5.assertEquals((String)"p should have equivalentProperty r", (Object)objectProperty3, (Object)objectProperty.getEquivalentProperty());
                objectProperty.removeEquivalentProperty(objectProperty2);
                5.assertEquals((String)"Cardinality should be 1", (int)1, (int)objectProperty.getCardinality(profile.EQUIVALENT_PROPERTY()));
                objectProperty.removeEquivalentProperty(objectProperty3);
                5.assertEquals((String)"Cardinality should be 0", (int)0, (int)objectProperty.getCardinality(profile.EQUIVALENT_PROPERTY()));
            }
        }, new OntTestBase.OntTestCase("OntProperty.inverseOf", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                ObjectProperty objectProperty2 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                ObjectProperty objectProperty3 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
                objectProperty.addInverseOf(objectProperty2);
                6.assertEquals((String)"Cardinality should be 1", (int)1, (int)objectProperty.getCardinality(profile.INVERSE_OF()));
                6.assertEquals((String)"p should have inverse q", (Object)objectProperty2, (Object)objectProperty.getInverseOf());
                objectProperty.addInverseOf(objectProperty3);
                6.assertEquals((String)"Cardinality should be 2", (int)2, (int)objectProperty.getCardinality(profile.INVERSE_OF()));
                this.iteratorTest(objectProperty.listInverseOf(), new Object[]{objectProperty2, objectProperty3});
                objectProperty.setInverseOf(objectProperty3);
                6.assertEquals((String)"Cardinality should be 1", (int)1, (int)objectProperty.getCardinality(profile.INVERSE_OF()));
                6.assertEquals((String)"p should have inverse r", (Object)objectProperty3, (Object)objectProperty.getInverseOf());
                objectProperty.removeInverseProperty(objectProperty2);
                6.assertEquals((String)"Cardinality should be 1", (int)1, (int)objectProperty.getCardinality(profile.INVERSE_OF()));
                objectProperty.removeInverseProperty(objectProperty3);
                6.assertEquals((String)"Cardinality should be 0", (int)0, (int)objectProperty.getCardinality(profile.INVERSE_OF()));
            }
        }, new OntTestBase.OntTestCase("OntProperty.subproperty.fromFile", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                String string = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String string2 = "file:testing/ontology/" + string + "/Property/test.rdf";
                ontModel.read(string2);
                OntProperty ontProperty = (OntProperty)ontModel.getProperty("http://jena.hpl.hp.com/testing/ontology#", "p").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                OntProperty ontProperty2 = (OntProperty)ontModel.getProperty("http://jena.hpl.hp.com/testing/ontology#", "q").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                this.iteratorTest(ontProperty.listSuperProperties(), new Object[]{ontProperty2});
                this.iteratorTest(ontProperty2.listSubProperties(), new Object[]{ontProperty});
            }
        }, new OntTestBase.OntTestCase("OntProperty.domain.fromFile", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                String string = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String string2 = "file:testing/ontology/" + string + "/Property/test.rdf";
                ontModel.read(string2);
                OntProperty ontProperty = (OntProperty)ontModel.getProperty("http://jena.hpl.hp.com/testing/ontology#", "p").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                OntClass ontClass = (OntClass)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#ClassA").as(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = TestProperty.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
                8.assertTrue((String)"p should have domain A", (boolean)ontProperty.hasDomain(ontClass));
            }
        }, new OntTestBase.OntTestCase("OntProperty.range.fromFile", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                String string = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String string2 = "file:testing/ontology/" + string + "/Property/test.rdf";
                ontModel.read(string2);
                OntProperty ontProperty = (OntProperty)ontModel.getProperty("http://jena.hpl.hp.com/testing/ontology#", "p").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                OntClass ontClass = (OntClass)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#ClassB").as(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = TestProperty.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
                9.assertTrue((String)"p should have domain B", (boolean)ontProperty.hasRange(ontClass));
            }
        }, new OntTestBase.OntTestCase("OntProperty.equivalentProeprty.fromFile", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                String string = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String string2 = "file:testing/ontology/" + string + "/Property/test.rdf";
                ontModel.read(string2);
                OntProperty ontProperty = (OntProperty)ontModel.getProperty("http://jena.hpl.hp.com/testing/ontology#", "p").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                OntProperty ontProperty2 = (OntProperty)ontModel.getProperty("http://jena.hpl.hp.com/testing/ontology#", "r").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                10.assertTrue((String)"p should have equiv prop r", (boolean)ontProperty.hasEquivalentProperty(ontProperty2));
            }
        }, new OntTestBase.OntTestCase("OntProperty.inversePropertyOf.fromFile", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                String string = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String string2 = "file:testing/ontology/" + string + "/Property/test.rdf";
                ontModel.read(string2);
                OntProperty ontProperty = (OntProperty)ontModel.getProperty("http://jena.hpl.hp.com/testing/ontology#", "p").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                OntProperty ontProperty2 = (OntProperty)ontModel.getProperty("http://jena.hpl.hp.com/testing/ontology#", "s").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                11.assertTrue((String)"p should have inv prop s", (boolean)ontProperty.isInverseOf(ontProperty2));
            }
        }, new OntTestBase.OntTestCase("OntProperty.isFunctionalProperty dt", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                DatatypeProperty datatypeProperty = ontModel.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
                12.assertTrue((String)"isFunctionalProperty not correct", (boolean)datatypeProperty.isFunctionalProperty());
                12.assertTrue((String)"isDatatypeProperty not correct", (boolean)datatypeProperty.isDatatypeProperty());
                12.assertTrue((String)"isObjectProperty not correct", (!datatypeProperty.isObjectProperty() ? 1 : 0) != 0);
                12.assertTrue((String)"isTransitiveProperty not correct", (!datatypeProperty.isTransitiveProperty() ? 1 : 0) != 0);
                12.assertTrue((String)"isInverseFunctionalProperty not correct", (!datatypeProperty.isInverseFunctionalProperty() ? 1 : 0) != 0);
                if (this.m_owlLang) {
                    12.assertTrue((String)"isSymmetricProperty not correct", (!datatypeProperty.isSymmetricProperty() ? 1 : 0) != 0);
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isFunctionalProperty object", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
                13.assertTrue((String)"isFunctionalProperty not correct", (boolean)objectProperty.isFunctionalProperty());
                13.assertTrue((String)"isDatatypeProperty not correct", (!objectProperty.isDatatypeProperty() ? 1 : 0) != 0);
                13.assertTrue((String)"isObjectProperty not correct", (boolean)objectProperty.isObjectProperty());
                13.assertTrue((String)"isTransitiveProperty not correct", (!objectProperty.isTransitiveProperty() ? 1 : 0) != 0);
                13.assertTrue((String)"isInverseFunctionalProperty not correct", (!objectProperty.isInverseFunctionalProperty() ? 1 : 0) != 0);
                if (this.m_owlLang) {
                    13.assertTrue((String)"isSymmetricProperty not correct", (!objectProperty.isSymmetricProperty() ? 1 : 0) != 0);
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isDatatypeProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                DatatypeProperty datatypeProperty = ontModel.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
                14.assertTrue((String)"isFunctionalProperty not correct", (!datatypeProperty.isFunctionalProperty() ? 1 : 0) != 0);
                14.assertTrue((String)"isDatatypeProperty not correct", (boolean)datatypeProperty.isDatatypeProperty());
                14.assertTrue((String)"isObjectProperty not correct", (!datatypeProperty.isObjectProperty() ? 1 : 0) != 0);
                14.assertTrue((String)"isTransitiveProperty not correct", (!datatypeProperty.isTransitiveProperty() ? 1 : 0) != 0);
                14.assertTrue((String)"isInverseFunctionalProperty not correct", (!datatypeProperty.isInverseFunctionalProperty() ? 1 : 0) != 0);
                if (this.m_owlLang) {
                    14.assertTrue((String)"isSymmetricProperty not correct", (!datatypeProperty.isSymmetricProperty() ? 1 : 0) != 0);
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isObjectProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
                15.assertTrue((String)"isFunctionalProperty not correct", (!objectProperty.isFunctionalProperty() ? 1 : 0) != 0);
                15.assertTrue((String)"isDatatypeProperty not correct", (!objectProperty.isDatatypeProperty() ? 1 : 0) != 0);
                15.assertTrue((String)"isObjectProperty not correct", (boolean)objectProperty.isObjectProperty());
                15.assertTrue((String)"isTransitiveProperty not correct", (!objectProperty.isTransitiveProperty() ? 1 : 0) != 0);
                15.assertTrue((String)"isInverseFunctionalProperty not correct", (!objectProperty.isInverseFunctionalProperty() ? 1 : 0) != 0);
                if (this.m_owlLang) {
                    15.assertTrue((String)"isSymmetricProperty not correct", (!objectProperty.isSymmetricProperty() ? 1 : 0) != 0);
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isTransitiveProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                TransitiveProperty transitiveProperty = ontModel.createTransitiveProperty("http://jena.hpl.hp.com/testing/ontology#p");
                16.assertTrue((String)"isFunctionalProperty not correct", (!transitiveProperty.isFunctionalProperty() ? 1 : 0) != 0);
                16.assertTrue((String)"isDatatypeProperty not correct", (!transitiveProperty.isDatatypeProperty() ? 1 : 0) != 0);
                16.assertTrue((String)"isObjectProperty not correct", (!transitiveProperty.isObjectProperty() ? 1 : 0) != 0);
                16.assertTrue((String)"isTransitiveProperty not correct", (boolean)transitiveProperty.isTransitiveProperty());
                16.assertTrue((String)"isInverseFunctionalProperty not correct", (!transitiveProperty.isInverseFunctionalProperty() ? 1 : 0) != 0);
                if (this.m_owlLang) {
                    16.assertTrue((String)"isSymmetricProperty not correct", (!transitiveProperty.isSymmetricProperty() ? 1 : 0) != 0);
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isInverseFunctionalProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                InverseFunctionalProperty inverseFunctionalProperty = ontModel.createInverseFunctionalProperty("http://jena.hpl.hp.com/testing/ontology#p");
                17.assertTrue((String)"isFunctionalProperty not correct", (!inverseFunctionalProperty.isFunctionalProperty() ? 1 : 0) != 0);
                17.assertTrue((String)"isDatatypeProperty not correct", (!inverseFunctionalProperty.isDatatypeProperty() ? 1 : 0) != 0);
                17.assertTrue((String)"isObjectProperty not correct", (!inverseFunctionalProperty.isObjectProperty() ? 1 : 0) != 0);
                17.assertTrue((String)"isTransitiveProperty not correct", (!inverseFunctionalProperty.isTransitiveProperty() ? 1 : 0) != 0);
                17.assertTrue((String)"isInverseFunctionalProperty not correct", (boolean)inverseFunctionalProperty.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    17.assertTrue((String)"isSymmetricProperty not correct", (!inverseFunctionalProperty.isSymmetricProperty() ? 1 : 0) != 0);
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isSymmetricProperty", true, true, false, false){

            public void ontTest(OntModel ontModel) throws Exception {
                SymmetricProperty symmetricProperty = ontModel.createSymmetricProperty("http://jena.hpl.hp.com/testing/ontology#p");
                18.assertTrue((String)"isFunctionalProperty not correct", (!symmetricProperty.isFunctionalProperty() ? 1 : 0) != 0);
                18.assertTrue((String)"isDatatypeProperty not correct", (!symmetricProperty.isDatatypeProperty() ? 1 : 0) != 0);
                18.assertTrue((String)"isObjectProperty not correct", (!symmetricProperty.isObjectProperty() ? 1 : 0) != 0);
                18.assertTrue((String)"isTransitiveProperty not correct", (!symmetricProperty.isTransitiveProperty() ? 1 : 0) != 0);
                18.assertTrue((String)"isInverseFunctionalProperty not correct", (!symmetricProperty.isInverseFunctionalProperty() ? 1 : 0) != 0);
                if (this.m_owlLang) {
                    18.assertTrue((String)"isSymmetricProperty not correct", (boolean)symmetricProperty.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToFunctionalProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Property property = ontModel.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                property.addProperty(RDF.type, RDF.Property);
                OntProperty ontProperty = (OntProperty)property.as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                19.assertTrue((String)"isFunctionalProperty not correct", (!ontProperty.isFunctionalProperty() ? 1 : 0) != 0);
                19.assertTrue((String)"isDatatypeProperty not correct", (!ontProperty.isDatatypeProperty() ? 1 : 0) != 0);
                19.assertTrue((String)"isObjectProperty not correct", (!ontProperty.isObjectProperty() ? 1 : 0) != 0);
                19.assertTrue((String)"isTransitiveProperty not correct", (!ontProperty.isTransitiveProperty() ? 1 : 0) != 0);
                19.assertTrue((String)"isInverseFunctionalProperty not correct", (!ontProperty.isInverseFunctionalProperty() ? 1 : 0) != 0);
                if (this.m_owlLang) {
                    19.assertTrue((String)"isSymmetricProperty not correct", (!ontProperty.isSymmetricProperty() ? 1 : 0) != 0);
                }
                ontProperty = ontProperty.convertToFunctionalProperty();
                19.assertTrue((String)"isFunctionalProperty not correct", (boolean)ontProperty.isFunctionalProperty());
                19.assertTrue((String)"isDatatypeProperty not correct", (!ontProperty.isDatatypeProperty() ? 1 : 0) != 0);
                19.assertTrue((String)"isObjectProperty not correct", (!ontProperty.isObjectProperty() ? 1 : 0) != 0);
                19.assertTrue((String)"isTransitiveProperty not correct", (!ontProperty.isTransitiveProperty() ? 1 : 0) != 0);
                19.assertTrue((String)"isInverseFunctionalProperty not correct", (!ontProperty.isInverseFunctionalProperty() ? 1 : 0) != 0);
                if (this.m_owlLang) {
                    19.assertTrue((String)"isSymmetricProperty not correct", (!ontProperty.isSymmetricProperty() ? 1 : 0) != 0);
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToDatatypeProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Property property = ontModel.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                property.addProperty(RDF.type, RDF.Property);
                OntProperty ontProperty = (OntProperty)property.as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                20.assertTrue((String)"isFunctionalProperty not correct", (!ontProperty.isFunctionalProperty() ? 1 : 0) != 0);
                20.assertTrue((String)"isDatatypeProperty not correct", (!ontProperty.isDatatypeProperty() ? 1 : 0) != 0);
                20.assertTrue((String)"isObjectProperty not correct", (!ontProperty.isObjectProperty() ? 1 : 0) != 0);
                20.assertTrue((String)"isTransitiveProperty not correct", (!ontProperty.isTransitiveProperty() ? 1 : 0) != 0);
                20.assertTrue((String)"isInverseFunctionalProperty not correct", (!ontProperty.isInverseFunctionalProperty() ? 1 : 0) != 0);
                if (this.m_owlLang) {
                    20.assertTrue((String)"isSymmetricProperty not correct", (!ontProperty.isSymmetricProperty() ? 1 : 0) != 0);
                }
                20.assertTrue((String)"isFunctionalProperty not correct", (!(ontProperty = ontProperty.convertToDatatypeProperty()).isFunctionalProperty() ? 1 : 0) != 0);
                20.assertTrue((String)"isDatatypeProperty not correct", (boolean)ontProperty.isDatatypeProperty());
                20.assertTrue((String)"isObjectProperty not correct", (!ontProperty.isObjectProperty() ? 1 : 0) != 0);
                20.assertTrue((String)"isTransitiveProperty not correct", (!ontProperty.isTransitiveProperty() ? 1 : 0) != 0);
                20.assertTrue((String)"isInverseFunctionalProperty not correct", (!ontProperty.isInverseFunctionalProperty() ? 1 : 0) != 0);
                if (this.m_owlLang) {
                    20.assertTrue((String)"isSymmetricProperty not correct", (!ontProperty.isSymmetricProperty() ? 1 : 0) != 0);
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToObjectProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Property property = ontModel.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                property.addProperty(RDF.type, RDF.Property);
                OntProperty ontProperty = (OntProperty)property.as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                21.assertTrue((String)"isFunctionalProperty not correct", (!ontProperty.isFunctionalProperty() ? 1 : 0) != 0);
                21.assertTrue((String)"isDatatypeProperty not correct", (!ontProperty.isDatatypeProperty() ? 1 : 0) != 0);
                21.assertTrue((String)"isObjectProperty not correct", (!ontProperty.isObjectProperty() ? 1 : 0) != 0);
                21.assertTrue((String)"isTransitiveProperty not correct", (!ontProperty.isTransitiveProperty() ? 1 : 0) != 0);
                21.assertTrue((String)"isInverseFunctionalProperty not correct", (!ontProperty.isInverseFunctionalProperty() ? 1 : 0) != 0);
                if (this.m_owlLang) {
                    21.assertTrue((String)"isSymmetricProperty not correct", (!ontProperty.isSymmetricProperty() ? 1 : 0) != 0);
                }
                21.assertTrue((String)"isFunctionalProperty not correct", (!(ontProperty = ontProperty.convertToObjectProperty()).isFunctionalProperty() ? 1 : 0) != 0);
                21.assertTrue((String)"isDatatypeProperty not correct", (!ontProperty.isDatatypeProperty() ? 1 : 0) != 0);
                21.assertTrue((String)"isObjectProperty not correct", (boolean)ontProperty.isObjectProperty());
                21.assertTrue((String)"isTransitiveProperty not correct", (!ontProperty.isTransitiveProperty() ? 1 : 0) != 0);
                21.assertTrue((String)"isInverseFunctionalProperty not correct", (!ontProperty.isInverseFunctionalProperty() ? 1 : 0) != 0);
                if (this.m_owlLang) {
                    21.assertTrue((String)"isSymmetricProperty not correct", (!ontProperty.isSymmetricProperty() ? 1 : 0) != 0);
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToTransitiveProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Property property = ontModel.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                property.addProperty(RDF.type, RDF.Property);
                OntProperty ontProperty = (OntProperty)property.as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                22.assertTrue((String)"isFunctionalProperty not correct", (!ontProperty.isFunctionalProperty() ? 1 : 0) != 0);
                22.assertTrue((String)"isDatatypeProperty not correct", (!ontProperty.isDatatypeProperty() ? 1 : 0) != 0);
                22.assertTrue((String)"isObjectProperty not correct", (!ontProperty.isObjectProperty() ? 1 : 0) != 0);
                22.assertTrue((String)"isTransitiveProperty not correct", (!ontProperty.isTransitiveProperty() ? 1 : 0) != 0);
                22.assertTrue((String)"isInverseFunctionalProperty not correct", (!ontProperty.isInverseFunctionalProperty() ? 1 : 0) != 0);
                if (this.m_owlLang) {
                    22.assertTrue((String)"isSymmetricProperty not correct", (!ontProperty.isSymmetricProperty() ? 1 : 0) != 0);
                }
                22.assertTrue((String)"isFunctionalProperty not correct", (!(ontProperty = ontProperty.convertToTransitiveProperty()).isFunctionalProperty() ? 1 : 0) != 0);
                22.assertTrue((String)"isDatatypeProperty not correct", (!ontProperty.isDatatypeProperty() ? 1 : 0) != 0);
                22.assertTrue((String)"isObjectProperty not correct", (!ontProperty.isObjectProperty() ? 1 : 0) != 0);
                22.assertTrue((String)"isTransitiveProperty not correct", (boolean)ontProperty.isTransitiveProperty());
                22.assertTrue((String)"isInverseFunctionalProperty not correct", (!ontProperty.isInverseFunctionalProperty() ? 1 : 0) != 0);
                if (this.m_owlLang) {
                    22.assertTrue((String)"isSymmetricProperty not correct", (!ontProperty.isSymmetricProperty() ? 1 : 0) != 0);
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToInverseFunctionalProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Property property = ontModel.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                property.addProperty(RDF.type, RDF.Property);
                OntProperty ontProperty = (OntProperty)property.as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                23.assertTrue((String)"isFunctionalProperty not correct", (!ontProperty.isFunctionalProperty() ? 1 : 0) != 0);
                23.assertTrue((String)"isDatatypeProperty not correct", (!ontProperty.isDatatypeProperty() ? 1 : 0) != 0);
                23.assertTrue((String)"isObjectProperty not correct", (!ontProperty.isObjectProperty() ? 1 : 0) != 0);
                23.assertTrue((String)"isTransitiveProperty not correct", (!ontProperty.isTransitiveProperty() ? 1 : 0) != 0);
                23.assertTrue((String)"isInverseFunctionalProperty not correct", (!ontProperty.isInverseFunctionalProperty() ? 1 : 0) != 0);
                if (this.m_owlLang) {
                    23.assertTrue((String)"isSymmetricProperty not correct", (!ontProperty.isSymmetricProperty() ? 1 : 0) != 0);
                }
                23.assertTrue((String)"isFunctionalProperty not correct", (!(ontProperty = ontProperty.convertToInverseFunctionalProperty()).isFunctionalProperty() ? 1 : 0) != 0);
                23.assertTrue((String)"isDatatypeProperty not correct", (!ontProperty.isDatatypeProperty() ? 1 : 0) != 0);
                23.assertTrue((String)"isObjectProperty not correct", (!ontProperty.isObjectProperty() ? 1 : 0) != 0);
                23.assertTrue((String)"isTransitiveProperty not correct", (!ontProperty.isTransitiveProperty() ? 1 : 0) != 0);
                23.assertTrue((String)"isInverseFunctionalProperty not correct", (boolean)ontProperty.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    23.assertTrue((String)"isSymmetricProperty not correct", (!ontProperty.isSymmetricProperty() ? 1 : 0) != 0);
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToSymmetricProperty", true, true, false, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Property property = ontModel.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                property.addProperty(RDF.type, RDF.Property);
                OntProperty ontProperty = (OntProperty)property.as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                24.assertTrue((String)"isFunctionalProperty not correct", (!ontProperty.isFunctionalProperty() ? 1 : 0) != 0);
                24.assertTrue((String)"isDatatypeProperty not correct", (!ontProperty.isDatatypeProperty() ? 1 : 0) != 0);
                24.assertTrue((String)"isObjectProperty not correct", (!ontProperty.isObjectProperty() ? 1 : 0) != 0);
                24.assertTrue((String)"isTransitiveProperty not correct", (!ontProperty.isTransitiveProperty() ? 1 : 0) != 0);
                24.assertTrue((String)"isInverseFunctionalProperty not correct", (!ontProperty.isInverseFunctionalProperty() ? 1 : 0) != 0);
                if (this.m_owlLang) {
                    24.assertTrue((String)"isSymmetricProperty not correct", (!ontProperty.isSymmetricProperty() ? 1 : 0) != 0);
                }
                24.assertTrue((String)"isFunctionalProperty not correct", (!(ontProperty = ontProperty.convertToSymmetricProperty()).isFunctionalProperty() ? 1 : 0) != 0);
                24.assertTrue((String)"isDatatypeProperty not correct", (!ontProperty.isDatatypeProperty() ? 1 : 0) != 0);
                24.assertTrue((String)"isObjectProperty not correct", (!ontProperty.isObjectProperty() ? 1 : 0) != 0);
                24.assertTrue((String)"isTransitiveProperty not correct", (!ontProperty.isTransitiveProperty() ? 1 : 0) != 0);
                24.assertTrue((String)"isInverseFunctionalProperty not correct", (!ontProperty.isInverseFunctionalProperty() ? 1 : 0) != 0);
                if (this.m_owlLang) {
                    24.assertTrue((String)"isSymmetricProperty not correct", (boolean)ontProperty.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.inverse", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                ObjectProperty objectProperty2 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                ObjectProperty objectProperty3 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
                25.assertFalse((String)"No inverse of p", (boolean)objectProperty.hasInverse());
                objectProperty2.addInverseOf(objectProperty);
                25.assertTrue((String)"Inverse of p", (boolean)objectProperty.hasInverse());
                25.assertEquals((String)"inverse of p ", (Object)objectProperty2, (Object)objectProperty.getInverse());
                objectProperty3.addInverseOf(objectProperty);
                this.iteratorTest(objectProperty.listInverse(), new Object[]{objectProperty2, objectProperty3});
            }
        }};
    }
}

