/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.HashUtils;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Sft
implements Externalizable,
Localizable {
    private Slot _slot;
    private Facet _facet;
    private boolean _isTemplate;
    private int _hashCode;

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this._slot);
        objectOutput.writeObject(this._facet);
        objectOutput.writeBoolean(this._isTemplate);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this._slot = (Slot)objectInput.readObject();
        this._facet = (Facet)objectInput.readObject();
        this._isTemplate = objectInput.readBoolean();
        this.cacheHashCode();
    }

    public String toString() {
        return "Sft(" + this._slot + ", " + this._facet + ", " + this._isTemplate + ")";
    }

    public Sft(Slot slot, Facet facet, boolean bl) {
        this.set(slot, facet, bl);
    }

    public Sft() {
    }

    public Slot getSlot() {
        return this._slot;
    }

    public Facet getFacet() {
        return this._facet;
    }

    public boolean isOwnSlot() {
        return this._facet == null && !this._isTemplate;
    }

    public boolean isTemplateSlot() {
        return this._facet == null && this._isTemplate;
    }

    public boolean isTemplateFacet() {
        return this._facet != null && this._isTemplate;
    }

    public void set(Slot slot, Facet facet, boolean bl) {
        this._slot = slot;
        this._facet = facet;
        this._isTemplate = bl;
        this.cacheHashCode();
    }

    private void cacheHashCode() {
        this._hashCode = HashUtils.getHash((Object)this._slot, (Object)this._facet, this._isTemplate);
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Sft) {
            Sft sft = (Sft)object;
            if (this._hashCode == sft._hashCode) {
                bl = Sft.equals(this._slot, sft._slot) && Sft.equals(this._facet, sft._facet) && this._isTemplate == sft._isTemplate;
            } else {
                Log.getLogger().warning("equal hashs but different sfts");
            }
        }
        return bl;
    }

    public static boolean equals(Object object, Object object2) {
        return SystemUtilities.equals(object, object2);
    }

    public void localize(KnowledgeBase knowledgeBase) {
        LocalizeUtils.localize(this._slot, knowledgeBase);
        LocalizeUtils.localize(this._facet, knowledgeBase);
    }
}

