/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.server.ClientRmiSocketFactory;
import edu.stanford.smi.protege.server.RemoteClientProject;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteServerProject;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerPanel;
import edu.stanford.smi.protege.server.ServerProjectPanel;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.IOException;
import java.rmi.Naming;
import java.rmi.server.RMISocketFactory;
import javax.swing.JComponent;

public class RemoteProjectManager {
    private static RemoteProjectManager _theInstance;

    public static RemoteProjectManager getInstance() {
        if (_theInstance == null) {
            try {
                RMISocketFactory.setSocketFactory(new ClientRmiSocketFactory());
            }
            catch (IOException iOException) {
                Log.getLogger().severe(Log.toString(iOException));
            }
            _theInstance = new RemoteProjectManager();
        }
        return _theInstance;
    }

    public Project getRemoteProject() {
        JComponent jComponent = ProjectManager.getProjectManager().getMainPanel();
        Project project = null;
        RemoteServer remoteServer = null;
        RemoteSession remoteSession = null;
        ServerPanel serverPanel = new ServerPanel();
        String string = LocalizedText.getText(ResourceKey.REMOTE_HOST_CONNECT_DIALOG_TITLE);
        int n = ModalDialog.showDialog(jComponent, serverPanel, string, 11);
        if (n == 1) {
            remoteServer = serverPanel.getServer();
            remoteSession = serverPanel.getSession();
            if (remoteServer != null && remoteSession != null) {
                project = this.getServerProject(jComponent, remoteServer, remoteSession);
            }
        }
        return project;
    }

    public Project getServerProject(JComponent jComponent, RemoteServer remoteServer, RemoteSession remoteSession) {
        String string;
        Project project = null;
        ServerProjectPanel serverProjectPanel = new ServerProjectPanel(remoteServer, remoteSession);
        String string2 = LocalizedText.getText(ResourceKey.REMOTE_PROJECT_SELECT_DIALOG_TITLE);
        int n = ModalDialog.showDialog(jComponent, serverProjectPanel, string2, 11);
        if (n == 1 && (string = serverProjectPanel.getProjectName()) != null) {
            project = this.connectToProject(remoteServer, remoteSession, string);
        }
        return project;
    }

    public Project getProject(String string, String string2, String string3, String string4, boolean bl) {
        Project project = null;
        try {
            RemoteServerProject remoteServerProject;
            RemoteSession remoteSession;
            RemoteServer remoteServer = (RemoteServer)Naming.lookup("//" + string + "/" + Server.getBoundName());
            if (remoteServer != null && (remoteSession = remoteServer.openSession(string2, SystemUtilities.getMachineIpAddress(), string3)) != null && (remoteServerProject = remoteServer.openProject(string4, remoteSession)) != null) {
                project = RemoteClientProject.createProject(remoteServerProject, remoteSession, bl);
            }
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
        }
        return project;
    }

    private Project connectToProject(RemoteServer remoteServer, RemoteSession remoteSession, String string) {
        Project project = null;
        try {
            RemoteServerProject remoteServerProject = remoteServer.openProject(string, remoteSession);
            project = RemoteClientProject.createProject(remoteServerProject, remoteSession, true);
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
        }
        return project;
    }
}

