/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.util.ArrayList;

class Statistics {
    public int nFrames;
    public int nSystemFrames;
    public int nIncludedFrames;
    public int nDirectFrames;
    public int nClses;
    public int nSystemClses;
    public int nIncludedClses;
    public int nDirectClses;
    public int nSlots;
    public int nSystemSlots;
    public int nIncludedSlots;
    public int nDirectSlots;
    public int nFacets;
    public int nSystemFacets;
    public int nIncludedFacets;
    public int nDirectFacets;
    public int nInstances;
    public int nSystemInstances;
    public int nIncludedInstances;
    public int nDirectInstances;

    Statistics(KnowledgeBase knowledgeBase) {
        for (Frame frame : new ArrayList<Frame>(knowledgeBase.getFrames())) {
            this.updateFrameStatistics(frame);
            if (frame instanceof Cls) {
                this.updateClsStatistics((Cls)frame);
                continue;
            }
            if (frame instanceof Slot) {
                this.updateSlotStatistics((Slot)frame);
                continue;
            }
            if (frame instanceof Facet) {
                this.updateFacetStatistics((Facet)frame);
                continue;
            }
            this.updateInstanceStatistics((Instance)frame);
        }
    }

    private void updateClsStatistics(Cls cls) {
        ++this.nClses;
        if (cls.isSystem()) {
            ++this.nSystemClses;
        } else if (cls.isIncluded()) {
            ++this.nIncludedClses;
        } else {
            ++this.nDirectClses;
        }
    }

    public static boolean equals(Object object, Object object2) {
        return SystemUtilities.equals(object, object2);
    }

    private void updateFacetStatistics(Facet facet) {
        ++this.nFacets;
        if (facet.isSystem()) {
            ++this.nSystemFacets;
        } else if (facet.isIncluded()) {
            ++this.nIncludedFacets;
        } else {
            ++this.nDirectFacets;
        }
    }

    private void updateFrameStatistics(Frame frame) {
        ++this.nFrames;
        if (frame.isSystem()) {
            ++this.nSystemFrames;
        } else if (frame.isIncluded()) {
            ++this.nIncludedFrames;
        } else {
            ++this.nDirectFrames;
        }
    }

    private void updateInstanceStatistics(Instance instance) {
        ++this.nInstances;
        if (instance.isSystem()) {
            ++this.nSystemInstances;
        } else if (instance.isIncluded()) {
            ++this.nIncludedInstances;
        } else {
            ++this.nDirectInstances;
        }
    }

    private void updateSlotStatistics(Slot slot) {
        ++this.nSlots;
        if (slot.isSystem()) {
            ++this.nSystemSlots;
        } else if (slot.isIncluded()) {
            ++this.nIncludedSlots;
        } else {
            ++this.nDirectSlots;
        }
    }
}

