/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.junit;

import com.hp.hpl.jena.query.junit.QueryTestException;
import com.hp.hpl.jena.query.junit.TestItem;
import com.hp.hpl.jena.query.junit.TestUtils;
import com.hp.hpl.jena.query.vocabulary.TestManifest;
import com.hp.hpl.jena.query.vocabulary.TestManifestX;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestSuite;
import org.apache.commons.logging.LogFactory;

class TestManifestList {
    Model manifest = null;
    List testEntries;
    List includedFiles;
    String name = null;
    static /* synthetic */ Class class$com$hp$hpl$jena$query$junit$TestManifestList;

    public TestManifestList(String string) {
        this.manifest = FileManager.get().loadModel(string);
        this.parseManifestModel();
    }

    public TestManifestList(Model model) {
        this.manifest = model;
        this.parseManifestModel();
    }

    public Model getModel() {
        return this.manifest;
    }

    public Iterator iterator() {
        return this.testEntries.iterator();
    }

    public Iterator includedManifests() {
        return this.includedFiles.iterator();
    }

    private void parseManifestModel() {
        Resource resource;
        Statement statement;
        this.testEntries = new ArrayList();
        this.includedFiles = new ArrayList();
        StmtIterator stmtIterator = this.manifest.listStatements(null, TestManifestX.include, (RDFNode)null);
        while (stmtIterator.hasNext()) {
            statement = stmtIterator.nextStatement();
            if (!(statement.getObject() instanceof Resource)) {
                LogFactory.getLog((Class)(class$com$hp$hpl$jena$query$junit$TestManifestList == null ? TestManifestList.class$("com.hp.hpl.jena.query.junit.TestManifestList") : class$com$hp$hpl$jena$query$junit$TestManifestList)).warn((Object)("Include: not a Resource" + statement));
                continue;
            }
            resource = statement.getResource();
            this.parseIncludes(resource);
        }
        stmtIterator.close();
        statement = this.manifest.listStatements(null, RDF.type, (RDFNode)TestManifest.Manifest);
        while (statement.hasNext()) {
            String string;
            resource = statement.nextStatement();
            Resource resource2 = resource.getSubject();
            String string2 = TestUtils.getLiteral(resource2, RDFS.label);
            if (string2 != null) {
                this.name = string2;
            }
            if (!((string = TestUtils.getQuerySyntax(resource2)) == null || string.equals("http://jena.hpl.hp.com/2003/07/query/RDQL") || string.equals("http://jena.hpl.hp.com/2003/07/query/ARQ") || string.equals("http://jena.hpl.hp.com/2003/07/query/SPARQL") || string.equals("http://jena.hpl.hp.com/2003/07/query/SPARQL-alt"))) {
                throw new QueryTestException("Unknown syntax: " + string);
            }
            Resource resource3 = TestUtils.getResource(resource2, TestManifestX.defaultTestType);
            StmtIterator stmtIterator2 = resource2.listProperties(TestManifest.entries);
            while (stmtIterator2.hasNext()) {
                Resource resource4 = stmtIterator2.nextStatement().getResource();
                while (!resource4.equals(RDF.nil)) {
                    Resource resource5 = resource4.getRequiredProperty(RDF.first).getResource();
                    TestItem testItem = new TestItem(resource5, resource3, string, "RDF/XML");
                    this.testEntries.add(testItem);
                    resource4 = resource4.getRequiredProperty(RDF.rest).getResource();
                }
            }
            stmtIterator2.close();
        }
        statement.close();
    }

    private void parseIncludes(Resource resource) {
        if (!resource.isAnon()) {
            this.includedFiles.add(resource.getURI());
            return;
        }
        Resource resource2 = resource;
        while (!resource2.equals(RDF.nil)) {
            resource = resource2.getRequiredProperty(RDF.first).getResource();
            this.parseIncludes(resource);
            resource2 = resource2.getRequiredProperty(RDF.rest).getResource();
        }
    }

    public void apply(ActionProc actionProc) {
        TestSuite testSuite = new TestSuite();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            TestItem testItem = (TestItem)iterator.next();
            actionProc.map1(testItem);
        }
    }

    public static interface ActionProc {
        public void map1(TestItem var1);
    }
}

