/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.parser.sparql;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementConstraints;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementUnion;
import com.hp.hpl.jena.query.core.Template;
import com.hp.hpl.jena.query.core.TemplateGroup;
import com.hp.hpl.jena.query.core.TripleCollector;
import com.hp.hpl.jena.query.expr.E_Add;
import com.hp.hpl.jena.query.expr.E_Bound;
import com.hp.hpl.jena.query.expr.E_Datatype;
import com.hp.hpl.jena.query.expr.E_Divide;
import com.hp.hpl.jena.query.expr.E_Equal;
import com.hp.hpl.jena.query.expr.E_Function;
import com.hp.hpl.jena.query.expr.E_GreaterThan;
import com.hp.hpl.jena.query.expr.E_GreaterThanOrEqual;
import com.hp.hpl.jena.query.expr.E_IsBlank;
import com.hp.hpl.jena.query.expr.E_IsLiteral;
import com.hp.hpl.jena.query.expr.E_IsURI;
import com.hp.hpl.jena.query.expr.E_Lang;
import com.hp.hpl.jena.query.expr.E_LessThan;
import com.hp.hpl.jena.query.expr.E_LessThanOrEqual;
import com.hp.hpl.jena.query.expr.E_LogicalAnd;
import com.hp.hpl.jena.query.expr.E_LogicalNot;
import com.hp.hpl.jena.query.expr.E_LogicalOr;
import com.hp.hpl.jena.query.expr.E_Multiply;
import com.hp.hpl.jena.query.expr.E_NotEqual;
import com.hp.hpl.jena.query.expr.E_Regex;
import com.hp.hpl.jena.query.expr.E_Str;
import com.hp.hpl.jena.query.expr.E_Subtract;
import com.hp.hpl.jena.query.expr.E_UnaryMinus;
import com.hp.hpl.jena.query.expr.E_UnaryPlus;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.NodeVar;
import com.hp.hpl.jena.query.parser.sparql.JavaCharStream;
import com.hp.hpl.jena.query.parser.sparql.ParseException;
import com.hp.hpl.jena.query.parser.sparql.SPARQLParserBase;
import com.hp.hpl.jena.query.parser.sparql.SPARQLParserConstants;
import com.hp.hpl.jena.query.parser.sparql.SPARQLParserTokenManager;
import com.hp.hpl.jena.query.parser.sparql.Token;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class SPARQLParser
extends SPARQLParserBase
implements SPARQLParserConstants {
    public SPARQLParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[68];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[10];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public final void CompilationUnit() throws ParseException {
        this.Query();
        this.jj_consume_token(0);
    }

    public final void Query() throws ParseException {
        this.Prolog();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                this.SelectClause();
                break;
            }
            case 32: {
                this.ConstructClause();
                break;
            }
            case 31: {
                this.DescribeClause();
                break;
            }
            case 33: {
                this.AskClause();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.DatasetClause();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: 
            case 60: {
                this.WhereClause();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: {
                this.OrderClause();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                this.LimitClause();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: {
                this.OffsetClause();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
    }

    public final void Prolog() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                this.BaseDecl();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 28: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block6;
                }
            }
            this.PrefixDecl();
        }
    }

    public final void BaseDecl() throws ParseException {
        this.jj_consume_token(27);
        Node node = this.QuotedURIref();
        this.getQuery().setBaseURI(node.getURI());
    }

    public final void PrefixDecl() throws ParseException {
        this.jj_consume_token(28);
        Token token = this.jj_consume_token(8);
        Node node = this.QuotedURIref();
        this.getQuery().setPrefix(this.fixupPrefix(token), node.getURI());
    }

    public final void SelectClause() throws ParseException {
        Token token = null;
        if (this.jj_2_1(3)) {
            this.jj_consume_token(29);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    token = this.jj_consume_token(30);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                }
            }
            this.getQuery().setQueryResultStar(false);
            block12: while (true) {
                Node node = this.Var();
                this.getQuery().addResultVar(node);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: 
                    case 12: {
                        continue block12;
                    }
                }
                break;
            }
            this.jj_la1[8] = this.jj_gen;
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    this.jj_consume_token(29);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 30: {
                            token = this.jj_consume_token(30);
                            break;
                        }
                        default: {
                            this.jj_la1[9] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(80);
                    this.getQuery().setQueryResultStar(true);
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        this.getQuery().setType(111);
        this.getQuery().setDistinct(token != null);
    }

    public final void DescribeClause() throws ParseException {
        this.getQuery().setType(333);
        if (this.jj_2_2(2)) {
            this.jj_consume_token(31);
            block6: while (true) {
                Node node = this.VarOrURI();
                this.getQuery().addDescribeNode(node);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: 
                    case 8: 
                    case 9: 
                    case 11: 
                    case 12: {
                        continue block6;
                    }
                }
                break;
            }
            this.jj_la1[11] = this.jj_gen;
            this.getQuery().setQueryResultStar(false);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 31: {
                    this.jj_consume_token(31);
                    this.jj_consume_token(80);
                    this.getQuery().setQueryResultStar(true);
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void ConstructClause() throws ParseException {
        this.getQuery().setType(222);
        this.jj_consume_token(32);
        Template template = this.ConstructTemplate();
        this.getQuery().setQueryResultStar(false);
        this.getQuery().setConstructTemplate(template);
    }

    public final void AskClause() throws ParseException {
        this.jj_consume_token(33);
        this.getQuery().setType(444);
    }

    public final void DatasetClause() throws ParseException {
        if (this.jj_2_3(2)) {
            this.DefaultGraphClause();
        }
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 41: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block3;
                }
            }
            this.NamedGraphClause();
        }
    }

    public final void DefaultGraphClause() throws ParseException {
        this.jj_consume_token(41);
        Node node = this.SourceSelector();
        this.getQuery().addGraphURI(node.getURI());
    }

    public final void NamedGraphClause() throws ParseException {
        this.jj_consume_token(41);
        this.jj_consume_token(40);
        Node node = this.SourceSelector();
        this.getQuery().addNamedGraphURI(node.getURI());
    }

    public final Node SourceSelector() throws ParseException {
        Node node = this.URI();
        if (!node.isURI()) {
            throw new QueryException("Not a URI: " + node.toString());
        }
        return node;
    }

    public final void WhereClause() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: {
                this.jj_consume_token(42);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        Element element = this.GroupGraphPattern();
        this.getQuery().setQueryElement(element);
    }

    public final void OrderClause() throws ParseException {
        this.jj_consume_token(36);
        this.jj_consume_token(37);
        block3: while (true) {
            this.OrderCondition();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 38: 
                case 39: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[15] = this.jj_gen;
    }

    public final void OrderCondition() throws ParseException {
        int n = Query.ASCENDING;
        n = Query.ASCENDING;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 38: 
            case 39: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 38: {
                        this.jj_consume_token(38);
                        break;
                    }
                    case 39: {
                        this.jj_consume_token(39);
                        n = Query.DESCENDING;
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(62);
                this.OrderExpression(n);
                this.jj_consume_token(63);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                this.OrderExpression(n);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void OrderExpression(int n) throws ParseException {
        Node node = null;
        Expr expr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: 
            case 9: {
                expr = this.FunctionCall();
                break;
            }
            case 11: 
            case 12: {
                node = this.Var();
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (node == null) {
            this.getQuery().addOrderBy(expr, n);
        } else {
            this.getQuery().addOrderBy(node, n);
        }
    }

    public final void LimitClause() throws ParseException {
        this.jj_consume_token(34);
        Token token = this.jj_consume_token(16);
        this.getQuery().setLimit(this.integerValue(token.image));
    }

    public final void OffsetClause() throws ParseException {
        this.jj_consume_token(35);
        Token token = this.jj_consume_token(16);
        this.getQuery().setOffset(this.integerValue(token.image));
    }

    public final void QueryPatternTail(ElementGroup elementGroup) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 56: 
            case 57: 
            case 58: 
            case 62: {
                this.Triples(elementGroup);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 66: {
                        this.jj_consume_token(66);
                        break block0;
                    }
                }
                this.jj_la1[19] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 44: 
            case 45: 
            case 47: 
            case 60: {
                Element element = this.GraphPatternNotTriples();
                elementGroup.addElement(element);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 66: {
                        this.jj_consume_token(66);
                        break;
                    }
                    default: {
                        this.jj_la1[21] = this.jj_gen;
                    }
                }
                this.QueryPatternTail(elementGroup);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
            }
        }
    }

    public final Element GroupGraphPattern() throws ParseException {
        ElementGroup elementGroup = new ElementGroup();
        this.jj_consume_token(60);
        this.GraphPatternList(elementGroup);
        return elementGroup;
    }

    public final void GraphPatternList(ElementGroup elementGroup) throws ParseException {
        Element element = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 56: 
            case 57: 
            case 58: 
            case 62: {
                this.Triples(elementGroup);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 66: {
                        this.jj_consume_token(66);
                        break block0;
                    }
                }
                this.jj_la1[23] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 44: 
            case 45: 
            case 47: 
            case 60: {
                element = this.GraphPatternNotTriples();
                elementGroup.addElement(element);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 66: {
                        this.jj_consume_token(66);
                        break;
                    }
                    default: {
                        this.jj_la1[25] = this.jj_gen;
                    }
                }
                this.GraphPatternList(elementGroup);
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void GraphPattern(ElementGroup elementGroup) throws ParseException {
        Element element = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 56: 
            case 57: 
            case 58: 
            case 62: {
                this.Triples(elementGroup);
                break;
            }
            case 44: 
            case 45: 
            case 47: 
            case 60: {
                element = this.GraphPatternNotTriples();
                elementGroup.addElement(element);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Element GraphPatternNotTriples() throws ParseException {
        Element element = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 45: {
                element = this.OptionalGraphPattern();
                return element;
            }
        }
        this.jj_la1[28] = this.jj_gen;
        if (this.jj_2_4(3)) {
            element = this.UnionGraphPattern();
            return element;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 60: {
                element = this.GroupGraphPattern();
                return element;
            }
            case 44: {
                element = this.GraphGraphPattern();
                return element;
            }
            case 47: {
                element = this.Constraint();
                return element;
            }
        }
        this.jj_la1[29] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Element OptionalGraphPattern() throws ParseException {
        this.jj_consume_token(45);
        Element element = this.GroupGraphPattern();
        return new ElementOptional(element);
    }

    public final Element GraphGraphPattern() throws ParseException {
        this.jj_consume_token(44);
        Node node = this.VarOrBNodeOrURI();
        Element element = this.GroupGraphPattern();
        return new ElementNamedGraph(node, element);
    }

    public final Element UnionGraphPattern() throws ParseException {
        Element element = null;
        ElementUnion elementUnion = null;
        element = this.GroupGraphPattern();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 46: {
                    break;
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(46);
            if (elementUnion == null) {
                elementUnion = new ElementUnion();
                elementUnion.addElement(element);
            }
            element = this.GroupGraphPattern();
            elementUnion.addElement(element);
        }
        return elementUnion == null ? element : elementUnion;
    }

    public final Element Constraint() throws ParseException {
        this.jj_consume_token(47);
        Expr expr = this.Expression();
        ElementConstraints elementConstraints = new ElementConstraints();
        elementConstraints.addConstraint(expr);
        return elementConstraints;
    }

    public final Template ConstructTemplate() throws ParseException {
        TemplateGroup templateGroup = new TemplateGroup();
        this.jj_consume_token(60);
        this.Triples(templateGroup);
        this.jj_consume_token(61);
        return templateGroup;
    }

    public final void Triples(TripleCollector tripleCollector) throws ParseException {
        this.Triples1(tripleCollector);
        if (this.jj_2_5(2)) {
            this.jj_consume_token(66);
            this.Triples(tripleCollector);
        }
    }

    public final void Triples1(TripleCollector tripleCollector) throws ParseException {
        if (this.jj_2_6(2)) {
            Node node = this.VarOrTerm();
            this.PropertyListNotEmpty(node, tripleCollector);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 58: 
                case 62: {
                    Node node = this.TriplesNode(tripleCollector);
                    this.PropertyList(node, tripleCollector);
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void PropertyList(Node node, TripleCollector tripleCollector) throws ParseException {
        if (this.jj_2_7(2)) {
            this.PropertyListNotEmpty(node, tripleCollector);
        }
    }

    public final void PropertyListNotEmpty(Node node, TripleCollector tripleCollector) throws ParseException {
        Node node2 = this.Verb();
        this.ObjectList(node, node2, tripleCollector);
        this.PropertyListTail(node, tripleCollector);
    }

    public final void PropertyListTail(Node node, TripleCollector tripleCollector) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 64: {
                this.jj_consume_token(64);
                this.PropertyList(node, tripleCollector);
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
            }
        }
    }

    public final void ObjectList(Node node, Node node2, TripleCollector tripleCollector) throws ParseException {
        Node node3 = this.Object(tripleCollector);
        Triple triple = new Triple(node, node2, node3);
        tripleCollector.addTriple(triple);
        this.ObjectTail(node, node2, tripleCollector);
    }

    public final void ObjectTail(Node node, Node node2, TripleCollector tripleCollector) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 65: {
                this.jj_consume_token(65);
                this.ObjectList(node, node2, tripleCollector);
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
            }
        }
    }

    public final Node Verb() throws ParseException {
        Node node;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                node = this.VarOrURI();
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                node = this.nRDFtype;
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return node;
    }

    public final Node Object(TripleCollector tripleCollector) throws ParseException {
        Node node;
        if (this.jj_2_8(2)) {
            node = this.VarOrTerm();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 58: 
                case 62: {
                    node = this.TriplesNode(tripleCollector);
                    break;
                }
                default: {
                    this.jj_la1[35] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return node;
    }

    public final Node TriplesNode(TripleCollector tripleCollector) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 58: {
                Node node = this.Collection(tripleCollector);
                return node;
            }
            case 62: {
                Node node = this.BlankNodePropertyList(tripleCollector);
                return node;
            }
        }
        this.jj_la1[36] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node BlankNodePropertyList(TripleCollector tripleCollector) throws ParseException {
        this.jj_consume_token(62);
        Node node = this.createBNode();
        this.PropertyList(node, tripleCollector);
        this.jj_consume_token(63);
        return node;
    }

    public final Node Collection(TripleCollector tripleCollector) throws ParseException {
        Node node = this.nRDFnil;
        Node node2 = null;
        this.jj_consume_token(58);
        block3: while (true) {
            Node node3 = this.createBNode();
            if (node == this.nRDFnil) {
                node = node3;
            }
            if (node2 != null) {
                this.insert(tripleCollector, node2, this.nRDFrest, node3);
            }
            int n = tripleCollector.mark();
            Node node4 = this.GraphNode(tripleCollector);
            this.insert(tripleCollector, n, node3, this.nRDFfirst, node4);
            node2 = node3;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 16: 
                case 17: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 56: 
                case 57: 
                case 58: 
                case 62: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[37] = this.jj_gen;
        this.jj_consume_token(59);
        if (node2 != null) {
            this.insert(tripleCollector, node2, this.nRDFrest, this.nRDFnil);
        }
        return node;
    }

    public final Node GraphNode(TripleCollector tripleCollector) throws ParseException {
        if (this.jj_2_9(2)) {
            Node node = this.VarOrTerm();
            return node;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 58: 
            case 62: {
                Node node = this.TriplesNode(tripleCollector);
                return node;
            }
        }
        this.jj_la1[38] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node VarOrTerm() throws ParseException {
        Node node = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: 
            case 12: {
                node = this.Var();
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 56: 
            case 57: 
            case 58: 
            case 62: {
                node = this.GraphTerm();
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return node;
    }

    public final Node VarOrURI() throws ParseException {
        Node node = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: 
            case 12: {
                node = this.Var();
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                node = this.URI();
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return node;
    }

    public final Node VarOrBNodeOrURI() throws ParseException {
        Node node = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: 
            case 12: {
                node = this.Var();
                break;
            }
            case 10: 
            case 62: {
                node = this.BlankNode();
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                node = this.URI();
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return node;
    }

    public final Node Var() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                token = this.jj_consume_token(11);
                break;
            }
            case 12: {
                token = this.jj_consume_token(12);
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return Node.createVariable((String)token.image.substring(1));
    }

    public final Node GraphTerm() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 56: 
            case 57: 
            case 62: {
                Node node = this.RDFTerm();
                return node;
            }
            case 58: {
                this.jj_consume_token(58);
                this.jj_consume_token(59);
                return this.nRDFnil;
            }
        }
        this.jj_la1[43] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Expr Expression() throws ParseException {
        Expr expr = this.ConditionalOrExpression();
        return expr;
    }

    public final Expr ConditionalOrExpression() throws ParseException {
        Expr expr = this.ConditionalAndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 76: {
                    break;
                }
                default: {
                    this.jj_la1[44] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(76);
            Expr expr2 = this.ConditionalAndExpression();
            expr = new E_LogicalOr(expr, expr2);
        }
        return expr;
    }

    public final Expr ConditionalAndExpression() throws ParseException {
        Expr expr = this.ValueLogical();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 77: {
                    break;
                }
                default: {
                    this.jj_la1[45] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(77);
            Expr expr2 = this.ValueLogical();
            expr = new E_LogicalAnd(expr, expr2);
        }
        return expr;
    }

    public final Expr ValueLogical() throws ParseException {
        Expr expr = this.RelationalExpression();
        return expr;
    }

    public final Expr RelationalExpression() throws ParseException {
        Expr expr = this.NumericExpression();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 67: {
                        this.jj_consume_token(67);
                        Expr expr2 = this.NumericExpression();
                        expr = new E_Equal(expr, expr2);
                        break block0;
                    }
                    case 68: {
                        this.jj_consume_token(68);
                        Expr expr3 = this.NumericExpression();
                        expr = new E_NotEqual(expr, expr3);
                        break block0;
                    }
                    case 70: {
                        this.jj_consume_token(70);
                        Expr expr4 = this.NumericExpression();
                        expr = new E_LessThan(expr, expr4);
                        break block0;
                    }
                    case 69: {
                        this.jj_consume_token(69);
                        Expr expr5 = this.NumericExpression();
                        expr = new E_GreaterThan(expr, expr5);
                        break block0;
                    }
                    case 71: {
                        this.jj_consume_token(71);
                        Expr expr6 = this.NumericExpression();
                        expr = new E_LessThanOrEqual(expr, expr6);
                        break block0;
                    }
                    case 72: {
                        this.jj_consume_token(72);
                        Expr expr7 = this.NumericExpression();
                        expr = new E_GreaterThanOrEqual(expr, expr7);
                        break block0;
                    }
                }
                this.jj_la1[46] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
            }
        }
        return expr;
    }

    public final Expr NumericExpression() throws ParseException {
        Expr expr = this.AdditiveExpression();
        return expr;
    }

    public final Expr AdditiveExpression() throws ParseException {
        Expr expr;
        block8: {
            expr = this.MultiplicativeExpression();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 78: 
                    case 79: {
                        break;
                    }
                    default: {
                        this.jj_la1[48] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 78: {
                        this.jj_consume_token(78);
                        Expr expr2 = this.MultiplicativeExpression();
                        expr = new E_Add(expr, expr2);
                        continue block7;
                    }
                    case 79: {
                        this.jj_consume_token(79);
                        Expr expr2 = this.MultiplicativeExpression();
                        expr = new E_Subtract(expr, expr2);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[49] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return expr;
    }

    public final Expr MultiplicativeExpression() throws ParseException {
        Expr expr;
        block8: {
            expr = this.UnaryExpression();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 80: 
                    case 81: {
                        break;
                    }
                    default: {
                        this.jj_la1[50] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 80: {
                        this.jj_consume_token(80);
                        Expr expr2 = this.UnaryExpression();
                        expr = new E_Multiply(expr, expr2);
                        continue block7;
                    }
                    case 81: {
                        this.jj_consume_token(81);
                        Expr expr2 = this.UnaryExpression();
                        expr = new E_Divide(expr, expr2);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[51] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return expr;
    }

    public final Expr UnaryExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 73: {
                this.jj_consume_token(73);
                Expr expr = this.CallExpression();
                return new E_LogicalNot(expr);
            }
            case 78: {
                this.jj_consume_token(78);
                Expr expr = this.CallExpression();
                return new E_UnaryPlus(expr);
            }
            case 79: {
                this.jj_consume_token(79);
                Expr expr = this.CallExpression();
                return new E_UnaryMinus(expr);
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 62: {
                Expr expr = this.CallExpression();
                return expr;
            }
        }
        this.jj_la1[52] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Expr CallExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 49: {
                this.jj_consume_token(49);
                this.jj_consume_token(58);
                Expr expr = this.Expression();
                this.jj_consume_token(59);
                return new E_Str(expr);
            }
            case 51: {
                this.jj_consume_token(51);
                this.jj_consume_token(58);
                Expr expr = this.Expression();
                this.jj_consume_token(59);
                return new E_Lang(expr);
            }
            case 50: {
                this.jj_consume_token(50);
                this.jj_consume_token(58);
                Expr expr = this.Expression();
                this.jj_consume_token(59);
                return new E_Datatype(expr);
            }
            case 55: {
                String string = null;
                String string2 = null;
                this.jj_consume_token(55);
                this.jj_consume_token(58);
                Expr expr = this.Expression();
                this.jj_consume_token(65);
                string = this.String();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 65: {
                        this.jj_consume_token(65);
                        string2 = this.String();
                        break;
                    }
                    default: {
                        this.jj_la1[53] = this.jj_gen;
                    }
                }
                this.jj_consume_token(59);
                return new E_Regex(expr, string, string2);
            }
            case 48: {
                this.jj_consume_token(48);
                this.jj_consume_token(58);
                Node node = this.Var();
                this.jj_consume_token(59);
                return new E_Bound(new NodeVar(node));
            }
            case 52: {
                this.jj_consume_token(52);
                this.jj_consume_token(58);
                Expr expr = this.Expression();
                this.jj_consume_token(59);
                return new E_IsURI(expr);
            }
            case 53: {
                this.jj_consume_token(53);
                this.jj_consume_token(58);
                Expr expr = this.Expression();
                this.jj_consume_token(59);
                return new E_IsBlank(expr);
            }
            case 54: {
                this.jj_consume_token(54);
                this.jj_consume_token(58);
                Expr expr = this.Expression();
                this.jj_consume_token(59);
                return new E_IsLiteral(expr);
            }
        }
        this.jj_la1[54] = this.jj_gen;
        if (this.jj_2_10(2)) {
            Expr expr = this.FunctionCall();
            return expr;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 56: 
            case 57: 
            case 58: 
            case 62: {
                Expr expr = this.PrimaryExpression();
                return expr;
            }
        }
        this.jj_la1[55] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Expr PrimaryExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: 
            case 12: {
                Node node = this.Var();
                return this.asExpr(node);
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 56: 
            case 57: 
            case 62: {
                Node node = this.RDFTerm();
                return this.asExpr(node);
            }
            case 58: {
                this.jj_consume_token(58);
                Expr expr = this.Expression();
                this.jj_consume_token(59);
                return expr;
            }
        }
        this.jj_la1[56] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Expr FunctionCall() throws ParseException {
        Node node = this.URI();
        this.jj_consume_token(58);
        List list = this.ArgList();
        this.jj_consume_token(59);
        E_Function e_Function = new E_Function(node.getURI(), list);
        return e_Function;
    }

    public final List ArgList() throws ParseException {
        ArrayList<Expr> arrayList = new ArrayList<Expr>();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 62: 
            case 73: 
            case 78: 
            case 79: {
                Expr expr = this.Expression();
                arrayList.add(expr);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 65: {
                            break;
                        }
                        default: {
                            this.jj_la1[57] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(65);
                    expr = this.Expression();
                    arrayList.add(expr);
                }
            }
            default: {
                this.jj_la1[58] = this.jj_gen;
            }
        }
        return arrayList;
    }

    public final Node RDFTerm() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: 
            case 9: {
                Node node = this.URI();
                return node;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                Node node = this.RDFLiteral();
                return node;
            }
            case 16: 
            case 17: {
                Node node = this.NumericLiteral();
                return node;
            }
            case 56: 
            case 57: {
                Node node = this.BooleanLiteral();
                return node;
            }
            case 10: 
            case 62: {
                Node node = this.BlankNode();
                return node;
            }
        }
        this.jj_la1[59] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node NumericLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                Node node = this.Integer();
                return node;
            }
            case 17: {
                Node node = this.FloatingPoint();
                return node;
            }
        }
        this.jj_la1[60] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node RDFLiteral() throws ParseException {
        String string = null;
        string = this.String();
        String string2 = null;
        Node node = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: 
            case 82: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: {
                        Token token = this.jj_consume_token(13);
                        string2 = this.stripChars(token.image, 1);
                        break block0;
                    }
                    case 82: {
                        this.jj_consume_token(82);
                        node = this.URI();
                        break block0;
                    }
                }
                this.jj_la1[61] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
            }
        }
        return this.makeNode(string, string2, node);
    }

    public final Node BooleanLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 56: {
                this.jj_consume_token(56);
                return this.XSD_TRUE;
            }
            case 57: {
                this.jj_consume_token(57);
                return this.XSD_FALSE;
            }
        }
        this.jj_la1[63] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String String() throws ParseException {
        Token token;
        String string = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                token = this.jj_consume_token(21);
                break;
            }
            case 22: {
                token = this.jj_consume_token(22);
                break;
            }
            case 23: {
                token = this.jj_consume_token(23);
                break;
            }
            case 24: {
                token = this.jj_consume_token(24);
                break;
            }
            default: {
                this.jj_la1[64] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        string = this.stripQuotes(token.image);
        string = this.unescape(string);
        return string;
    }

    public final Node URI() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                Node node = this.QuotedURIref();
                return node;
            }
            case 8: 
            case 9: {
                Node node = this.QName();
                return node;
            }
        }
        this.jj_la1[65] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node QName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                Token token = this.jj_consume_token(9);
                return Node.createURI((String)this.fixupQName(token));
            }
            case 8: {
                Token token = this.jj_consume_token(8);
                return Node.createURI((String)this.fixupQName(token));
            }
        }
        this.jj_la1[66] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node BlankNode() throws ParseException {
        Token token = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                token = this.jj_consume_token(10);
                return this.createBNode(token.image);
            }
            case 62: {
                this.jj_consume_token(62);
                this.jj_consume_token(63);
                return this.createBNode();
            }
        }
        this.jj_la1[67] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node QuotedURIref() throws ParseException {
        Token token = this.jj_consume_token(7);
        String string = this.stripQuotes(token.image);
        string = this.fixupURI(string);
        return Node.createURI((String)string);
    }

    public final Node Integer() throws ParseException {
        Token token = this.jj_consume_token(16);
        return this.makeNodeInteger(token.image);
    }

    public final Node FloatingPoint() throws ParseException {
        Token token = this.jj_consume_token(17);
        return this.makeNodeDouble(token.image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_7(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_8(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_9(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_10(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, n);
        }
    }

    private final boolean jj_3R_48() {
        return this.jj_scan_token(7);
    }

    private final boolean jj_3R_99() {
        return this.jj_3R_100();
    }

    private final boolean jj_3R_83() {
        if (this.jj_scan_token(62)) {
            return true;
        }
        return this.jj_scan_token(63);
    }

    private final boolean jj_3R_82() {
        return this.jj_scan_token(10);
    }

    private final boolean jj_3R_73() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_82()) {
            this.jj_scanpos = token;
            if (this.jj_3R_83()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_19() {
        if (this.jj_3R_29()) {
            return true;
        }
        return this.jj_3R_30();
    }

    private final boolean jj_3R_55() {
        return this.jj_scan_token(8);
    }

    private final boolean jj_3_7() {
        return this.jj_3R_19();
    }

    private final boolean jj_3R_94() {
        Token token = this.jj_scanpos;
        if (this.jj_3_7()) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private final boolean jj_3R_54() {
        return this.jj_scan_token(9);
    }

    private final boolean jj_3_5() {
        if (this.jj_scan_token(66)) {
            return true;
        }
        return this.jj_3R_17();
    }

    private final boolean jj_3R_49() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_54()) {
            this.jj_scanpos = token;
            if (this.jj_3R_55()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_35() {
        return this.jj_3R_44();
    }

    private final boolean jj_3R_41() {
        return this.jj_3R_49();
    }

    private final boolean jj_3R_97() {
        return this.jj_3R_99();
    }

    private final boolean jj_3R_31() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_40()) {
            this.jj_scanpos = token;
            if (this.jj_3R_41()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_40() {
        return this.jj_3R_48();
    }

    private final boolean jj_3R_26() {
        Token token = this.jj_scanpos;
        if (this.jj_3_6()) {
            this.jj_scanpos = token;
            if (this.jj_3R_35()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_6() {
        if (this.jj_3R_18()) {
            return true;
        }
        return this.jj_3R_19();
    }

    private final boolean jj_3R_95() {
        return this.jj_3R_97();
    }

    private final boolean jj_3R_17() {
        return this.jj_3R_26();
    }

    private final boolean jj_3R_76() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(21)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(22)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(23)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(24)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_23() {
        return this.jj_3R_31();
    }

    private final boolean jj_3R_92() {
        return this.jj_3R_95();
    }

    private final boolean jj_3R_81() {
        return this.jj_scan_token(57);
    }

    private final boolean jj_3R_80() {
        return this.jj_scan_token(56);
    }

    private final boolean jj_3R_72() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_80()) {
            this.jj_scanpos = token;
            if (this.jj_3R_81()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_86() {
        return this.jj_3R_31();
    }

    private final boolean jj_3R_89() {
        return this.jj_scan_token(82);
    }

    private final boolean jj_3R_87() {
        return this.jj_3R_92();
    }

    private final boolean jj_3R_88() {
        return this.jj_scan_token(13);
    }

    private final boolean jj_3R_77() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_88()) {
            this.jj_scanpos = token;
            if (this.jj_3R_89()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_15() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        return this.jj_3R_23();
    }

    private final boolean jj_3R_75() {
        return this.jj_3R_87();
    }

    private final boolean jj_3_3() {
        return this.jj_3R_15();
    }

    private final boolean jj_3R_69() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        return this.jj_3R_75();
    }

    private final boolean jj_3R_70() {
        if (this.jj_3R_76()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_77()) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private final boolean jj_3R_79() {
        return this.jj_3R_91();
    }

    private final boolean jj_3R_85() {
        return this.jj_3R_73();
    }

    private final boolean jj_3R_78() {
        return this.jj_3R_90();
    }

    private final boolean jj_3R_46() {
        if (this.jj_scan_token(58)) {
            return true;
        }
        return this.jj_scan_token(59);
    }

    private final boolean jj_3R_71() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_78()) {
            this.jj_scanpos = token;
            if (this.jj_3R_79()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_14() {
        return this.jj_3R_22();
    }

    private final boolean jj_3R_36() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_45()) {
            this.jj_scanpos = token;
            if (this.jj_3R_46()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_45() {
        return this.jj_3R_53();
    }

    private final boolean jj_3R_25() {
        return this.jj_scan_token(46);
    }

    private final boolean jj_3R_21() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(11)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(12)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_66() {
        return this.jj_3R_73();
    }

    private final boolean jj_3R_16() {
        Token token;
        if (this.jj_3R_24()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_25());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_33() {
        return this.jj_3R_31();
    }

    private final boolean jj_3R_65() {
        return this.jj_3R_72();
    }

    private final boolean jj_3R_64() {
        return this.jj_3R_71();
    }

    private final boolean jj_3R_84() {
        return this.jj_3R_21();
    }

    private final boolean jj_3R_63() {
        return this.jj_3R_70();
    }

    private final boolean jj_3R_74() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_84()) {
            this.jj_scanpos = token;
            if (this.jj_3R_85()) {
                this.jj_scanpos = token;
                if (this.jj_3R_86()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_68() {
        if (this.jj_scan_token(44)) {
            return true;
        }
        return this.jj_3R_74();
    }

    private final boolean jj_3R_28() {
        return this.jj_3R_36();
    }

    private final boolean jj_3R_53() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_62()) {
            this.jj_scanpos = token;
            if (this.jj_3R_63()) {
                this.jj_scanpos = token;
                if (this.jj_3R_64()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_65()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_66()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_62() {
        return this.jj_3R_31();
    }

    private final boolean jj_3_2() {
        Token token;
        if (this.jj_scan_token(31)) {
            return true;
        }
        if (this.jj_3R_14()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_14());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_32() {
        return this.jj_3R_21();
    }

    private final boolean jj_3R_67() {
        if (this.jj_scan_token(45)) {
            return true;
        }
        return this.jj_3R_24();
    }

    private final boolean jj_3R_22() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_32()) {
            this.jj_scanpos = token;
            if (this.jj_3R_33()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_13() {
        return this.jj_3R_21();
    }

    private final boolean jj_3R_59() {
        return this.jj_3R_69();
    }

    private final boolean jj_3R_27() {
        return this.jj_3R_21();
    }

    private final boolean jj_3R_18() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_27()) {
            this.jj_scanpos = token;
            if (this.jj_3R_28()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(29)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(30)) {
            this.jj_scanpos = token;
        }
        if (this.jj_3R_13()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_13());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_58() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_98() {
        return this.jj_3R_44();
    }

    private final boolean jj_3R_57() {
        return this.jj_3R_24();
    }

    private final boolean jj_3R_20() {
        if (this.jj_3R_31()) {
            return true;
        }
        return this.jj_scan_token(58);
    }

    private final boolean jj_3R_96() {
        Token token = this.jj_scanpos;
        if (this.jj_3_9()) {
            this.jj_scanpos = token;
            if (this.jj_3R_98()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_9() {
        return this.jj_3R_18();
    }

    private final boolean jj_3_4() {
        return this.jj_3R_16();
    }

    private final boolean jj_3R_120() {
        return this.jj_scan_token(58);
    }

    private final boolean jj_3R_50() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_56()) {
            this.jj_scanpos = token;
            if (this.jj_3_4()) {
                this.jj_scanpos = token;
                if (this.jj_3R_57()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_58()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_59()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_56() {
        return this.jj_3R_67();
    }

    private final boolean jj_3R_119() {
        return this.jj_3R_53();
    }

    private final boolean jj_3R_118() {
        return this.jj_3R_21();
    }

    private final boolean jj_3R_117() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_118()) {
            this.jj_scanpos = token;
            if (this.jj_3R_119()) {
                this.jj_scanpos = token;
                if (this.jj_3R_120()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_116() {
        return this.jj_3R_117();
    }

    private final boolean jj_3_10() {
        return this.jj_3R_20();
    }

    private final boolean jj_3R_115() {
        return this.jj_scan_token(54);
    }

    private final boolean jj_3R_114() {
        return this.jj_scan_token(53);
    }

    private final boolean jj_3R_93() {
        return this.jj_3R_96();
    }

    private final boolean jj_3R_113() {
        return this.jj_scan_token(52);
    }

    private final boolean jj_3R_43() {
        return this.jj_3R_50();
    }

    private final boolean jj_3R_112() {
        return this.jj_scan_token(48);
    }

    private final boolean jj_3R_42() {
        return this.jj_3R_17();
    }

    private final boolean jj_3R_60() {
        Token token;
        if (this.jj_scan_token(58)) {
            return true;
        }
        if (this.jj_3R_93()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_93());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_34() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_42()) {
            this.jj_scanpos = token;
        }
        token = this.jj_scanpos;
        if (this.jj_3R_43()) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(61)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_24() {
        if (this.jj_scan_token(60)) {
            return true;
        }
        return this.jj_3R_34();
    }

    private final boolean jj_3R_111() {
        return this.jj_scan_token(55);
    }

    private final boolean jj_3R_61() {
        if (this.jj_scan_token(62)) {
            return true;
        }
        if (this.jj_3R_94()) {
            return true;
        }
        return this.jj_scan_token(63);
    }

    private final boolean jj_3R_110() {
        return this.jj_scan_token(50);
    }

    private final boolean jj_3R_109() {
        return this.jj_scan_token(51);
    }

    private final boolean jj_3R_52() {
        return this.jj_3R_61();
    }

    private final boolean jj_3R_108() {
        return this.jj_scan_token(49);
    }

    private final boolean jj_3R_107() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_108()) {
            this.jj_scanpos = token;
            if (this.jj_3R_109()) {
                this.jj_scanpos = token;
                if (this.jj_3R_110()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_111()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_112()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_113()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_114()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_115()) {
                                        this.jj_scanpos = token;
                                        if (this.jj_3_10()) {
                                            this.jj_scanpos = token;
                                            if (this.jj_3R_116()) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_44() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_51()) {
            this.jj_scanpos = token;
            if (this.jj_3R_52()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_51() {
        return this.jj_3R_60();
    }

    private final boolean jj_3R_38() {
        return this.jj_scan_token(26);
    }

    private final boolean jj_3R_106() {
        return this.jj_3R_107();
    }

    private final boolean jj_3R_105() {
        return this.jj_scan_token(79);
    }

    private final boolean jj_3R_104() {
        return this.jj_scan_token(78);
    }

    private final boolean jj_3R_47() {
        return this.jj_3R_44();
    }

    private final boolean jj_3R_103() {
        return this.jj_scan_token(73);
    }

    private final boolean jj_3R_102() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_103()) {
            this.jj_scanpos = token;
            if (this.jj_3R_104()) {
                this.jj_scanpos = token;
                if (this.jj_3R_105()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_106()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_8() {
        return this.jj_3R_18();
    }

    private final boolean jj_3R_39() {
        Token token = this.jj_scanpos;
        if (this.jj_3_8()) {
            this.jj_scanpos = token;
            if (this.jj_3R_47()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_37() {
        return this.jj_3R_22();
    }

    private final boolean jj_3R_29() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_37()) {
            this.jj_scanpos = token;
            if (this.jj_3R_38()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_101() {
        return this.jj_3R_102();
    }

    private final boolean jj_3R_91() {
        return this.jj_scan_token(17);
    }

    private final boolean jj_3R_90() {
        return this.jj_scan_token(16);
    }

    private final boolean jj_3R_30() {
        return this.jj_3R_39();
    }

    private final boolean jj_3R_100() {
        return this.jj_3R_101();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{-1610612736, 0, 0, 0, 0, 0x8000000, 0x10000000, 0x40000000, 6144, 0x40000000, 0x20000000, 7040, Integer.MIN_VALUE, 0, 0, 7040, 0, 7040, 7040, 0, 31661952, 0, 0, 0, 31661952, 0, 0, 31661952, 0, 0, 0, 0, 0, 0, 67115904, 0, 0, 31661952, 0, 31661952, 7040, 8064, 6144, 31655808, 0, 0, 0, 0, 0, 0, 0, 0, 31661952, 0, 0, 31661952, 31661952, 0, 31661952, 31655808, 196608, 8192, 8192, 0, 0x1E00000, 896, 768, 1024};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{3, 0x10000400, 16, 4, 8, 0, 0, 0, 0, 0, 0, 0, 0, 512, 1024, 192, 192, 192, 0, 0, 0x47000000, 0, 0x1000B000, 0, 0x47000000, 0, 0x3000B000, 1459662848, 8192, 0x10009000, 16384, 0x44000000, 0, 0, 0, 0x44000000, 0x44000000, 0x47000000, 0x44000000, 0x47000000, 0, 0x40000000, 0, 0x47000000, 0, 0, 0, 0, 0, 0, 0, 0, 1207894016, 0, 0xFF0000, 0x47000000, 0x47000000, 0, 1207894016, 0x43000000, 0, 0, 0, 0x3000000, 0, 0, 0, 0x40000000};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 0, 4, 0, 4, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4096, 8192, 504, 504, 49152, 49152, 196608, 196608, 49664, 2, 0, 0, 0, 2, 49664, 0, 0, 262144, 262144, 0, 0, 0, 0, 0};
    }

    public SPARQLParser(InputStream inputStream) {
        int n;
        this.jj_input_stream = new JavaCharStream(inputStream, 1, 1);
        this.token_source = new SPARQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 68; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(InputStream inputStream) {
        int n;
        this.jj_input_stream.ReInit(inputStream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 68; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public SPARQLParser(Reader reader) {
        int n;
        this.jj_input_stream = new JavaCharStream(reader, 1, 1);
        this.token_source = new SPARQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 68; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(Reader reader) {
        int n;
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 68; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public SPARQLParser(SPARQLParserTokenManager sPARQLParserTokenManager) {
        int n;
        this.token_source = sPARQLParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 68; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(SPARQLParserTokenManager sPARQLParserTokenManager) {
        int n;
        this.token_source = sPARQLParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 68; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            int n3;
            this.jj_expentry = new int[this.jj_endpos];
            for (n3 = 0; n3 < this.jj_endpos; ++n3) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
            }
            n3 = 0;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                n3 = 1;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] == this.jj_expentry[i]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
            }
            if (n3 == 0) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[89];
        for (n2 = 0; n2 < 89; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 68; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) != 0) {
                    blArray[32 + n] = true;
                }
                if ((jj_la1_2[n2] & 1 << n) == 0) continue;
                blArray[64 + n] = true;
            }
        }
        for (n2 = 0; n2 < 89; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 10; ++i) {
            JJCalls jJCalls = this.jj_2_rtns[i];
            do {
                if (jJCalls.gen <= this.jj_gen) continue;
                this.jj_la = jJCalls.arg;
                this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                        break;
                    }
                    case 4: {
                        this.jj_3_5();
                        break;
                    }
                    case 5: {
                        this.jj_3_6();
                        break;
                    }
                    case 6: {
                        this.jj_3_7();
                        break;
                    }
                    case 7: {
                        this.jj_3_8();
                        break;
                    }
                    case 8: {
                        this.jj_3_9();
                        break;
                    }
                    case 9: {
                        this.jj_3_10();
                    }
                }
            } while ((jJCalls = jJCalls.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        SPARQLParser.jj_la1_0();
        SPARQLParser.jj_la1_1();
        SPARQLParser.jj_la1_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

