/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.model.impl.AbstractRDFSClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLIntersectionClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableConstants;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableItem;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

public class ConditionsTableModel
extends AbstractTableModel
implements ConditionsTableConstants,
OWLTableModel {
    private static transient Logger log = Log.getLogger(ConditionsTableModel.class);
    private ClassListener classListener = new ClassAdapter(){

        public void subclassAdded(RDFSClass cls, RDFSClass subclass) {
            ConditionsTableModel.this.refill();
        }

        public void subclassRemoved(RDFSClass cls, RDFSClass subclass) {
            ConditionsTableModel.this.refill();
        }

        public void superclassAdded(RDFSClass cls, RDFSClass superclass) {
            ConditionsTableModel.this.refill();
        }

        public void superclassRemoved(RDFSClass cls, RDFSClass superclass) {
            ConditionsTableModel.this.refill();
        }
    };
    private FrameListener frameListener = new FrameAdapter(){

        public void ownSlotValueChanged(FrameEvent event) {
            if (event.getSlot().equals(ConditionsTableModel.this.superclassesSlot)) {
                ConditionsTableModel.this.refill();
            }
        }
    };
    private OWLNamedClass hostClass;
    private List items = new ArrayList();
    private Collection listenedToClses = new ArrayList();
    private OWLModel owlModel;
    public Cls previouslyEditedCls;
    private Slot superclassesSlot;

    public ConditionsTableModel(OWLModel owlModel) {
        this(owlModel.getSlot(":DIRECT-SUPERCLASSES"));
    }

    public ConditionsTableModel(Slot superclassesSlot) {
        this.superclassesSlot = superclassesSlot;
        this.owlModel = (OWLModel)superclassesSlot.getKnowledgeBase();
    }

    public ConditionsTableModel(OWLNamedClass hostCls, Slot superclassesSlot) {
        this(superclassesSlot);
        this.setCls(hostCls);
    }

    public int addEmptyDefinitionBlock() {
        int type = this.getType(0) + 1;
        ConditionsTableItem separator = ConditionsTableItem.createSeparator(type);
        int row = 0;
        this.items.add(row, separator);
        this.fireTableRowsInserted(row, row);
        return row;
    }

    public int addEmptyRow(int selectedRow) {
        ConditionsTableItem item = ConditionsTableItem.createNew(this.getType(selectedRow));
        int index = selectedRow + 1;
        this.addItem(index, item);
        this.fireTableRowsInserted(index, index);
        return index;
    }

    private void addItem(int index, ConditionsTableItem item) {
        this.items.add(index, item);
        this.updateLocalIndices();
    }

    private void addItemUnlessOverloaded(RDFSClass aClass, OWLNamedClass originCls) {
        if (aClass instanceof OWLRestriction) {
            RDFSClass directType = aClass.getProtegeType();
            RDFProperty property = ((OWLRestriction)aClass).getOnProperty();
            if (aClass instanceof OWLHasValue) {
                String browserText = aClass.getBrowserText();
                for (ConditionsTableItem existing : this.items) {
                    if (existing.isSeparator() || !browserText.equals(existing.aClass.getBrowserText())) continue;
                    return;
                }
            } else if (aClass instanceof OWLSomeValuesFrom) {
                OWLSomeValuesFrom someRestriction = (OWLSomeValuesFrom)aClass;
                if (someRestriction.getFiller() instanceof RDFSClass) {
                    RDFSClass someClass = (RDFSClass)someRestriction.getFiller();
                    String browserText = aClass.getBrowserText();
                    for (ConditionsTableItem existing : this.items) {
                        RDFSClass otherSomeClass;
                        if (existing.isSeparator() || !(existing.aClass instanceof OWLSomeValuesFrom)) continue;
                        if (browserText.equals(existing.aClass.getBrowserText())) {
                            return;
                        }
                        OWLSomeValuesFrom other = (OWLSomeValuesFrom)existing.aClass;
                        if (!other.getOnProperty().equals(property) || !(other.getFiller() instanceof RDFSClass) || !(otherSomeClass = (RDFSClass)other.getFiller()).isSubclassOf(someClass)) continue;
                        return;
                    }
                }
            } else if (aClass instanceof OWLAllValuesFrom && ((OWLAllValuesFrom)aClass).getFiller() instanceof RDFSClass) {
                OWLAllValuesFrom newRestriction = (OWLAllValuesFrom)aClass;
                OWLNamedClass newSourceClass = newRestriction.getOwner();
                for (ConditionsTableItem existing : this.items) {
                    if (existing.isSeparator() || !directType.equals(existing.aClass.getProtegeType()) || !property.equals(((OWLRestriction)existing.aClass).getOnProperty())) continue;
                    OWLAllValuesFrom existingRestriction = (OWLAllValuesFrom)existing.aClass;
                    OWLNamedClass existingSourceCls = existingRestriction.getOwner();
                    if (!((RDFSClass)existingRestriction.getFiller()).isSubclassOf((RDFSClass)newRestriction.getFiller()) || existingSourceCls.equals(newSourceClass)) continue;
                    return;
                }
            } else {
                boolean qcr = false;
                if (aClass instanceof OWLCardinalityBase) {
                    OWLCardinalityBase base = (OWLCardinalityBase)aClass;
                    qcr = base.isQualified();
                }
                if (!qcr) {
                    for (ConditionsTableItem existing : this.items) {
                        if (existing.isSeparator() || !directType.equals(existing.aClass.getProtegeType()) || !property.equals(((OWLRestriction)existing.aClass).getOnProperty())) continue;
                        return;
                    }
                }
            }
        }
        this.addInheritedSeparator();
        this.items.add(ConditionsTableItem.createInherited(aClass, originCls));
    }

    private void addInheritedSeparator() {
        for (ConditionsTableItem item : this.items) {
            if (!item.isSeparator() || item.getType() != -2) continue;
            return;
        }
        this.items.add(ConditionsTableItem.createSeparator(-2));
    }

    public boolean addRow(RDFSClass aClass, int selectedRow) {
        String browserText = aClass.getBrowserText();
        if (this.isDefinition(selectedRow) || !((AbstractRDFSClass)((Object)this.hostClass)).hasPropertyValueWithBrowserText(this.owlModel.getSlot(":DIRECT-SUPERCLASSES"), browserText)) {
            return this.addRowAllowMove(aClass, selectedRow);
        }
        return false;
    }

    public boolean addRowAllowMove(RDFSClass aClass, int selectedRow) {
        if (aClass.equals(this.hostClass) || !this.isCreateEnabledAt(selectedRow) && aClass instanceof OWLAnonymousClass || !this.isAddEnabledAt(selectedRow) && aClass instanceof OWLNamedClass) {
            return false;
        }
        int type = this.getType(selectedRow);
        if (type == -1) {
            this.hostClass.addSuperclass(aClass);
        } else if (this.isDefinition(selectedRow)) {
            DefaultOWLIntersectionClass definition;
            if (aClass.equals(this.owlModel.getOWLThingClass())) {
                return false;
            }
            if (this.isSeparator(selectedRow)) {
                ++selectedRow;
            }
            if ((definition = (DefaultOWLIntersectionClass)this.getDefinition(selectedRow)) != null) {
                String browserText = aClass.getBrowserText();
                if (definition.hasOperandWithBrowserText(browserText)) {
                    return false;
                }
                OWLIntersectionClass copy = (OWLIntersectionClass)definition.createClone();
                copy.addOperand(aClass);
                this.hostClass.addEquivalentClass(copy);
                definition.delete();
            } else {
                RDFSClass oldEquivalentClass = this.getClass(selectedRow);
                if (oldEquivalentClass != null) {
                    if (oldEquivalentClass.getBrowserText().equals(aClass.getBrowserText())) {
                        return false;
                    }
                    OWLModel owlModel = aClass.getOWLModel();
                    OWLIntersectionClass newDefinition = owlModel.createOWLIntersectionClass();
                    newDefinition.addOperand(oldEquivalentClass.createClone());
                    newDefinition.addOperand(aClass);
                    this.hostClass.removeSuperclass(oldEquivalentClass);
                    if (oldEquivalentClass instanceof OWLNamedClass) {
                        oldEquivalentClass.removeSuperclass(this.hostClass);
                    }
                    this.hostClass.addEquivalentClass(newDefinition);
                } else {
                    this.hostClass.addEquivalentClass(aClass);
                }
            }
        }
        return true;
    }

    private boolean deleteDefinitionRow(int index) {
        OWLIntersectionClass definition;
        RDFSClass rowClass = this.getClass(index);
        if (this.isDefinition(index) && (definition = this.getDefinition(index)) != null) {
            ArrayList operands = new ArrayList(definition.getOperands());
            if (operands.size() == 2) {
                operands.remove(rowClass);
                RDFSClass remainder = (RDFSClass)operands.iterator().next();
                RDFSClass copy = remainder.createClone();
                this.hostClass.addEquivalentClass(copy);
                definition.delete();
            } else {
                OWLModel owlModel = rowClass.getOWLModel();
                operands.remove(rowClass);
                OWLIntersectionClass newDefinition = owlModel.createOWLIntersectionClass();
                for (RDFSClass oldOperand : operands) {
                    newDefinition.addOperand(oldOperand.createClone());
                }
                this.hostClass.addEquivalentClass(newDefinition);
                definition.delete();
            }
            if (!this.hostClass.hasNamedSuperclass()) {
                this.hostClass.addSuperclass(this.owlModel.getOWLThingClass());
            }
            return true;
        }
        return false;
    }

    public void deleteRow(int index) {
        try {
            try {
                this.owlModel.beginTransaction("Delete condition " + this.getClass(index).getBrowserText() + " from " + this.getEditedCls().getBrowserText());
                this.deleteRow(index, false);
            }
            catch (Exception ex) {
                OWLUI.handleError(this.owlModel, ex);
            }
        }
        finally {
            this.owlModel.endTransaction();
        }
    }

    public void deleteRow(int index, boolean forceDelete) {
        RDFSClass rowClass = this.getClass(index);
        boolean definition = this.getDefinition(index) != null;
        boolean isDefinition = this.isDefinition(index);
        boolean deleted = this.deleteDefinitionRow(index);
        if (!deleted && isDefinition && rowClass instanceof OWLNamedClass && forceDelete) {
            rowClass.removeSuperclass(this.hostClass);
            rowClass.removeSuperclass(this.hostClass);
        } else if (this.hostClass.isSubclassOf(rowClass) && (!this.getNamedDefinitionClses(definition).contains(rowClass) || forceDelete)) {
            if (rowClass instanceof RDFSNamedClass) {
                int namedSuperclassCount = this.hostClass.getNamedSuperclasses().size();
                if (namedSuperclassCount == 1) {
                    this.hostClass.addSuperclass(this.owlModel.getOWLThingClass());
                }
                if (!rowClass.equals(this.owlModel.getOWLThingClass())) {
                    this.hostClass.removeSuperclass(rowClass);
                } else {
                    HashSet nss = new HashSet(this.hostClass.getNamedSuperclasses());
                    nss.remove(rowClass);
                    if (nss.size() > 0) {
                        this.hostClass.removeSuperclass(rowClass);
                    }
                }
            } else {
                this.hostClass.removeSuperclass(rowClass);
            }
        }
    }

    public void displaySemanticError(String message) {
        ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, message);
    }

    public void dispose() {
        if (this.hostClass != null) {
            this.hostClass.removeClassListener(this.classListener);
            this.hostClass.removeFrameListener(this.frameListener);
        }
        this.removeListeners();
    }

    public void dumpItems() {
        System.err.println("Items:");
        for (ConditionsTableItem tableItem : this.items) {
            System.err.println(" - " + tableItem + " (" + tableItem.getType() + ")");
        }
    }

    private void fillItems() {
        HashSet coveredClses = new HashSet();
        int classificationStatus = this.getEditedCls().getClassificationStatus();
        if (this.superclassesSlot.getName().equals(":DIRECT-SUPERCLASSES") || classificationStatus != 0) {
            this.fillDefinitionItems(coveredClses);
            this.fillDirectSuperclassItems(coveredClses);
            this.fillInheritedItems(coveredClses);
            this.sortItems();
        }
    }

    private void fillDefinitionItems(Collection coveredClses) {
        Slot slot = this.hostClass.getOWLModel().getSlot(":DIRECT-SUPERCLASSES");
        int index = 0;
        ConditionsTableItem firstSeparator = ConditionsTableItem.createSeparator(index);
        this.items.add(firstSeparator);
        ArrayList<ConditionsTableItem> separators = new ArrayList<ConditionsTableItem>();
        separators.add(firstSeparator);
        boolean first = true;
        for (Cls superCls : this.hostClass.getDirectOwnSlotValues(slot)) {
            if (!(superCls instanceof RDFSClass) || !superCls.getDirectOwnSlotValues(slot).contains(this.hostClass)) continue;
            if (!first) {
                ConditionsTableItem separator = ConditionsTableItem.createSeparator(index);
                this.items.add(separator);
                separators.add(separator);
            }
            first = false;
            RDFSClass equivalentClass = (RDFSClass)superCls;
            coveredClses.add(equivalentClass);
            if (equivalentClass instanceof OWLIntersectionClass) {
                OWLIntersectionClass intersectionCls = (OWLIntersectionClass)equivalentClass;
                Collection operands = ((OWLIntersectionClass)equivalentClass).getOperands();
                for (RDFSClass operand : operands) {
                    coveredClses.add(operand);
                    this.items.add(ConditionsTableItem.createSufficient(operand, index, intersectionCls));
                }
            } else {
                this.items.add(ConditionsTableItem.create(equivalentClass, index));
            }
            ++index;
        }
        if (separators.size() > 1) {
            this.sortItems();
            this.sortSufficientBlocks(separators);
        }
    }

    private void fillDirectSuperclassItems(Collection coveredClses) {
        RDFSClass aClass;
        this.items.add(ConditionsTableItem.createSeparator(-1));
        for (Cls superCls : this.hostClass.getDirectOwnSlotValues(this.superclassesSlot)) {
            if (!(superCls instanceof RDFSNamedClass) || coveredClses.contains(superCls)) continue;
            aClass = (RDFSClass)superCls;
            coveredClses.add(aClass);
            this.items.add(ConditionsTableItem.create(aClass, -1));
        }
        for (Cls superCls : this.hostClass.getSuperclasses(false)) {
            if (!(superCls instanceof OWLAnonymousClass) || coveredClses.contains(superCls)) continue;
            aClass = (RDFSClass)superCls;
            coveredClses.add(aClass);
            this.items.add(ConditionsTableItem.create(aClass, -1));
        }
    }

    private void fillInheritedItems(Collection coveredClses) {
        coveredClses.removeAll(this.getNamedDefinitionClses(false));
        for (Cls superCls : this.hostClass.getDirectOwnSlotValues(this.superclassesSlot)) {
            if (!(superCls instanceof OWLNamedClass) || superCls.equals(this.hostClass)) continue;
            OWLNamedClass namedSuperclass = (OWLNamedClass)superCls;
            this.fillInheritedItems(namedSuperclass, coveredClses);
            this.listenedToClses.add(superCls);
            namedSuperclass.addClassListener(this.classListener);
            namedSuperclass.addFrameListener(this.frameListener);
        }
    }

    private void fillInheritedItems(OWLNamedClass originCls, Collection coveredClses) {
        this.fillInheritedAnonymousClses(originCls, coveredClses);
        for (Cls ss : originCls.getDirectOwnSlotValues(this.superclassesSlot)) {
            if (!(ss instanceof OWLNamedClass) || coveredClses.contains(ss)) continue;
            coveredClses.add(ss);
            this.fillInheritedItems((OWLNamedClass)ss, coveredClses);
        }
    }

    private void fillInheritedAnonymousClses(OWLNamedClass originCls, Collection coveredClses) {
        for (Cls ss : originCls.getSuperclasses(false)) {
            if (!(ss instanceof OWLAnonymousClass)) continue;
            if (ss instanceof OWLIntersectionClass) {
                Collection operands = ((OWLIntersectionClass)ss).getOperands();
                for (RDFSClass operand : operands) {
                    if (!(operand instanceof OWLAnonymousClass)) continue;
                    this.addItemUnlessOverloaded(operand, originCls);
                }
                continue;
            }
            if (coveredClses.contains(ss)) continue;
            this.addItemUnlessOverloaded((OWLAnonymousClass)ss, originCls);
        }
    }

    public int getBlockSize(int blockStartRow) {
        int count = 0;
        int type = this.getType(blockStartRow - 1);
        int i = blockStartRow;
        while (i < this.items.size() && this.getItem(i).getType() == type) {
            ++count;
            ++i;
        }
        return count;
    }

    public String getBlockText(int type) {
        int i = 0;
        while (this.isSeparator(i) || this.getType(i) != type) {
            ++i;
        }
        String str = this.getClass(i++).getBrowserText();
        while (i < this.getRowCount() && this.getType(i) == type) {
            str = String.valueOf(str) + " & " + this.getClass(i++).getBrowserText();
        }
        return str;
    }

    public int getClassRow(RDFSClass cls) {
        if (cls != null) {
            int row = 0;
            for (ConditionsTableItem item : this.items) {
                if (item != null && cls.equals(item.aClass)) {
                    return row;
                }
                ++row;
            }
        }
        return -1;
    }

    public RDFSClass getClass(int row) {
        ConditionsTableItem item = this.getItem(row);
        if (item != null) {
            return item.aClass;
        }
        return null;
    }

    public int getColumnCount() {
        return 1;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        return null;
    }

    public OWLIntersectionClass getDefinition(int rowIndex) {
        return this.getItem(rowIndex).getDefinition();
    }

    public OWLNamedClass getEditedCls() {
        return this.hostClass;
    }

    public Icon getIcon(RDFResource resource) {
        return ProtegeUI.getIcon(resource);
    }

    public Icon getIcon(int rowIndex, int rowHeight) {
        return this.getItem(rowIndex).getIcon(rowHeight);
    }

    private ConditionsTableItem getItem(int rowIndex) {
        return (ConditionsTableItem)this.items.get(rowIndex);
    }

    private Collection getNamedDefinitionClses(boolean allowDirectSuperclasses) {
        HashSet<Cls> result = new HashSet<Cls>();
        for (RDFSClass aClass : this.hostClass.getEquivalentClasses()) {
            if (aClass instanceof OWLIntersectionClass) {
                for (Cls operand : ((OWLIntersectionClass)aClass).getOperands()) {
                    if (!(operand instanceof OWLNamedClass)) continue;
                    result.add(operand);
                }
                continue;
            }
            if (!(aClass instanceof OWLNamedClass) || !allowDirectSuperclasses) continue;
            result.add(aClass);
        }
        return result;
    }

    public OWLNamedClass getOriginClass(int rowIndex) {
        return this.getItem(rowIndex).getOriginCls();
    }

    public RDFProperty getPredicate(int row) {
        if (row == 0 || row >= 0 && this.isDefinition(row)) {
            return this.owlModel.getOWLEquivalentClassProperty();
        }
        return this.owlModel.getRDFSSubClassOfProperty();
    }

    public RDFResource getRDFResource(int row) {
        return this.getClass(row);
    }

    public RDFResource getSubject() {
        return this.hostClass;
    }

    public int getSymbolColumnIndex() {
        return 0;
    }

    public int getRowCount() {
        return this.items.size();
    }

    public int getType(int rowIndex) {
        ConditionsTableItem item = this.getItem(rowIndex);
        if (item != null) {
            return item.getType();
        }
        return -1;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        ConditionsTableItem item = this.getItem(rowIndex);
        if (columnIndex == 0) {
            return item.toString();
        }
        return null;
    }

    private void handleDuplicateEntry(RDFSClass newClass) {
        this.displaySemanticError("The class " + newClass.getBrowserText() + " is already in the list.");
        if (newClass instanceof OWLAnonymousClass) {
            newClass.delete();
        }
    }

    public boolean isAddEnabledAt(int rowIndex) {
        if (!this.owlModel.getOWLThingClass().equals(this.getEditedCls())) {
            int type = this.getType(rowIndex);
            if (type == -1) {
                return true;
            }
            if (type != -2) {
                OWLIntersectionClass ic = this.getDefinition(rowIndex);
                if (ic != null) {
                    return ic.isEditable();
                }
                RDFSClass c = this.getClass(rowIndex);
                if (c == null) {
                    return this.isAddEnabledAt(rowIndex + 1);
                }
                return this.owlModel.getTripleStoreModel().isActiveTriple(this.getEditedCls(), this.owlModel.getOWLEquivalentClassProperty(), c);
            }
        }
        return false;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0 && !this.isSeparator(rowIndex) && !this.getItem(rowIndex).isInherited() && this.superclassesSlot.getName().equals(":DIRECT-SUPERCLASSES")) {
            RDFSClass cls = this.getClass(rowIndex);
            if (cls == null) {
                return true;
            }
            if (this.isCreateEnabledAt(rowIndex)) {
                if (cls instanceof OWLAnonymousClass) {
                    return cls.isEditable();
                }
                return true;
            }
        }
        return false;
    }

    public boolean isCreateEnabledAt(int row) {
        if (this.isDefinition(row)) {
            OWLIntersectionClass ic = this.getDefinition(row);
            if (ic != null) {
                return ic.isEditable();
            }
            RDFSClass cls = this.getClass(row);
            if (cls == null) {
                return this.isCreateEnabledAt(row + 1);
            }
            return this.owlModel.getTripleStoreModel().isActiveTriple(this.getEditedCls(), this.owlModel.getOWLEquivalentClassProperty(), cls);
        }
        return this.getType(row) == -1;
    }

    public boolean isDeleteEnabledFor(RDFSClass cls) {
        int rowIndex = this.getClassRow(cls);
        if (cls instanceof OWLAnonymousClass) {
            if (!this.isSeparator(rowIndex)) {
                return this.isCellEditable(rowIndex, 0);
            }
            return false;
        }
        return this.isRemoveEnabledFor(rowIndex);
    }

    public boolean isDefinition(int rowIndex) {
        return this.getItem(rowIndex).isDefinition();
    }

    public boolean isEditable() {
        return this.hostClass.isEditable();
    }

    public boolean isRemoveEnabledFor(int rowIndex) {
        RDFSClass superClass;
        if (!this.isSeparator(rowIndex) && (superClass = this.getClass(rowIndex)) instanceof RDFSNamedClass) {
            HashSet nss;
            OWLIntersectionClass ic;
            if (this.getItem(rowIndex).isDefinition() && (ic = this.getDefinition(rowIndex)) != null) {
                return ic.isEditable();
            }
            OWLNamedClass editedClass = this.getEditedCls();
            if ((this.owlModel.getTripleStoreModel().isEditableTriple(editedClass, this.owlModel.getRDFSSubClassOfProperty(), superClass) || this.owlModel.getTripleStoreModel().isEditableTriple(editedClass, this.owlModel.getOWLEquivalentClassProperty(), superClass)) && (nss = new HashSet(this.hostClass.getNamedSuperclasses())).contains(superClass)) {
                nss.remove(superClass);
                return nss.size() > 0 || !this.owlModel.getOWLThingClass().equals(superClass);
            }
        }
        return false;
    }

    public boolean isSeparator(int rowIndex) {
        return this.getItem(rowIndex).isSeparator();
    }

    private void refill() {
        this.items.clear();
        this.removeListeners();
        this.fillItems();
        this.fireTableDataChanged();
    }

    public void refresh() {
        this.items.clear();
        if (this.hostClass != null) {
            this.fillItems();
            this.fireTableDataChanged();
        }
    }

    public void removeEmptyRow() {
        int i = this.getRowCount() - 1;
        while (i >= 0) {
            if (this.getItem(i).isNew()) {
                this.items.remove(i);
                this.fireTableRowsDeleted(i, i);
            }
            --i;
        }
        this.updateLocalIndices();
    }

    private void removeListeners() {
        for (RDFSClass cls : this.listenedToClses) {
            cls.removeClassListener(this.classListener);
            cls.removeFrameListener(this.frameListener);
        }
        this.listenedToClses.clear();
    }

    private void replaceItemType(int oldType, int newType) {
        for (ConditionsTableItem item : this.items) {
            if (item.getType() != oldType) continue;
            item.setType(newType);
        }
    }

    public void setCls(OWLNamedClass cls) {
        if (this.hostClass == null || !this.hostClass.equals(cls)) {
            if (this.hostClass != null) {
                this.hostClass.removeClassListener(this.classListener);
                this.hostClass.removeFrameListener(this.frameListener);
            }
            this.hostClass = cls;
            if (this.hostClass != null) {
                this.hostClass.addClassListener(this.classListener);
                this.hostClass.addFrameListener(this.frameListener);
            }
            this.refresh();
        }
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount()) {
            return;
        }
        if (columnIndex == 0) {
            String text = (String)value;
            OWLModel owlModel = this.hostClass.getOWLModel();
            try {
                this.setValueAt(rowIndex, owlModel, text);
            }
            catch (Exception ex) {
                Log.emptyCatchBlock((Throwable)ex);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValueAt(int rowIndex, OWLModel owlModel, String parsableText) throws Exception {
        RDFSClass newClass;
        block29: {
            owlModel.beginTransaction("Set condition at " + this.getEditedCls().getBrowserText() + " to " + parsableText);
            OWLClassParser parser = owlModel.getOWLClassDisplay().getParser();
            newClass = parser.parseClass(owlModel, parsableText);
            if (!this.getEditedCls().equals(newClass)) break block29;
            return;
        }
        try {
            try {
                String newBrowserText = newClass.getBrowserText();
                RDFSClass oldClass = this.getClass(rowIndex);
                Slot directSuperclassesSlot = owlModel.getSlot(":DIRECT-SUPERCLASSES");
                if (oldClass == null) {
                    if (((AbstractRDFSClass)((Object)this.hostClass)).hasPropertyValueWithBrowserText(directSuperclassesSlot, newBrowserText)) {
                        this.handleDuplicateEntry(newClass);
                        return;
                    }
                    this.items.remove(rowIndex);
                    this.previouslyEditedCls = newClass;
                    if (this.addRow(newClass, rowIndex - 1) || !(newClass instanceof OWLAnonymousClass)) return;
                    newClass.delete();
                    return;
                }
                if (!oldClass.getBrowserText().equals(newBrowserText)) {
                    if (((AbstractRDFSClass)((Object)this.hostClass)).hasPropertyValueWithBrowserText(directSuperclassesSlot, newBrowserText)) {
                        this.handleDuplicateEntry(newClass);
                        return;
                    }
                    int type = this.getType(rowIndex);
                    if (type == -1) {
                        this.hostClass.addSuperclass(newClass);
                        if (oldClass != null) {
                            this.hostClass.removeSuperclass(oldClass);
                        }
                    } else {
                        DefaultOWLIntersectionClass definition = (DefaultOWLIntersectionClass)this.getDefinition(rowIndex);
                        if (definition != null) {
                            if (definition.hasOperandWithBrowserText(newBrowserText)) {
                                this.handleDuplicateEntry(newClass);
                                return;
                            }
                            OWLIntersectionClass copy = owlModel.createOWLIntersectionClass();
                            for (RDFSClass operand : definition.getOperands()) {
                                if (operand.equals(oldClass)) {
                                    copy.addOperand(newClass);
                                    continue;
                                }
                                copy.addOperand(operand.createClone());
                            }
                            if (oldClass == null) {
                                copy.addOperand(newClass);
                            } else if (oldClass instanceof RDFSNamedClass) {
                                this.hostClass.removeSuperclass(oldClass);
                            }
                            this.hostClass.addEquivalentClass(copy);
                            definition.delete();
                            if (newClass instanceof RDFSNamedClass) {
                                this.hostClass.addSuperclass(newClass);
                            }
                        } else {
                            this.hostClass.addEquivalentClass(newClass);
                            if (oldClass != null) {
                                this.hostClass.removeSuperclass(oldClass);
                                if (oldClass instanceof RDFSNamedClass && oldClass.isSubclassOf(this.hostClass)) {
                                    oldClass.removeSuperclass(this.hostClass);
                                    if (oldClass.getNamedSuperclasses().isEmpty()) {
                                        oldClass.addSuperclass(owlModel.getOWLThingClass());
                                    }
                                }
                            }
                            if (newClass instanceof OWLIntersectionClass) {
                                for (RDFSClass operand : ((OWLIntersectionClass)newClass).getOperands()) {
                                    if (!(operand instanceof RDFSNamedClass) || this.hostClass.isSubclassOf(operand)) continue;
                                    this.hostClass.addSuperclass(operand);
                                }
                            }
                        }
                    }
                    if (!this.hostClass.hasNamedSuperclass()) {
                        this.hostClass.addSuperclass(owlModel.getOWLThingClass());
                    }
                    this.previouslyEditedCls = newClass;
                    return;
                }
                if (!(newClass instanceof OWLAnonymousClass)) return;
                newClass.delete();
                return;
            }
            catch (Exception ex) {
                OWLUI.handleError(owlModel, ex);
            }
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            owlModel.endTransaction();
        }
    }

    private void sortItems() {
        Collections.sort(this.items);
        this.updateLocalIndices();
    }

    private void sortSufficientBlocks(List separators) {
        boolean changed = false;
        do {
            changed = false;
            int i = 0;
            while (i < separators.size() - 1) {
                ConditionsTableItem separatorB;
                int indexB;
                ConditionsTableItem b;
                ConditionsTableItem separatorA = (ConditionsTableItem)separators.get(i);
                int indexA = this.items.indexOf(separatorA);
                ConditionsTableItem a = this.getItem(indexA + 1);
                if (a.compareToWithSameType((b = this.getItem((indexB = this.items.indexOf(separatorB = (ConditionsTableItem)separators.get(i + 1))) + 1)).getCls()) < 0) {
                    changed = true;
                    this.swapBlocks(separatorA, separatorB);
                    separators.remove(separatorB);
                    separators.add(i, separatorB);
                }
                ++i;
            }
        } while (changed);
    }

    private void swapBlocks(ConditionsTableItem separatorA, ConditionsTableItem separatorB) {
        int typeA = separatorA.getType();
        int typeB = separatorB.getType();
        this.replaceItemType(typeA, -10);
        this.replaceItemType(typeB, typeA);
        this.replaceItemType(-10, typeB);
        this.sortItems();
    }

    private void updateLocalIndices() {
        int row = 0;
        for (ConditionsTableItem item : this.items) {
            if (item.isSeparator()) {
                this.updateLocalIndices(row + 1);
            }
            ++row;
        }
    }

    private void updateLocalIndices(int startRow) {
        int i = startRow;
        while (i < this.items.size() && !this.getItem(i).isSeparator()) {
            this.getItem(i).setLocalIndex(i - startRow);
            ++i;
        }
    }
}

