/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.importstree;

import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLOntology;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.model.util.ImportHelper;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.importstree.DownloadImportsAction;
import edu.stanford.smi.protegex.owl.ui.importstree.ImportsTree;
import edu.stanford.smi.protegex.owl.ui.importstree.ImportsTreeNode;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.emptyimport.EmptyImportWizard;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.AddedPrefixesTable;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.ImportEntry;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.ImportWizard;
import edu.stanford.smi.protegex.owl.ui.results.HostResourceDisplay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;

public class ImportsTreePanel
extends JPanel
implements HostResourceDisplay,
Disposable {
    private ImportsTree tree;
    private OWLOntology rootOntology;

    public ImportsTreePanel(OWLOntology rootOntology) {
        this.rootOntology = rootOntology;
        this.tree = new ImportsTree(rootOntology);
        OWLLabeledComponent lc = new OWLLabeledComponent("Ontologies", new JScrollPane((Component)((Object)this.tree)));
        lc.addHeaderButton(this.createAddImportAction());
        lc.addHeaderButton(this.createAddEmptyImportAction());
        lc.addHeaderButton(this.createRemoveImportAction());
        lc.addHeaderButton(this.createSetActiveOntologyAction());
        lc.addHeaderButton(new DownloadImportsAction(this.tree));
        this.setLayout(new BorderLayout());
        this.add("North", (Component)this.createOntologyBrowserHeader());
        this.add("Center", (Component)((Object)lc));
        this.setPreferredSize(new Dimension(250, 300));
    }

    private Action createAddEmptyImportAction() {
        return new AllowableAction("Create empty imported ontology...", OWLIcons.getCreateIcon("Import"), (Selectable)this.tree){

            public void actionPerformed(ActionEvent e) {
                ImportsTreePanel.this.createImportedTripleStore();
            }

            public void onSelectionChange() {
                Collection sel = this.getSelection();
                RDFResource ont = (RDFResource)CollectionUtilities.getFirstItem((Collection)sel);
                this.setAllowed(ont != null && ont instanceof OWLOntology && ont == OWLUtil.getActiveOntology(ont.getOWLModel()));
            }
        };
    }

    private Action createAddImportAction() {
        return new AllowableAction("Import ontology...", OWLIcons.getAddIcon("Import"), (Selectable)this.tree){

            public void actionPerformed(ActionEvent e) {
                ImportsTreePanel.this.addImport();
            }

            public void onSelectionChange() {
                Collection sel = this.getSelection();
                RDFResource ont = (RDFResource)CollectionUtilities.getFirstItem((Collection)sel);
                this.setAllowed(ont != null && ont instanceof OWLOntology && ont == OWLUtil.getActiveOntology(ont.getOWLModel()));
            }
        };
    }

    private Action createRemoveImportAction() {
        return new AllowableAction("Remove import", OWLIcons.getRemoveIcon("Import"), (Selectable)this.tree){

            public void actionPerformed(ActionEvent e) {
                ImportsTreePanel.this.removeSelectedImport();
            }

            public void onSelectionChange() {
                this.setAllowed(ImportsTreePanel.this.tree.getSelectionCount() == 1);
            }
        };
    }

    private Action createSetActiveOntologyAction() {
        return new AllowableAction("Set active ontology", OWLIcons.getImageIcon("SelectActiveTripleStore"), (Selectable)this.tree){

            public void actionPerformed(ActionEvent e) {
                ImportsTreePanel.this.setActiveOntology();
            }

            public void onSelectionChange() {
                Collection sel = this.getSelection();
                RDFResource ont = (RDFResource)CollectionUtilities.getFirstItem((Collection)sel);
                this.setAllowed(sel.size() == 1 && ont instanceof DefaultOWLOntology && ((DefaultOWLOntology)ont).isAssociatedTriplestoreEditable());
            }
        };
    }

    protected HeaderComponent createOntologyBrowserHeader() {
        String projName = ProjectManager.getProjectManager().getCurrentProject().getName();
        JLabel label = ComponentFactory.createLabel((String)projName, (Icon)Icons.getProjectIcon(), (int)2);
        String forProject = LocalizedText.getText((ResourceKey)ResourceKey.CLASS_BROWSER_FOR_PROJECT_LABEL);
        String classBrowser = "Ontology Browser";
        HeaderComponent headerComponent = new HeaderComponent(classBrowser, forProject, (JComponent)label);
        headerComponent.setColor(Colors.getFacetColor());
        return headerComponent;
    }

    public static void showDialog(OWLModel owlModel) {
        OWLOntology ontology = owlModel.getDefaultOWLOntology();
        ImportsTreePanel panel = new ImportsTreePanel(ontology);
        Component parent = ProtegeUI.getTopLevelContainer(owlModel.getProject());
        ProtegeUI.getModalDialogFactory().showDialog(parent, panel, "owl:imports Between Ontologies", 14);
    }

    public boolean displayHostResource(RDFResource resource) {
        return this.tree.displayHostResource(resource);
    }

    public ImportsTree getImportsTree() {
        return this.tree;
    }

    private void addImport() {
        try {
            OWLModel owlModel = this.rootOntology.getOWLModel();
            ImportWizard wizard = new ImportWizard((JComponent)this, owlModel);
            if (wizard.execute() == 1) {
                ImportHelper importHelper = new ImportHelper((JenaOWLModel)owlModel);
                ArrayList prefixes = new ArrayList(owlModel.getNamespaceManager().getPrefixes());
                for (ImportEntry importEntry : wizard.getImportData().getImportEntries()) {
                    Repository rep = importEntry.getRepositoryToAdd();
                    if (rep != null) {
                        owlModel.getRepositoryManager().addProjectRepository(importEntry.getRepository());
                    }
                    URI ontologyURI = importEntry.getOntologyURI();
                    importHelper.addImport(ontologyURI);
                }
                importHelper.importOntologies();
                ArrayList addedPrefixes = new ArrayList(owlModel.getNamespaceManager().getPrefixes());
                addedPrefixes.removeAll(prefixes);
                if (addedPrefixes.size() > 0) {
                    Component topLevelContainer = ProtegeUI.getTopLevelContainer(owlModel.getProject());
                    AddedPrefixesTable.showDialog(topLevelContainer, owlModel, addedPrefixes);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removeSelectedImport() {
        RDFResource sel = (RDFResource)CollectionUtilities.getFirstItem((Collection)this.tree.getSelectedResources());
        if (sel != null && OWLUtil.confirmSaveAndReload(this.rootOntology.getProject())) {
            String uri = sel.getURI();
            TreePath path = this.tree.getSelectionModel().getSelectionPath();
            ImportsTreeNode parentNode = (ImportsTreeNode)((Object)path.getParentPath().getLastPathComponent());
            OWLOntology importingOntology = (OWLOntology)parentNode.getUserObject();
            importingOntology.removeImports(uri);
            OWLUtil.saveAndReloadProject();
        }
    }

    private void createImportedTripleStore() {
        EmptyImportWizard wizard = new EmptyImportWizard((JComponent)this, this.rootOntology.getOWLModel());
        wizard.execute();
    }

    private void setActiveOntology() {
        OWLModel owlModel;
        Collection sel = this.tree.getSelection();
        OWLOntology ont = (OWLOntology)CollectionUtilities.getFirstItem((Collection)sel);
        if (ont != OWLUtil.getActiveOntology(owlModel = ont.getOWLModel())) {
            TripleStoreModel tsm = owlModel.getTripleStoreModel();
            TripleStore tripleStore = tsm.getHomeTripleStore(ont);
            TripleStoreUtil.switchTripleStore(owlModel, tripleStore);
        }
    }

    public void dispose() {
        this.tree.dispose();
    }
}

