/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix.property;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixFilter;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixPanel;
import edu.stanford.smi.protegex.owl.ui.matrix.property.PropertyMatrixTableModel;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;

public class SubpropertiesMatrixAction
extends ResourceAction {
    public SubpropertiesMatrixAction() {
        super("Show list of subproperties", OWLIcons.getImageIcon("PropertyMatrix"), "Search and View/");
    }

    public void actionPerformed(ActionEvent e) {
        OWLModel owlModel = this.getOWLModel();
        final RDFProperty parentProperty = (RDFProperty)this.getResource();
        MatrixFilter filter = new MatrixFilter(){

            public Collection getInitialValues() {
                ArrayList results = new ArrayList();
                for (Object next : parentProperty.getSubproperties(true)) {
                    if (!(next instanceof RDFProperty)) continue;
                    results.add(next);
                }
                results.remove(parentProperty);
                return results;
            }

            public String getName() {
                return "Subproperties of " + parentProperty.getBrowserText();
            }

            public boolean isSuitable(RDFResource instance) {
                return instance instanceof RDFProperty && instance.isVisible() && (instance.isEditable() || instance.isIncluded()) && ((RDFProperty)instance).isSubpropertyOf(parentProperty, true);
            }
        };
        MatrixPanel panel = new MatrixPanel(owlModel, filter, new PropertyMatrixTableModel(owlModel, filter));
        ResultsPanelManager.addResultsPanel(owlModel, panel, true);
    }

    public boolean isSuitable(Component component, RDFResource resource) {
        return resource instanceof RDFProperty;
    }
}

