/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search;

import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanel;
import edu.stanford.smi.protegex.owl.ui.search.FindUsage;
import edu.stanford.smi.protegex.owl.ui.search.FindUsageTableModel;
import edu.stanford.smi.protegex.owl.ui.search.FindUsageTableModelColumns;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FindUsagePanel
extends ResultsPanel
implements FindUsageTableModelColumns {
    private ModelListener listener = new ModelAdapter(){

        public void classDeleted(RDFSClass cls) {
            if (FindUsagePanel.this.searchResource.equals(cls)) {
                FindUsagePanel.this.close();
            }
        }

        public void individualDeleted(RDFResource resource) {
            if (FindUsagePanel.this.searchResource.equals(resource)) {
                FindUsagePanel.this.close();
            }
        }

        public void propertyDeleted(RDFProperty property) {
            if (FindUsagePanel.this.searchResource.equals(property)) {
                FindUsagePanel.this.close();
            }
        }
    };
    private OWLModel owlModel;
    private RDFResource searchResource;
    private FindUsageTableModel tableModel;
    private JTable table;
    private Action refreshAction = new AbstractAction("Refresh", OWLIcons.getImageIcon("Refresh")){

        public void actionPerformed(ActionEvent e) {
            FindUsagePanel.this.refresh();
        }
    };
    private Action viewAction = new AbstractAction("View resource", OWLIcons.getViewIcon()){

        public void actionPerformed(ActionEvent e) {
            FindUsagePanel.this.viewSelectedHostCls();
        }
    };

    public FindUsagePanel(RDFResource searchResource, Collection items) {
        super(searchResource.getOWLModel());
        this.searchResource = searchResource;
        this.owlModel = searchResource.getOWLModel();
        this.owlModel.addModelListener(this.listener);
        this.tableModel = new FindUsageTableModel(this.owlModel, items);
        this.table = new JTable(this.tableModel);
        this.table.setRowHeight(this.getFontMetrics(this.getFont()).getHeight());
        this.table.setAutoResizeMode(3);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setShowGrid(false);
        this.table.setRowMargin(0);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                FindUsagePanel.this.enableActions();
            }
        });
        this.updateColumns();
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && FindUsagePanel.this.viewAction.isEnabled()) {
                    FindUsagePanel.this.viewAction.actionPerformed(null);
                }
            }
        });
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int viewColumn;
                JTableHeader h = (JTableHeader)e.getSource();
                TableColumnModel columnModel = h.getColumnModel();
                int column = columnModel.getColumn(viewColumn = columnModel.getColumnIndexAtX(e.getX())).getModelIndex();
                if (column != -1) {
                    FindUsagePanel.this.tableModel.setSortColumn(column);
                    FindUsagePanel.this.updateColumns();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.getViewport().setBackground(this.table.getBackground());
        this.viewAction.setEnabled(false);
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setLayout(new BoxLayout(northPanel, 0));
        northPanel.add(new JLabel("Usage of "));
        JLabel headerLabel = new JLabel(searchResource.getBrowserText());
        headerLabel.setIcon(ProtegeUI.getIcon(searchResource));
        northPanel.add(headerLabel);
        this.addButton(this.refreshAction);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add("North", northPanel);
        mainPanel.add("Center", scrollPane);
        this.setCenterComponent(mainPanel);
    }

    public static FindUsagePanel create(RDFResource searchInstance) {
        Collection items = FindUsage.getItems(searchInstance);
        return new FindUsagePanel(searchInstance, items);
    }

    public void dispose() {
        this.owlModel.removeModelListener(this.listener);
        this.tableModel.dispose();
    }

    private void enableActions() {
        this.viewAction.setEnabled(this.table.getSelectedRow() >= 0);
    }

    public Icon getIcon() {
        return OWLIcons.getFindUsageIcon();
    }

    public String getTabName() {
        return "Usage of " + this.searchResource.getBrowserText();
    }

    private void refresh() {
        this.tableModel.setItems(FindUsage.getItems(this.searchResource));
    }

    private void updateColumns() {
        this.table.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)((Object)new ResourceRenderer()));
        this.table.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)((Object)new ResourceRenderer()));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(60);
        TableColumn typeColumn = this.table.getColumnModel().getColumn(1);
        typeColumn.setPreferredWidth(64);
        typeColumn.setMaxWidth(64);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(300);
    }

    private void viewSelectedHostCls() {
        int row = this.table.getSelectedRow();
        RDFResource usage = this.tableModel.getUsage(row);
        if (usage instanceof OWLAnonymousClass) {
            this.showHostResource(usage);
        } else {
            RDFResource hostResource = this.tableModel.getHost(row);
            this.showHostResource(hostResource);
        }
    }
}

