/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owlx.examples;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.widget.AbstractTabWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class TutorialTabWidget
extends AbstractTabWidget {
    private JList list;

    public void initialize() {
        this.setLabel("Tutorial-Tab");
        this.setShortDescription("A simple demo tab that displays the recently added classes");
        this.list = new JList();
        this.list.setCellRenderer(new FrameRenderer());
        LabeledComponent lc = new LabeledComponent("Added Classes", new JScrollPane(this.list));
        lc.addHeaderButton((Action)new AbstractAction("View selected class", Icons.getViewIcon()){

            public void actionPerformed(ActionEvent e) {
                TutorialTabWidget.this.viewSelectedCls();
            }
        });
        this.add("Center", (Component)lc);
        OWLModel owlModel = (OWLModel)this.getKnowledgeBase();
        owlModel.addModelListener(new ModelAdapter(){

            public void classCreated(RDFSClass cls) {
                TutorialTabWidget.this.addListEntry(cls);
            }
        });
    }

    private void addListEntry(RDFSClass cls) {
        if (cls instanceof RDFSNamedClass) {
            Vector values = new Vector();
            int i = 0;
            while (i < this.list.getModel().getSize()) {
                values.add(this.list.getModel().getElementAt(i));
                ++i;
            }
            values.add(cls);
            this.list.setListData(values);
        }
    }

    private void viewSelectedCls() {
        RDFSNamedClass selectedClass = (RDFSNamedClass)this.list.getSelectedValue();
        if (selectedClass != null) {
            this.getProject().show((Instance)selectedClass);
        }
    }
}

