/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.query.Dyadic;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.PatternLiteral;

public class Rewrite {
    public static Expression rewriteStringMatch(Expression expression) {
        Expression expression2 = expression.getArg(0);
        Expression expression3 = expression.getArg(1);
        PatternLiteral patternLiteral = Rewrite.getPattern(expression3);
        if (patternLiteral == null) {
            return expression;
        }
        if (Rewrite.isStartsWith(patternLiteral)) {
            return Rewrite.startsWith(expression2, patternLiteral.getPatternString().substring(1), patternLiteral.getPatternModifiers());
        }
        if (Rewrite.isContains(patternLiteral)) {
            return Rewrite.contains(expression2, patternLiteral.getPatternString(), patternLiteral.getPatternModifiers());
        }
        if (Rewrite.isEndsWith(patternLiteral)) {
            return Rewrite.endsWith(expression2, Rewrite.front(patternLiteral.getPatternString()), patternLiteral.getPatternModifiers());
        }
        return expression;
    }

    protected static String front(String string) {
        return string.substring(0, string.length() - 1);
    }

    public static PatternLiteral getPattern(Expression expression) {
        PatternLiteral patternLiteral;
        if (expression instanceof PatternLiteral && (patternLiteral = (PatternLiteral)((Object)expression)).getPatternLanguage().equals("http://jena.hpl.hp.com/2003/07/query/RDQL")) {
            return patternLiteral;
        }
        return null;
    }

    public static Expression endsWith(Expression expression, String string, String string2) {
        if (string2.equals("i")) {
            return new DyadicLower(expression, "urn:x-jena:expr:J_endsWithInsensitive", string){

                public boolean evalBool(String string, String string2) {
                    return string.toLowerCase().endsWith(string2);
                }
            };
        }
        return new DyadicLiteral(expression, "urn:x-jena:expr:J_endsWith", string){

            public boolean evalBool(String string, String string2) {
                return string.endsWith(string2);
            }
        };
    }

    public static Expression startsWith(Expression expression, String string, String string2) {
        if (string2.equals("i")) {
            return new DyadicLower(expression, "urn:x-jena:expr:J_startsWithInsensitive", string){

                public boolean evalBool(String string, String string2) {
                    return string.toLowerCase().startsWith(string2);
                }
            };
        }
        return new DyadicLiteral(expression, "urn:x-jena:expr:J_startsWith", string){

            public boolean evalBool(String string, String string2) {
                return string.startsWith(string2);
            }
        };
    }

    public static Expression contains(Expression expression, String string, String string2) {
        if (string2.equals("i")) {
            return new DyadicLower(expression, "urn:x-jena:expr:J_containsInsensitive", string){

                public boolean evalBool(String string, String string2) {
                    return string.toLowerCase().indexOf(string2) > -1;
                }
            };
        }
        return new DyadicLiteral(expression, "urn:x-jena:expr:J_contains", string){

            public boolean evalBool(String string, String string2) {
                return string.indexOf(string2) > -1;
            }
        };
    }

    public static boolean notSpecial(String string) {
        return string.matches("[A-Za-z0-9-_:/ ]*");
    }

    public static boolean isContains(PatternLiteral patternLiteral) {
        return Rewrite.notSpecial(patternLiteral.getPatternString()) && Rewrite.iOnly(patternLiteral.getPatternModifiers());
    }

    protected static boolean iOnly(String string) {
        return string.equals("") || string.equals("i");
    }

    public static boolean isStartsWith(PatternLiteral patternLiteral) {
        String string = patternLiteral.getPatternString();
        return string.startsWith("^") && Rewrite.notSpecial(string.substring(1));
    }

    public static boolean isEndsWith(PatternLiteral patternLiteral) {
        String string = patternLiteral.getPatternString();
        return string.endsWith("$") && Rewrite.notSpecial(string.substring(0, string.length() - 1));
    }

    public static abstract class DyadicLower
    extends DyadicLiteral {
        public DyadicLower(Expression expression, String string, String string2) {
            super(expression, string, string2.toLowerCase());
        }
    }

    public static abstract class DyadicLiteral
    extends Dyadic {
        public DyadicLiteral(Expression expression, String string, String string2) {
            super(expression, string, new Expression.Fixed(string2));
        }

        public boolean evalBool(Object object, Object object2) {
            return this.evalBool(object.toString(), object2.toString());
        }

        protected abstract boolean evalBool(String var1, String var2);
    }
}

