/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.graph.impl.FileGraph;
import com.hp.hpl.jena.graph.impl.FileGraphMaker;
import com.hp.hpl.jena.graph.test.AbstractTestGraphMaker;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.FileUtils;
import java.io.File;
import junit.framework.TestSuite;

public class TestFileGraphMaker
extends AbstractTestGraphMaker {
    public TestFileGraphMaker(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestFileGraphMaker.class);
    }

    public GraphMaker getGraphMaker() {
        String string = FileUtils.getScratchDirectory("jena-test-FileGraphMaker").getPath();
        return new FileGraphMaker(string, ReificationStyle.Minimal, true);
    }

    public void testToFilename() {
        TestFileGraphMaker.assertEquals((String)"plain", (String)FileGraphMaker.toFilename("plain"));
        TestFileGraphMaker.assertEquals((String)"with_Sslash", (String)FileGraphMaker.toFilename("with/slash"));
        TestFileGraphMaker.assertEquals((String)"with_Ccolon", (String)FileGraphMaker.toFilename("with:colon"));
        TestFileGraphMaker.assertEquals((String)"with_Uunderbar", (String)FileGraphMaker.toFilename("with_underbar"));
        TestFileGraphMaker.assertEquals((String)"with_Stwo_Sslashes", (String)FileGraphMaker.toFilename("with/two/slashes"));
        TestFileGraphMaker.assertEquals((String)"with_Sa_Cmixture_U...", (String)FileGraphMaker.toFilename("with/a:mixture_..."));
    }

    public void testToGraphname() {
        TestFileGraphMaker.assertEquals((String)"plain", (String)FileGraphMaker.toGraphname("plain"));
        TestFileGraphMaker.assertEquals((String)"with/slash", (String)FileGraphMaker.toGraphname("with_Sslash"));
        TestFileGraphMaker.assertEquals((String)"with:colon", (String)FileGraphMaker.toGraphname("with_Ccolon"));
        TestFileGraphMaker.assertEquals((String)"with_underbar", (String)FileGraphMaker.toGraphname("with_Uunderbar"));
        TestFileGraphMaker.assertEquals((String)"a/mixture_of:things", (String)FileGraphMaker.toGraphname("a_Smixture_Uof_Cthings"));
        TestFileGraphMaker.assertEquals((String)"with/two/slashes", (String)FileGraphMaker.toGraphname("with_Stwo_Sslashes"));
    }

    public void testDetectsExistingFiles() {
        File file = FileUtils.getScratchDirectory("jena-test-FileGraphMaker-already");
        Graph graph = TestFileGraphMaker.graphWith("something hasProperty someValue");
        FileGraphMaker fileGraphMaker = new FileGraphMaker(file.getPath());
        FileGraphMaker fileGraphMaker2 = new FileGraphMaker(file.getPath());
        FileGraph fileGraph = (FileGraph)fileGraphMaker.createGraph("already", true);
        fileGraph.getBulkUpdateHandler().add(graph);
        fileGraph.close();
        FileGraph fileGraph2 = (FileGraph)fileGraphMaker2.openGraph("already", false);
        TestFileGraphMaker.assertIsomorphic(graph, fileGraph2);
        fileGraph2.close();
        fileGraph2.delete();
        fileGraph.delete();
    }
}

