/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.NodeIteratorImpl;
import com.hp.hpl.jena.rdf.model.impl.ResIteratorImpl;
import com.hp.hpl.jena.rdf.model.impl.StatementImpl;
import com.hp.hpl.jena.rdf.model.impl.StmtIteratorImpl;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.Map1Iterator;
import java.util.Iterator;

public final class IteratorFactory {
    private IteratorFactory() {
    }

    public static RDFNode asRDFNode(Node node, Model model) {
        return model.asRDFNode(node);
    }

    public static Statement asStatement(Triple triple, ModelCom modelCom) {
        return StatementImpl.toStatement(triple, modelCom);
    }

    public static StmtIterator asStmtIterator(Iterator iterator, final ModelCom modelCom) {
        return new StmtIteratorImpl(new Map1Iterator(new Map1(){

            public Object map1(Object object) {
                return modelCom.asStatement((Triple)object);
            }
        }, iterator));
    }

    public static ResIterator asResIterator(Iterator iterator, final ModelCom modelCom) {
        return new ResIteratorImpl((Iterator)new Map1Iterator(new Map1(){

            public Object map1(Object object) {
                return modelCom.asRDFNode((Node)object);
            }
        }, iterator), null);
    }

    public static NodeIterator asRDFNodeIterator(Iterator iterator, final ModelCom modelCom) {
        return new NodeIteratorImpl((Iterator)new Map1Iterator(new Map1(){

            public Object map1(Object object) {
                return modelCom.asRDFNode((Node)object);
            }
        }, iterator), null);
    }

    static Resource asResource(Node node, ModelCom modelCom) {
        return IteratorFactory.asResource(node, Resource.class, modelCom);
    }

    static Property asProperty(Node node, ModelCom modelCom) {
        return (Property)IteratorFactory.asResource(node, Property.class, modelCom);
    }

    static Literal asLiteral(Node node, ModelCom modelCom) {
        return (Literal)((Object)modelCom.getNodeAs(node, Literal.class));
    }

    static Resource asResource(Node node, Class clazz, ModelCom modelCom) {
        return (Resource)((Object)modelCom.getNodeAs(node, clazz));
    }
}

