/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.TripleStore;
import com.hp.hpl.jena.mem.NodeToTriplesMap;
import com.hp.hpl.jena.mem.StoreTripleIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;

public class GraphTripleStore
implements TripleStore {
    protected NodeToTriplesMap subjects = new NodeToTriplesMap(){

        public Node getIndexNode(Triple triple) {
            return triple.getSubject();
        }
    };
    protected NodeToTriplesMap predicates = new NodeToTriplesMap(){

        public Node getIndexNode(Triple triple) {
            return triple.getPredicate();
        }
    };
    protected NodeToTriplesMap objects = new NodeToTriplesMap(){

        public Node getIndexNode(Triple triple) {
            return triple.getObject();
        }
    };
    protected Graph parent;

    public GraphTripleStore(Graph graph) {
        this.parent = graph;
    }

    public void close() {
        this.objects = null;
        this.predicates = null;
        this.subjects = null;
    }

    public void add(Triple triple) {
        if (this.subjects.add(triple.getSubject(), triple)) {
            this.predicates.add(triple.getPredicate(), triple);
            this.objects.add(triple.getObject(), triple);
        }
    }

    public void delete(Triple triple) {
        if (this.subjects.remove(triple.getSubject(), triple)) {
            this.predicates.remove(triple.getPredicate(), triple);
            this.objects.remove(triple.getObject(), triple);
        }
    }

    public int size() {
        return this.subjects.size();
    }

    public boolean isEmpty() {
        return this.subjects.isEmpty();
    }

    public ExtendedIterator listSubjects() {
        return WrappedIterator.createNoRemove(this.subjects.domain());
    }

    public ExtendedIterator listPredicates() {
        return WrappedIterator.createNoRemove(this.predicates.domain());
    }

    public ExtendedIterator listObjects() {
        return WrappedIterator.createNoRemove(this.objects.domain());
    }

    public boolean contains(Triple triple) {
        return this.subjects.contains(triple);
    }

    public ExtendedIterator find(TripleMatch tripleMatch) {
        Triple triple = tripleMatch.asTriple();
        Node node = triple.getPredicate();
        Node node2 = triple.getObject();
        Node node3 = triple.getSubject();
        if (node3.isConcrete()) {
            return new StoreTripleIterator(this.parent, this.subjects.iterator(node3, triple), this.predicates, this.objects);
        }
        if (node2.isConcrete() && !node2.isLiteral()) {
            return new StoreTripleIterator(this.parent, this.objects.iterator(node2, triple), this.subjects, this.predicates);
        }
        if (node.isConcrete()) {
            return new StoreTripleIterator(this.parent, this.predicates.iterator(node, triple), this.subjects, this.objects);
        }
        return new StoreTripleIterator(this.parent, this.subjects.iterator(triple), this.predicates, this.objects);
    }

    public void clear() {
        this.subjects.clear();
        this.predicates.clear();
        this.objects.clear();
    }
}

