/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl;

import edu.stanford.smi.protege.Application;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;

public class ProtegeOWL {
    public static String PLUGIN_FOLDER = "edu.stanford.smi.protegex.owl";

    public static JenaOWLModel createJenaOWLModel() {
        JenaKnowledgeBaseFactory factory = new JenaKnowledgeBaseFactory();
        ArrayList errors = new ArrayList();
        Project project = Project.createNewProject((KnowledgeBaseFactory)factory, errors);
        project.setKnowledgeBaseFactory((KnowledgeBaseFactory)factory);
        project.createDomainKnowledgeBase((KnowledgeBaseFactory)factory, errors, false);
        return (JenaOWLModel)project.getKnowledgeBase();
    }

    public static JenaOWLModel createJenaOWLModelFromInputStream(InputStream is) throws Exception {
        JenaOWLModel owlModel = ProtegeOWL.createJenaOWLModel();
        owlModel.load(is, "RDF/XML-ABBREV");
        return owlModel;
    }

    public static JenaOWLModel createJenaOWLModelFromReader(Reader reader) throws Exception {
        JenaOWLModel owlModel = ProtegeOWL.createJenaOWLModel();
        owlModel.load(reader, "RDF/XML-ABBREV");
        return owlModel;
    }

    public static JenaOWLModel createJenaOWLModelFromURI(String uri) throws Exception {
        JenaOWLModel owlModel = ProtegeOWL.createJenaOWLModel();
        owlModel.load(new URI(uri), "RDF/XML-ABBREV");
        return owlModel;
    }

    public static File getPluginFolder() {
        return new File(new File(ApplicationProperties.getApplicationDirectory(), "plugins"), PLUGIN_FOLDER);
    }

    public static void initProject(Project project, String owlFilePath, String language) {
        JenaKnowledgeBaseFactory.setOWLFileLanguage(project.getSources(), language);
        JenaKnowledgeBaseFactory.setOWLFileName(project.getSources(), owlFilePath);
    }

    public static void main(String[] args) {
        Application.main((String[])args);
    }
}

