/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.ArrayList;

public class LoadAxiomsTestCase
extends AbstractJenaTestCase {
    public void testLoadSeanAxiomAnonymous() throws Exception {
        this.loadRemoteOntology("seanAxiomAnonymous.owl");
        ArrayList classes = new ArrayList(this.owlModel.getUserDefinedOWLNamedClasses());
        LoadAxiomsTestCase.assertSize(3, classes);
        classes.remove(this.owlModel.getOWLNamedClass("Plant"));
        classes.remove(this.owlModel.getOWLNamedClass("Animal"));
        LoadAxiomsTestCase.assertSize(1, classes);
        OWLNamedClass axiomClass = (OWLNamedClass)classes.iterator().next();
        LoadAxiomsTestCase.assertNotNull((Object)axiomClass);
        LoadAxiomsTestCase.assertSize(1, axiomClass.getEquivalentClasses());
        RDFSClass definition = axiomClass.getDefinition();
        LoadAxiomsTestCase.assertTrue((boolean)(definition instanceof OWLUnionClass));
        LoadAxiomsTestCase.assertSize(1, axiomClass.getDisjointClasses());
    }

    public void testLoadSeanAxiomNamed() throws Exception {
        this.loadRemoteOntology("seanAxiomNamed.owl");
        LoadAxiomsTestCase.assertSize(3, this.owlModel.getUserDefinedOWLNamedClasses());
        OWLNamedClass axiomClass = this.owlModel.getOWLNamedClass("PlantOrPartOfPlant");
        LoadAxiomsTestCase.assertNotNull((Object)axiomClass);
        LoadAxiomsTestCase.assertSize(1, axiomClass.getEquivalentClasses());
        RDFSClass definition = axiomClass.getDefinition();
        LoadAxiomsTestCase.assertTrue((boolean)(definition instanceof OWLUnionClass));
        LoadAxiomsTestCase.assertSize(1, axiomClass.getDisjointClasses());
    }
}

