/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore.tests;

import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class RDFTypeTestCase
extends AbstractJenaTestCase {
    public void testAddAndRemoveDirectType() {
        OWLNamedClass clsA = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass clsB = this.owlModel.createOWLNamedClass("B");
        OWLIndividual individual = clsA.createOWLIndividual("instance");
        RDFTypeTestCase.assertSize(1, individual.getRDFTypes());
        individual.addProtegeType(clsB);
        RDFTypeTestCase.assertSize(2, individual.getRDFTypes());
        RDFTypeTestCase.assertContains((Object)clsA, individual.getRDFTypes());
        RDFTypeTestCase.assertContains((Object)clsB, individual.getRDFTypes());
        individual.removeProtegeType(clsA);
        RDFTypeTestCase.assertSize(1, individual.getRDFTypes());
        RDFTypeTestCase.assertContains((Object)clsB, individual.getRDFTypes());
    }

    public void testCreateOWLEnumeratedClass() {
        OWLEnumeratedClass enumeratedClass = this.owlModel.createOWLEnumeratedClass();
        RDFTypeTestCase.assertSize(1, enumeratedClass.getRDFTypes());
        RDFTypeTestCase.assertEquals((Object)this.owlModel.getOWLNamedClassClass(), (Object)enumeratedClass.getRDFType());
    }

    public void testCreateOWLLogicalClass() {
        OWLComplementClass cls = this.owlModel.createOWLComplementClass(this.owlThing);
        RDFTypeTestCase.assertSize(1, cls.getRDFTypes());
        RDFTypeTestCase.assertEquals((Object)this.owlModel.getOWLNamedClassClass(), (Object)cls.getRDFType());
    }

    public void testCreateOWLRestriction() {
        RDFProperty property = this.owlModel.createRDFProperty("property");
        OWLCardinality restriction = this.owlModel.createOWLCardinality(property, 1);
        RDFTypeTestCase.assertSize(1, restriction.getRDFTypes());
        RDFTypeTestCase.assertEquals((Object)this.owlModel.getRDFSNamedClass("owl:Restriction"), (Object)restriction.getRDFType());
    }

    public void testCreateOWLNamedClass() {
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("Test");
        RDFTypeTestCase.assertSize(1, cls.getRDFTypes());
        RDFTypeTestCase.assertEquals((Object)this.owlModel.getRDFSNamedClassClass(), (Object)cls.getRDFType());
    }

    public void testCreateOWLIndividual() {
        OWLIndividual individual = this.owlThing.createOWLIndividual("Test");
        RDFTypeTestCase.assertSize(1, individual.getRDFTypes());
        RDFTypeTestCase.assertEquals((Object)this.owlThing, (Object)individual.getRDFType());
    }

    public void testCreateRDFProperty() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("Test");
        RDFTypeTestCase.assertSize(1, property.getRDFTypes());
        RDFTypeTestCase.assertEquals((Object)this.owlModel.getOWLObjectPropertyClass(), (Object)property.getRDFType());
    }
}

