/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.compactparser.OWLCompactParserUtil;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParseException;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLRestriction;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public abstract class AbstractOWLQuantifierRestriction
extends AbstractOWLRestriction
implements OWLQuantifierRestriction {
    AbstractOWLQuantifierRestriction(KnowledgeBase kb, FrameID id) {
        super(kb, id);
    }

    AbstractOWLQuantifierRestriction() {
    }

    public void checkFillerText(String text) throws Exception {
        RDFProperty property = this.getOnProperty();
        if (property != null) {
            AbstractOWLQuantifierRestriction.checkFillerText(text, property);
        } else {
            AbstractOWLQuantifierRestriction.checkFillerText(text, property, (OWLModel)this.getKnowledgeBase());
        }
    }

    public static void checkFillerText(String text, RDFProperty property) throws OWLClassParseException {
        AbstractOWLQuantifierRestriction.checkFillerText(text, property, property.getOWLModel());
    }

    public static void checkFillerText(String text, RDFProperty property, OWLModel owlModel) throws OWLClassParseException {
        text = OWLCompactParserUtil.preprocessFiller(owlModel, text);
        OWLClassParser parser = owlModel.getOWLClassDisplay().getParser();
        if (text.startsWith("xsd:")) {
            if (property instanceof OWLObjectProperty) {
                throw new OWLClassParseException(String.valueOf(text) + " cannot be applied to object properties");
            }
            parser.checkQuantifierFiller(owlModel, text);
        } else {
            if (property instanceof OWLDatatypeProperty) {
                throw new OWLClassParseException(String.valueOf(text) + " cannot be applied to datatype properties");
            }
            parser.checkClass(owlModel, text);
        }
    }

    public boolean equalsStructurally(RDFObject cls) {
        if (cls instanceof AbstractOWLQuantifierRestriction) {
            AbstractOWLQuantifierRestriction compCls = (AbstractOWLQuantifierRestriction)cls;
            return this.getOperator() == compCls.getOperator() && this.getOnProperty().equalsStructurally(compCls.getOnProperty()) && this.getFiller().equalsStructurally(compCls.getFiller());
        }
        return false;
    }

    public Collection getDependingClasses() {
        if (this.getFiller() instanceof OWLAnonymousClass) {
            return Collections.singleton(this.getFiller());
        }
        return Collections.EMPTY_LIST;
    }

    public RDFResource getFiller() {
        return (RDFResource)this.getPropertyValue(this.getFillerProperty());
    }

    public String getFillerText() {
        RDFResource filler = this.getFiller();
        if (filler != null) {
            return filler.getBrowserText();
        }
        return "";
    }

    public void getNestedNamedClasses(Set set) {
        if (this.getFiller() instanceof RDFSClass) {
            ((RDFSClass)this.getFiller()).getNestedNamedClasses(set);
        }
    }

    public void setFiller(RDFResource filler) {
        this.setPropertyValue(this.getFillerProperty(), filler);
    }

    public void setFillerText(String text) throws Exception {
        OWLModel owlModel = this.getOWLModel();
        OWLClassParser parser = owlModel.getOWLClassDisplay().getParser();
        if ((text = OWLCompactParserUtil.preprocessFiller(owlModel, text)).startsWith("xsd:")) {
            RDFResource valueType = parser.parseQuantifierFiller(owlModel, text);
            if (valueType instanceof RDFSDatatype) {
                this.setFiller((RDFSDatatype)valueType);
            } else {
                OWLDataRange dataRange = this.getOWLModel().createOWLDataRange((RDFSLiteral[])valueType);
                this.setFiller(dataRange);
            }
        } else {
            RDFSClass filler = parser.parseClass(owlModel, text);
            this.setFiller(filler);
        }
    }
}

