/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.forms;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protege.widget.SlotWidget;
import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.ui.forms.AbsoluteFormsGenerator;
import edu.stanford.smi.protegex.owl.ui.forms.AbsoluteLayoutNames;
import edu.stanford.smi.protegex.owl.ui.forms.FormsNames;
import edu.stanford.smi.protegex.owl.ui.forms.ProtegeFormsNames;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;

public class AbsoluteFormsLoader {
    private OWLModel owlModel;
    private Project project;

    public AbsoluteFormsLoader(OWLModel owlModel) {
        this.owlModel = owlModel;
        this.project = owlModel.getProject();
    }

    public void load(URL fileURL) throws IOException {
        InputStream is = fileURL.openStream();
        this.load(is);
    }

    public void load(InputStream is) throws IOException {
        OntModel model = ModelFactory.createOntologyModel();
        model.read(is, "http://dummy.de/aldi.owl", "RDF/XML-ABBREV");
        is.close();
        model.add((Resource)FormsNames.FormWidget, RDF.type, (RDFNode)OWL.Class);
        OntClass formWidgetClass = model.getOntClass(FormsNames.FormWidget.getURI());
        ExtendedIterator formWidgets = formWidgetClass.listInstances();
        while (formWidgets.hasNext()) {
            Resource formWidget = (Resource)formWidgets.next();
            this.addFormWidget(formWidget);
        }
        this.project.clearCachedWidgets();
    }

    public void loadAll() throws Exception {
        File systemFormsFile = new File(ProtegeOWL.getPluginFolder(), "protege-system.forms");
        if (systemFormsFile.exists()) {
            System.out.println("Loading system forms from " + systemFormsFile);
            this.load(new FileInputStream(systemFormsFile));
        }
        Iterator it = this.owlModel.getTripleStoreModel().listUserTripleStores();
        while (it.hasNext()) {
            TripleStore ts = (TripleStore)it.next();
            URI ontologyFileURI = new URI(ts.getName());
            Repository rep = this.owlModel.getRepositoryManager().getRepository(ontologyFileURI);
            String formsFileName = AbsoluteFormsGenerator.getFormsFileURI(ts, this.owlModel);
            URI formsFileURI = new URI(formsFileName);
            if (rep != null) {
                if (!rep.contains(formsFileURI)) continue;
                System.out.println("Adding forms from " + formsFileURI);
                this.load(rep.getInputStream(formsFileURI));
                continue;
            }
            try {
                File file = null;
                if (ts == this.owlModel.getTripleStoreModel().getTopTripleStore()) {
                    formsFileName = String.valueOf(((JenaOWLModel)this.owlModel).getOWLFilePath()) + ".forms";
                    file = new File(formsFileName);
                } else {
                    file = new File(formsFileURI);
                }
                if (!file.exists()) continue;
                System.out.println("Adding forms from " + file);
                this.load(new FileInputStream(file));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addFormWidget(Resource formWidget) {
        Cls cls;
        String forClassURI;
        String forClassName;
        Statement forClassStmt = formWidget.getProperty((Property)FormsNames.forClass);
        if (forClassStmt != null && (forClassName = this.owlModel.getResourceNameForURI(forClassURI = forClassStmt.getResource().getURI())) != null && (cls = this.project.getKnowledgeBase().getCls(forClassName)) != null) {
            ClsWidget clsWidget = this.project.getDesignTimeClsWidget(cls);
            WidgetDescriptor wd = clsWidget.getDescriptor();
            wd.setDirectlyCustomizedByUser(true);
            PropertyList propertyList = wd.getPropertyList();
            StmtIterator widgets = formWidget.listProperties((Property)FormsNames.widgets);
            while (widgets.hasNext()) {
                Statement s = widgets.nextStatement();
                if (s.getResource() == null) continue;
                Resource widgetResource = s.getResource();
                this.addFormWidget(clsWidget, widgetResource);
            }
        }
    }

    private void addFormWidget(ClsWidget clsWidget, Resource widgetResource) {
        Statement forPropertyStmt = widgetResource.getProperty((Property)FormsNames.forProperty);
        String slotName = null;
        if (forPropertyStmt != null) {
            String forPropertyURI = forPropertyStmt.getResource().getURI();
            String forPropertyName = this.owlModel.getResourceNameForURI(forPropertyURI);
            if (forPropertyName != null && this.owlModel.getRDFResource(forPropertyName) instanceof RDFProperty) {
                slotName = forPropertyName;
            }
        } else {
            Statement commentStmt = widgetResource.getProperty(RDFS.comment);
            slotName = commentStmt != null ? commentStmt.getString() : "protege:inferredType";
        }
        if (slotName != null) {
            Slot slot = this.project.getKnowledgeBase().getSlot(slotName);
            String widgetClassName = this.getWidgetClassName(widgetResource);
            if (widgetClassName != null) {
                clsWidget.replaceWidget(slot, widgetClassName);
                SlotWidget slotWidget = clsWidget.getSlotWidget(slot);
                this.setWidgetBounds(slotWidget.getDescriptor(), widgetResource);
            }
        }
    }

    private int getInt(Resource widgetResource, Property property) {
        Statement s = widgetResource.getProperty(property);
        if (s != null) {
            return s.getInt();
        }
        return 0;
    }

    private String getWidgetClassName(Resource widgetResource) {
        Resource type;
        Statement classNameStmt;
        Statement typeStatement = widgetResource.getProperty(RDF.type);
        if (typeStatement != null && (classNameStmt = (type = typeStatement.getResource()).getProperty((Property)ProtegeFormsNames.javaClassName)) != null) {
            return classNameStmt.getString();
        }
        return null;
    }

    private void setWidgetBounds(WidgetDescriptor wd, Resource widgetResource) {
        StmtIterator layoutData = widgetResource.listProperties((Property)FormsNames.layoutData);
        while (layoutData.hasNext()) {
            Resource layoutResource;
            Statement layoutStatement = (Statement)layoutData.next();
            if (layoutStatement.getResource() == null || !(layoutResource = layoutStatement.getResource()).hasProperty(RDF.type, (RDFNode)AbsoluteLayoutNames.AbsoluteLayoutData)) continue;
            int x = this.getInt(layoutResource, (Property)AbsoluteLayoutNames.x);
            int y = this.getInt(layoutResource, (Property)AbsoluteLayoutNames.y);
            int width = this.getInt(layoutResource, (Property)AbsoluteLayoutNames.width);
            int height = this.getInt(layoutResource, (Property)AbsoluteLayoutNames.height);
            wd.setBounds(new Rectangle(x, y, width, height));
        }
    }

    public static void main(String[] args) throws Exception {
        JenaOWLModel owlModel = ProtegeOWL.createJenaOWLModelFromInputStream(new FileInputStream("travel.owl"));
        AbsoluteFormsLoader loader = new AbsoluteFormsLoader(owlModel);
        loader.load(new File("travel.owl.forms").toURL());
    }

    public static boolean useNewFormMechanism_DontUseThisMethod() {
        return ApplicationProperties.getBooleanProperty((String)"NewOWLFormsMechanism", (boolean)false);
    }
}

