/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard;

import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.FileImportPage;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.ImportWizard;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.NullWizardPage;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.RepositoryImportPage;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.URLImportPage;
import edu.stanford.smi.protegex.owl.ui.wizard.OWLWizard;
import edu.stanford.smi.protegex.owl.ui.wizard.OWLWizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ImportTypePage
extends OWLWizardPage
implements ActionListener {
    private JRadioButton webRadioButton;
    private JRadioButton repRadioButton;
    private JRadioButton locRadioButton;
    private static final String HELP_TEXT = "<p>Please specify where you would like to import an ontology from.</p><p>The system can either import an ontology directly from the web, import an ontology contained in a local file, or import an ontology that is contained in one of the available ontology repositories.</p>";
    private static final String IMPORT_FROM_WEB_TEXT = "Import an ontology from the web by specifying the http://... URL";
    private static final String IMPORT_FROM_REP_TEXT = "Import an ontology contained in one of the available repositories";
    private static final String IMPORT_FROM_FILE_TEXT = "Import an ontology contained in a specific local file.";

    public ImportTypePage(OWLWizard wizard) {
        super("Import type", wizard);
        this.createUI();
    }

    private void createUI() {
        this.setHelpText("Import methods", HELP_TEXT);
        JPanel northPanel = new JPanel(new BorderLayout(7, 7));
        northPanel.add((Component)new JLabel("Please specify how you would like Protege-OWL to obtain the ontology to be imported:"), "North");
        this.webRadioButton = new JRadioButton(IMPORT_FROM_WEB_TEXT);
        this.webRadioButton.addActionListener(this);
        this.repRadioButton = new JRadioButton(IMPORT_FROM_REP_TEXT);
        this.repRadioButton.addActionListener(this);
        this.locRadioButton = new JRadioButton(IMPORT_FROM_FILE_TEXT);
        this.locRadioButton.addActionListener(this);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.webRadioButton);
        bg.add(this.locRadioButton);
        bg.add(this.repRadioButton);
        this.webRadioButton.setSelected(true);
        Box box = new Box(1);
        box.add(this.webRadioButton);
        box.add(this.locRadioButton);
        box.add(this.repRadioButton);
        box.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        northPanel.add((Component)box, "South");
        this.getContentComponent().add((Component)northPanel, "North");
    }

    public void actionPerformed(ActionEvent e) {
        this.updateNextPage();
    }

    public WizardPage getNextPage() {
        if (this.webRadioButton.isSelected()) {
            return new URLImportPage((ImportWizard)this.getWizard());
        }
        if (this.repRadioButton.isSelected()) {
            return new RepositoryImportPage((ImportWizard)this.getWizard());
        }
        if (this.locRadioButton.isSelected()) {
            return new FileImportPage((ImportWizard)this.getWizard());
        }
        return new NullWizardPage((ImportWizard)this.getWizard());
    }

    public void nextPressed() {
        ((ImportWizard)this.getWizard()).reset();
    }

    public static void main(String[] args) {
        JenaOWLModel model = ProtegeOWL.createJenaOWLModel();
        ImportWizard w = new ImportWizard(null, model);
        ImportTypePage page = new ImportTypePage(w);
        w.addPage(page);
        w.execute();
    }
}

