/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser.tests;

import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Collection;

public class LoadRDFSDomainTestCase
extends AbstractJenaTestCase {
    public void testLoadUnionDomain() throws Exception {
        OWLNamedClass oldPersonClass = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass oldCorporationClass = this.owlModel.createOWLNamedClass("Corporation");
        OWLObjectProperty oldProperty = this.owlModel.createOWLObjectProperty("hasBankAccount");
        oldProperty.setDomain(oldPersonClass);
        oldProperty.addUnionDomainClass(oldCorporationClass);
        Collection oldDomain = oldProperty.getDirectDomain();
        LoadRDFSDomainTestCase.assertSize(2, oldDomain);
        LoadRDFSDomainTestCase.assertContains((Object)oldPersonClass, oldDomain);
        LoadRDFSDomainTestCase.assertContains((Object)oldCorporationClass, oldDomain);
        Jena.dumpRDF(this.owlModel.getOntModel());
        JenaOWLModel newModel = LoadRDFSDomainTestCase.reload(this.owlModel);
        OWLNamedClass newPersonClass = newModel.getOWLNamedClass(oldPersonClass.getName());
        OWLNamedClass newCorporationClass = newModel.getOWLNamedClass(oldCorporationClass.getName());
        OWLObjectProperty newProperty = newModel.getOWLObjectProperty(oldProperty.getName());
        OWLUnionClass unionDomain = (OWLUnionClass)newProperty.getDomain(false);
        LoadRDFSDomainTestCase.assertSize(2, unionDomain.getOperands());
        LoadRDFSDomainTestCase.assertContains((Object)newPersonClass, unionDomain.getOperands());
        LoadRDFSDomainTestCase.assertContains((Object)newCorporationClass, unionDomain.getOperands());
        Collection newDomain = newProperty.getDirectDomain();
        LoadRDFSDomainTestCase.assertSize(2, newDomain);
        LoadRDFSDomainTestCase.assertContains((Object)newPersonClass, newDomain);
        LoadRDFSDomainTestCase.assertContains((Object)newCorporationClass, newDomain);
    }

    public void testLoadInheritedDomain() throws Exception {
        this.loadRemoteOntology("inheritedDomain.owl");
        OWLProperty subProperty = this.owlModel.getOWLProperty("subSlot");
        LoadRDFSDomainTestCase.assertNull((Object)subProperty.getDirectOwnSlotValue(this.owlModel.getSlot(":DIRECT-DOMAIN")));
    }
}

