/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore.tests;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Arrays;
import java.util.List;

public class DeleteClassTestCase
extends AbstractJenaTestCase {
    public void testJimWang() {
        OWLNamedClass superCls = this.owlModel.createOWLNamedSubclass("SuperCls", this.owlModel.getOWLThingClass());
        OWLNamedClass otherCls = this.owlModel.createOWLNamedClass("OtherCls");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        int oldCount = this.owlModel.getClsCount();
        OWLNamedClass subCls = this.owlModel.createOWLNamedSubclass("SubCls", superCls);
        subCls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, otherCls));
        subCls.delete();
        DeleteClassTestCase.assertEquals((int)oldCount, (int)this.owlModel.getClsCount());
    }

    public void testDeleteClsWithAllRestriction() {
        OWLNamedClass personClass = this.owlModel.createOWLNamedClass("Person");
        OWLObjectProperty childrenProperty = this.owlModel.createOWLObjectProperty("children");
        childrenProperty.addUnionDomainClass(personClass);
        OWLNamedClass girlClass = this.owlModel.createOWLNamedClass("Girl");
        OWLNamedClass personWithAntiDaughtersClass = this.owlModel.createOWLNamedClass("PersonWithAntiDaughters");
        OWLComplementClass complementCls = this.owlModel.createOWLComplementClass(girlClass);
        OWLAllValuesFrom allRestriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)childrenProperty, complementCls);
        personWithAntiDaughtersClass.addSuperclass(allRestriction);
        int oldFrameCount = this.owlModel.getFrameCount();
        personWithAntiDaughtersClass.delete();
        DeleteClassTestCase.assertEquals((int)(oldFrameCount - 3), (int)this.owlModel.getFrameCount());
    }

    public void testDeleteAnonymousEquivalentClass() {
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass girlCls = this.owlModel.createOWLNamedClass("Girl");
        OWLComplementClass complementCls = this.owlModel.createOWLComplementClass(girlCls);
        personCls.addEquivalentClass(complementCls);
        int oldFrameCount = this.owlModel.getFrameCount();
        personCls.removeEquivalentClass(complementCls);
        DeleteClassTestCase.assertEquals((int)(oldFrameCount - 1), (int)this.owlModel.getFrameCount());
    }

    public void testDeleteEnumerations() {
        OWLNamedClass colorCls = this.owlModel.createOWLNamedClass("Color");
        Instance red = this.owlModel.createInstance("Red", colorCls);
        Instance green = this.owlModel.createInstance("Green", colorCls);
        OWLNamedClass trafficLightColors = this.owlModel.createOWLNamedClass("TLC");
        List<Instance> instances = Arrays.asList(red, green);
        OWLEnumeratedClass enumerationCls = this.owlModel.createOWLEnumeratedClass(instances);
        trafficLightColors.addEquivalentClass(enumerationCls);
        int oldFrameCount = this.owlModel.getFrameCount();
        trafficLightColors.removeEquivalentClass(enumerationCls);
        DeleteClassTestCase.assertEquals((int)(oldFrameCount - 3), (int)this.owlModel.getFrameCount());
    }

    public void testDeleteDefinedEnumeration() {
        int oldFrameCount = this.owlModel.getFrameCount();
        OWLNamedClass colorCls = this.owlModel.createOWLNamedClass("Color");
        Instance red = this.owlModel.createInstance("Red", colorCls);
        Instance green = this.owlModel.createInstance("Green", colorCls);
        List<Instance> instances = Arrays.asList(red, green);
        OWLEnumeratedClass enumerationCls = this.owlModel.createOWLEnumeratedClass(instances);
        colorCls.addEquivalentClass(enumerationCls);
        red.delete();
        green.delete();
        DeleteClassTestCase.assertEquals((int)0, (int)colorCls.getInstances(true).size());
        DeleteClassTestCase.assertEquals((int)0, (int)enumerationCls.getInstances(true).size());
        colorCls.delete();
        DeleteClassTestCase.assertEquals((int)oldFrameCount, (int)this.owlModel.getFrameCount());
    }

    public void testDeleteSubclassesAutomatically() {
        int classCount = this.owlModel.getClsCount();
        OWLNamedClass superclass = this.owlModel.createOWLNamedClass("Superclass");
        this.owlModel.createOWLNamedSubclass("Subclass", superclass);
        superclass.delete();
        DeleteClassTestCase.assertEquals((int)classCount, (int)this.owlModel.getClsCount());
    }

    public void testDeleteClassWithNestedRestrictions() {
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("slot");
        OWLNamedClass otherCls = this.owlModel.createOWLNamedClass("OtherCls");
        OWLNamedClass cls = this.owlModel.createOWLNamedSubclass("Cls", otherCls);
        int oldFrameCount = this.owlModel.getFrameCount();
        OWLNamedClass superCls = this.owlModel.createOWLNamedClass("SuperCls");
        OWLNamedClass subClsA = this.owlModel.createOWLNamedSubclass("SubClsA", superCls);
        OWLNamedClass subClsB = this.owlModel.createOWLNamedSubclass("SubClsB", superCls);
        OWLUnionClass unionCls = this.owlModel.createOWLUnionClass();
        unionCls.addOperand(subClsB);
        unionCls.addOperand(subClsA);
        superCls.addEquivalentClass(unionCls);
        DeleteClassTestCase.assertSize(1, cls.getSuperclasses(false));
        OWLSomeValuesFrom nestedRestriction = this.owlModel.createOWLSomeValuesFrom((RDFProperty)slot, subClsA);
        OWLSomeValuesFrom restriction = this.owlModel.createOWLSomeValuesFrom((RDFProperty)slot, nestedRestriction);
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(otherCls);
        intersectionCls.addOperand(restriction);
        cls.addEquivalentClass(intersectionCls);
        DeleteClassTestCase.assertSize(2, cls.getSuperclasses(false));
        superCls.delete();
        DeleteClassTestCase.assertSize(1, cls.getSuperclasses(false));
        DeleteClassTestCase.assertEquals((int)oldFrameCount, (int)this.owlModel.getFrameCount());
    }

    public void testDeleteSubclasses() {
        int classCount = this.owlModel.getClsCount();
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Super");
        OWLNamedClass subCls = this.owlModel.createOWLNamedSubclass("Sub", cls);
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("slot");
        subCls.addSuperclass(this.owlModel.createOWLMinCardinality(slot, 1));
        cls.delete();
        DeleteClassTestCase.assertEquals((int)classCount, (int)this.owlModel.getClsCount());
    }

    public void testDeleteClassUsedInDomains() {
        OWLNamedClass clsA = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass clsB = this.owlModel.createOWLNamedClass("B");
        OWLNamedClass clsC = this.owlModel.createOWLNamedClass("C");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLUnionClass unionClass = this.owlModel.createOWLUnionClass();
        unionClass.addOperand(clsA);
        unionClass.addOperand(clsB);
        unionClass.addOperand(clsC);
        property.setDomain(unionClass);
        clsB.delete();
        RDFSClass newDomain = property.getDomain(false);
        DeleteClassTestCase.assertTrue((boolean)(newDomain instanceof OWLUnionClass));
        OWLUnionClass newUnionClass = (OWLUnionClass)newDomain;
        DeleteClassTestCase.assertContains((Object)clsA, newUnionClass.getOperands());
        DeleteClassTestCase.assertContains((Object)clsC, newUnionClass.getOperands());
        DeleteClassTestCase.assertSize(2, newUnionClass.getOperands());
    }
}

