/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix.property;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.table.TableCellRenderer;

public class PropertyCharacteristicsMatrixColumn
implements MatrixColumn {
    public TableCellRenderer getCellRenderer() {
        return new FrameRenderer(){

            protected void loadSlot(Slot slot) {
                RDFProperty rdfProperty = (RDFProperty)slot;
                this.setGrayedSecondaryText(false);
                String text = PropertyCharacteristicsMatrixColumn.this.getText(rdfProperty);
                if (text.length() > 0) {
                    this.addText(text);
                }
            }
        };
    }

    private String getText(RDFProperty rdfProperty) {
        Iterator it;
        String str;
        Collection supers;
        Collection equis;
        ArrayList<String> cs = new ArrayList<String>();
        if (rdfProperty.isFunctional()) {
            cs.add("Functional");
        }
        if (rdfProperty instanceof OWLProperty) {
            if (((OWLProperty)rdfProperty).isInverseFunctional()) {
                cs.add("InverseFunctional");
            }
            if (rdfProperty instanceof OWLObjectProperty) {
                OWLObjectProperty objectSlot = (OWLObjectProperty)rdfProperty;
                if (objectSlot.isSymmetric()) {
                    cs.add("Symmetric");
                }
                if (objectSlot.isTransitive()) {
                    cs.add("Transitive");
                }
            }
        }
        if (!(equis = rdfProperty.getEquivalentProperties()).isEmpty()) {
            String str2 = "Equivalents: {";
            Iterator it2 = equis.iterator();
            while (it2.hasNext()) {
                Slot equi = (Slot)it2.next();
                str2 = String.valueOf(str2) + equi.getBrowserText();
                if (!it2.hasNext()) continue;
                str2 = String.valueOf(str2) + ", ";
            }
            str2 = String.valueOf(str2) + "}";
            cs.add(str2);
        }
        if (!(supers = rdfProperty.getSuperproperties(false)).isEmpty()) {
            str = "Super properties: {";
            it = supers.iterator();
            while (it.hasNext()) {
                Slot equi = (Slot)it.next();
                str = String.valueOf(str) + equi.getBrowserText();
                if (!it.hasNext()) continue;
                str = String.valueOf(str) + ", ";
            }
            str = String.valueOf(str) + "}";
            cs.add(str);
        }
        str = "";
        if (!cs.isEmpty()) {
            it = cs.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                str = String.valueOf(str) + s;
                if (!it.hasNext()) continue;
                str = String.valueOf(str) + ", ";
            }
        }
        return str;
    }

    public String getName() {
        return "Other Characteristics";
    }

    public int getWidth() {
        return 400;
    }
}

